/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.teneo.PackageRegistryProvider;
import org.eclipse.emf.teneo.annotations.mapper.PersistenceFileProvider;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEClass;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEPackage;
import org.eclipse.emf.teneo.extension.ExtensionManager;
import org.eclipse.emf.teneo.hibernate.HbBaseSessionDataStore;
import org.eclipse.emf.teneo.hibernate.HbMapperException;
import org.eclipse.emf.teneo.hibernate.HbSessionWrapper;
import org.eclipse.emf.teneo.hibernate.HbStoreException;
import org.eclipse.emf.teneo.hibernate.SessionWrapper;
import org.eclipse.emf.teneo.hibernate.mapper.MappingUtil;
import org.eclipse.emf.teneo.hibernate.mapping.EMFInitializeCollectionEventListener;
import org.eclipse.emf.teneo.hibernate.mapping.eav.EAVGenericIDUserType;
import org.hibernate.Interceptor;
import org.hibernate.cfg.Configuration;
import org.hibernate.event.InitializeCollectionEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HbSessionDataStore
extends HbBaseSessionDataStore {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog(HbSessionDataStore.class);
    private Configuration hbConfiguration;

    @Override
    public void initialize() {
        MappingUtil.registerHbExtensions((ExtensionManager)this.getExtensionManager());
        PackageRegistryProvider.getInstance().setThreadPackageRegistry(this.getPackageRegistry());
        try {
            log.debug((Object)"Initializing Hb Session DataStore");
            if (this.getEPackages() == null) {
                throw new HbMapperException("EPackages are not set");
            }
            this.setInterceptor(null);
            log.debug((Object)">>>>> Creating HB Configuration");
            this.hbConfiguration = this.createConfiguration();
            this.mapModel();
            this.setPropertiesInConfiguration();
            this.initializeDataStore();
            this.closeSessionFactory();
            this.buildSessionFactory();
            this.setInitialized(true);
        }
        finally {
            PackageRegistryProvider.getInstance().setThreadPackageRegistry(null);
        }
    }

    @Override
    protected void setEventListeners() {
        EMFInitializeCollectionEventListener eventListener = (EMFInitializeCollectionEventListener)((Object)this.getExtensionManager().getExtension(EMFInitializeCollectionEventListener.class));
        this.getConfiguration().getEventListeners().setInitializeCollectionEventListeners(new InitializeCollectionEventListener[]{eventListener});
    }

    protected Configuration createConfiguration() {
        return new Configuration();
    }

    @Override
    public Iterator<?> getClassMappings() {
        return this.getConfiguration().getClassMappings();
    }

    @Override
    protected void buildMappings() {
        this.getConfiguration().buildMappings();
    }

    @Override
    protected void setInterceptor() {
        if (this.getInterceptor() != null) {
            return;
        }
        Interceptor interceptor = this.getHbContext().createInterceptor(this.getHibernateConfiguration(), this.getEntityNameStrategy());
        this.getConfiguration().setInterceptor(interceptor);
        this.setInterceptor(interceptor);
    }

    protected void setPropertiesInConfiguration() {
        Properties properties = this.getProperties();
        if (properties != null) {
            this.setDefaultProperties(properties);
            this.getConfiguration().addProperties(properties);
        }
    }

    protected void mapModel() {
        if (this.getPersistenceOptions().getMappingFilePath() != null || this.getPersistenceOptions().isUseMappingFile()) {
            String[] fileList;
            String[] stringArray = fileList = this.getMappingFileList();
            int n = fileList.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                log.debug((Object)("Adding file " + element + " to Hibernate Configuration"));
                PersistenceFileProvider pfp = (PersistenceFileProvider)this.getExtensionManager().getExtension(PersistenceFileProvider.class);
                InputStream is = pfp.getFileContent(this.getClass(), element);
                if (is == null) {
                    throw new HbStoreException("Path to mapping file: " + element + " does not exist!");
                }
                this.getConfiguration().addInputStream(is);
                ++n2;
            }
        } else {
            this.setMappingXML(this.mapEPackages());
            boolean hasEAVMapping = false;
            block3: for (PAnnotatedEPackage aPackage : this.getPaModel().getPaEPackages()) {
                for (PAnnotatedEClass aClass : aPackage.getPaEClasses()) {
                    if (aClass.getEavMapping() == null) continue;
                    hasEAVMapping = true;
                    continue block3;
                }
            }
            if (hasEAVMapping) {
                try {
                    InputStream is;
                    PersistenceFileProvider pfp;
                    if (this.getPersistenceOptions().getEAVMappingFile() != null) {
                        pfp = (PersistenceFileProvider)this.getExtensionManager().getExtension(PersistenceFileProvider.class);
                        is = pfp.getFileContent(this.getClass(), this.getPersistenceOptions().getEAVMappingFile());
                        this.getConfiguration().addXML(this.processEAVMapping(is));
                        is.close();
                    } else {
                        pfp = (PersistenceFileProvider)this.getExtensionManager().getExtension(PersistenceFileProvider.class);
                        is = pfp.getFileContent(EAVGenericIDUserType.class, "eav.hbm.xml");
                        this.getConfiguration().addXML(this.processEAVMapping(is));
                        is.close();
                    }
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
            this.getConfiguration().addXML(this.getMappingXML());
        }
    }

    protected void buildSessionFactory() {
        this.setSessionFactory(this.getConfiguration().buildSessionFactory());
    }

    @Override
    public SessionWrapper createSessionWrapper() {
        return new HbSessionWrapper(this);
    }

    public Configuration getConfiguration() {
        return this.hbConfiguration;
    }

    @Override
    public Configuration getHibernateConfiguration() {
        return this.getConfiguration();
    }
}

