/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.mapping.strategy;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.teneo.PersistenceOptions;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEAttribute;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEClass;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEStructuralFeature;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedModel;
import org.eclipse.emf.teneo.mapping.strategy.EntityNameStrategy;
import org.eclipse.emf.teneo.util.StoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrategyUtil {
    public static String getEntityName(EntityNameStrategy ens, PersistenceOptions po, PAnnotatedModel paModel, EClass eclass) {
        PAnnotatedEClass aclass;
        if (eclass == null) {
            throw new IllegalArgumentException("Passed eclass is null.This can occur if epackages which refer to eachother are placed in different ecore/xsd files and they are not read using one resource set. The reference from one epackage to another must be resolvable by EMF.");
        }
        PAnnotatedEClass pAnnotatedEClass = aclass = paModel != null ? paModel.getPAnnotated(eclass) : null;
        if (aclass == null && paModel != null) {
            return ens.toEntityName(eclass);
        }
        if (po.isMapEMapAsTrueMap() && StoreUtil.isMapEntry(eclass)) {
            EStructuralFeature feature = eclass.getEStructuralFeature("value");
            if (feature instanceof EReference) {
                return StrategyUtil.getEntityName(ens, po, paModel, ((EReference)feature).getEReferenceType());
            }
            return ((EAttribute)feature).getEType().getInstanceClassName();
        }
        return ens.toEntityName(eclass);
    }

    public static List<String> getIDFeaturesNames(PAnnotatedEClass aClass, String optionDefaultIDFeatureName) {
        return StrategyUtil.getIDFeaturesNames(aClass, optionDefaultIDFeatureName, null);
    }

    public static List<String> getIDFeaturesNames(PAnnotatedEClass aClass, String optionDefaultIDFeatureName, PersistenceOptions po) {
        List<String> list = StrategyUtil.getIDFeaturesNamesRecurse(aClass, po);
        if (list.isEmpty()) {
            list.add(optionDefaultIDFeatureName);
        }
        return list;
    }

    private static List<String> getIDFeaturesNamesRecurse(PAnnotatedEClass aClass, PersistenceOptions po) {
        boolean useIDFeatures = po != null ? po.isIDFeatureAsPrimaryKey() : false;
        ArrayList<String> list = new ArrayList<String>();
        for (EStructuralFeature feature : aClass.getModelEClass().getEStructuralFeatures()) {
            PAnnotatedEAttribute aAttribute;
            String attrName;
            PAnnotatedEStructuralFeature aStructuralFeature = aClass.getPaModel().getPAnnotated(feature);
            if (!(aStructuralFeature instanceof PAnnotatedEAttribute) || list.contains(attrName = (aAttribute = (PAnnotatedEAttribute)aStructuralFeature).getModelEAttribute().getName())) continue;
            if (aAttribute.getId() != null) {
                list.add(attrName);
                continue;
            }
            if (!useIDFeatures || !aAttribute.getModelEAttribute().isID()) continue;
            list.add(attrName);
        }
        if (list.isEmpty() && aClass.getModelEClass().getESuperTypes().size() > 0) {
            for (EClass eClass : aClass.getModelEClass().getESuperTypes()) {
                PAnnotatedEClass aSuperClass = aClass.getPaModel().getPAnnotated(eClass);
                if (aSuperClass != null) {
                    List<String> superList = StrategyUtil.getIDFeaturesNamesRecurse(aSuperClass, po);
                    list.removeAll(superList);
                    list.addAll(superList);
                }
                if (list.isEmpty()) continue;
                return list;
            }
            if (!list.isEmpty()) {
                return list;
            }
        }
        return list;
    }
}

