/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.mapping.elist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.DelegatingFeatureMap;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.teneo.TeneoException;
import org.eclipse.emf.teneo.mapping.elist.PersistableDelegateList;
import org.eclipse.emf.teneo.type.FeatureMapEntry;
import org.eclipse.emf.teneo.util.AssertUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PersistableFeatureMap
extends DelegatingFeatureMap
implements PersistableDelegateList<FeatureMap.Entry> {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog(PersistableFeatureMap.class);
    protected List<FeatureMap.Entry> delegate;
    private boolean isLoaded = false;
    private boolean isLoading = false;
    protected final String logString;
    private final Class<? extends FeatureMap.Entry> elementType = this.determineElementType();

    public PersistableFeatureMap(InternalEObject owner, EStructuralFeature feature, List<FeatureMap.Entry> list) {
        super(owner, feature);
        if (list == null) {
            this.delegate = new ArrayList<FeatureMap.Entry>();
            this.isLoaded = true;
        } else if (list instanceof EList) {
            AssertUtil.assertTrue("The passed elist is not a featuremap but a : " + list.getClass().getName() + ". Error in featureMap: " + this.getLogString(), list instanceof FeatureMap);
            this.delegate = this.replaceEntryAll(list);
            this.isLoaded = true;
        } else {
            this.delegate = list;
            this.isLoaded = list.size() > 0;
        }
        this.logString = "FeatureMap of member " + this.getEStructuralFeature().getName() + " owned by " + owner.getClass().getName() + " with delegate list " + this.delegate.getClass().getName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created persistable featuremap " + this.logString));
        }
    }

    protected abstract Class<? extends FeatureMap.Entry> determineElementType();

    public Class<? extends FeatureMap.Entry> getElementType() {
        return this.elementType;
    }

    protected FeatureMap.Entry replaceEntry(FeatureMap.Entry entry) {
        if (entry instanceof FeatureMapEntry && ((FeatureMapEntry)entry).belongsToFeatureMap((FeatureMap.Internal)this)) {
            return entry;
        }
        FeatureMap.Entry emfEntry = entry;
        return this.createEntry(emfEntry.getEStructuralFeature(), emfEntry.getValue());
    }

    private List<FeatureMap.Entry> replaceEntryAll(Collection<? extends FeatureMap.Entry> coll) {
        ArrayList<FeatureMap.Entry> result = new ArrayList<FeatureMap.Entry>();
        for (FeatureMap.Entry entry : coll) {
            result.add(this.replaceEntry(entry));
        }
        return result;
    }

    protected TeneoException createException(String msg) {
        return new TeneoException(String.valueOf(msg) + "\n" + this.getLogString());
    }

    protected TeneoException createException(String msg, Throwable t) {
        return new TeneoException(String.valueOf(msg) + "\n" + this.getLogString(), t);
    }

    @Override
    public List<FeatureMap.Entry> getDelegate() {
        return this.delegate;
    }

    protected List<FeatureMap.Entry> delegateList() {
        this.load();
        return this.delegate;
    }

    public void replaceDelegate(List<FeatureMap.Entry> newDelegate) {
        AssertUtil.assertTrue("This featuremap " + this.logString + " already wraps an or specific featuremap", !this.isPersistencyWrapped());
        this.delegate = newDelegate;
        this.isLoaded = false;
    }

    public String getLogString() {
        return this.logString;
    }

    protected void load() {
        if (this.isLoaded) {
            return;
        }
        if (this.isLoading) {
            return;
        }
        this.isLoading = true;
        this.doLoad();
        this.isLoaded = true;
        this.isLoading = false;
    }

    protected boolean isNotificationRequired() {
        if (!this.isLoaded() || this.isLoading()) {
            return false;
        }
        return super.isNotificationRequired();
    }

    @Override
    public boolean isLoaded() {
        return this.isLoaded;
    }

    public void setIsLoaded(boolean isLoaded) {
        this.isLoaded = isLoaded;
    }

    public void setIsLoading(boolean isLoading) {
        this.isLoading = isLoading;
    }

    public boolean isLoading() {
        return this.isLoading;
    }

    protected abstract void doLoad();

    public abstract boolean isPersistencyWrapped();

    protected abstract FeatureMap.Entry createEntry(EStructuralFeature var1, Object var2);

    protected void delegateAdd(int index, FeatureMap.Entry object) {
        this.load();
        super.delegateAdd(index, (Object)object);
    }

    protected void delegateAdd(FeatureMap.Entry object) {
        this.load();
        super.delegateAdd((Object)object);
    }

    public boolean addAllUnique(Collection<? extends FeatureMap.Entry> collection) {
        return super.addAllUnique(this.replaceEntryAll(collection));
    }

    public boolean addAllUnique(int index, Collection<? extends FeatureMap.Entry> collection) {
        return super.addAllUnique(index, this.replaceEntryAll(collection));
    }

    public void addUnique(int index, FeatureMap.Entry object) {
        super.addUnique(index, (Object)this.replaceEntry(object));
    }

    public void addUnique(FeatureMap.Entry object) {
        super.addUnique(this.replaceEntry(object));
    }

    public FeatureMap.Entry setUnique(int index, FeatureMap.Entry object) {
        return (FeatureMap.Entry)super.setUnique(index, (Object)this.replaceEntry(object));
    }

    protected List<FeatureMap.Entry> delegateBasicList() {
        this.load();
        return super.delegateBasicList();
    }

    protected void delegateClear() {
        this.load();
        super.delegateClear();
    }

    protected boolean delegateContains(Object object) {
        this.load();
        return super.delegateContains(object);
    }

    protected boolean delegateContainsAll(Collection<?> collection) {
        this.load();
        return super.delegateContainsAll(collection);
    }

    protected boolean delegateEquals(Object object) {
        this.load();
        return super.delegateEquals(object);
    }

    protected FeatureMap.Entry delegateGet(int index) {
        this.load();
        return (FeatureMap.Entry)super.delegateGet(index);
    }

    protected int delegateHashCode() {
        this.load();
        return super.delegateHashCode();
    }

    protected int delegateIndexOf(Object object) {
        this.load();
        return super.delegateIndexOf(object);
    }

    protected boolean delegateIsEmpty() {
        this.load();
        return super.delegateIsEmpty();
    }

    protected Iterator<FeatureMap.Entry> delegateIterator() {
        this.load();
        return super.delegateIterator();
    }

    protected int delegateLastIndexOf(Object object) {
        this.load();
        return super.delegateLastIndexOf(object);
    }

    protected ListIterator<FeatureMap.Entry> delegateListIterator() {
        return super.delegateListIterator();
    }

    protected FeatureMap.Entry delegateRemove(int index) {
        this.load();
        return (FeatureMap.Entry)super.delegateRemove(index);
    }

    protected FeatureMap.Entry delegateSet(int index, FeatureMap.Entry object) {
        this.load();
        FeatureMap.Entry old = this.delegateRemove(index);
        this.delegateAdd(index, object);
        return old;
    }

    protected int delegateSize() {
        this.load();
        return super.delegateSize();
    }

    protected Object[] delegateToArray() {
        this.load();
        return super.delegateToArray();
    }

    protected <T> T[] delegateToArray(T[] array) {
        this.load();
        return super.delegateToArray((Object[])array);
    }

    protected String delegateToString() {
        this.load();
        return super.delegateToString();
    }

    public boolean equals(Object object) {
        return this == object;
    }
}

