/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.annotations.mapper;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.teneo.annotations.mapper.BaseEFeatureAnnotator;
import org.eclipse.emf.teneo.annotations.mapper.StoreMappingException;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEReference;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEStructuralFeature;
import org.eclipse.emf.teneo.annotations.pannotation.CascadeType;
import org.eclipse.emf.teneo.annotations.pannotation.OneToOne;
import org.eclipse.emf.teneo.extension.ExtensionPoint;

public class OneToOneReferenceAnnotator
extends BaseEFeatureAnnotator
implements ExtensionPoint {
    protected static final Log log = LogFactory.getLog(OneToOneReferenceAnnotator.class);

    public void annotate(PAnnotatedEReference aReference) {
        String logStr = String.valueOf(aReference.getModelEReference().getName()) + "/" + aReference.getModelEReference().getEContainingClass().getName();
        if (aReference.getOneToMany() != null || aReference.getManyToMany() != null || aReference.getManyToOne() != null) {
            throw new StoreMappingException("The feature/eclass " + logStr + " should be a OneToOne but " + "it already has a OneToMany, ManyToMany or ManyToOne annotation");
        }
        EReference eReference = (EReference)aReference.getModelElement();
        OneToOne oto = aReference.getOneToOne();
        if (oto == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("EReference + " + logStr + " does not have a onetoone annotation, adding one"));
            }
            oto = this.getFactory().createOneToOne();
            aReference.setOneToOne(oto);
            oto.setOptional(!eReference.isRequired());
            oto.setEModelElement((EModelElement)eReference);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("EReference + " + logStr + " has an onetoone annotation setting defaults if required"));
        }
        if (!oto.isSetFetch()) {
            oto.setFetch(this.getFetch(aReference.getAReferenceType()));
        }
        if (oto.getMappedBy() == null && this.setMappedBy(eReference)) {
            oto.setMappedBy(eReference.getEOpposite().getName());
        }
        if (oto.getCascade().isEmpty() && eReference.isContainment() && this.getPersistenceOptions().isSetCascadeAllOnContainment()) {
            oto.setOrphanRemoval(true);
        }
        if (this.getPersistenceOptions().isSetForeignKeyNames() && aReference.getForeignKey() == null) {
            if (eReference.getEOpposite() != null && !eReference.getEOpposite().isTransient()) {
                PAnnotatedEReference aOpposite = aReference.getPaModel().getPAnnotated(eReference.getEOpposite());
                if (aOpposite == null || aOpposite.getTransient() != null) {
                    aReference.setForeignKey(this.createFK((PAnnotatedEStructuralFeature)aReference));
                }
            } else {
                aReference.setForeignKey(this.createFK((PAnnotatedEStructuralFeature)aReference));
            }
        }
        this.setCascade((List<CascadeType>)oto.getCascade(), eReference.isContainment());
        if (this.getPersistenceOptions().isMapEmbeddableAsEmbedded() && aReference.getAReferenceType().getEmbeddable() != null) {
            aReference.setEmbedded(this.getFactory().createEmbedded());
        }
        if (oto.getTargetEntity() == null) {
            if (aReference.getAReferenceType() != null && aReference.getAReferenceType().getEntity() != null && aReference.getAReferenceType().getEntity().getName() != null) {
                oto.setTargetEntity(aReference.getAReferenceType().getEntity().getName());
            } else {
                oto.setTargetEntity(this.getEntityName(eReference.getEReferenceType()));
            }
        }
    }
}

