/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapping.identifier;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoggingThreadFactory
implements ThreadFactory {
    private static final Thread.UncaughtExceptionHandler eh = new LoggingUncaughtExceptionHandler();
    private final String name;

    public LoggingThreadFactory(String name) {
        this.name = name;
    }

    public Thread newThread(Runnable r) {
        ThreadFactory defaultThreadFactory = Executors.defaultThreadFactory();
        Thread thread = defaultThreadFactory.newThread(r);
        thread.setUncaughtExceptionHandler(eh);
        thread.setDaemon(true);
        thread.setName(String.valueOf(this.name) + "-" + thread.getId());
        return thread;
    }

    static class LoggingUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        LoggingUncaughtExceptionHandler() {
        }

        public void uncaughtException(Thread t, Throwable e) {
            Log log = LogFactory.getLog(t.getClass());
            log.error((Object)("Uncaught exception occured in thread '" + t.getName() + "'. " + "Thread has been terminated.\n"), e);
        }
    }
}

