/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.tuplizer;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.teneo.hibernate.HbDataStore;
import org.eclipse.emf.teneo.hibernate.HbHelper;
import org.eclipse.emf.teneo.hibernate.HbMapperException;
import org.eclipse.emf.teneo.hibernate.HbStoreException;
import org.eclipse.emf.teneo.hibernate.HbUtil;
import org.eclipse.emf.teneo.hibernate.mapping.eav.EAVInstantiator;
import org.eclipse.emf.teneo.hibernate.mapping.eav.EAVPropertyHandler;
import org.eclipse.emf.teneo.hibernate.mapping.identifier.IdentifierCacheHandler;
import org.eclipse.emf.teneo.hibernate.mapping.internal.TeneoInternalEObject;
import org.eclipse.emf.teneo.hibernate.tuplizer.EMFInstantiator;
import org.hibernate.EntityMode;
import org.hibernate.EntityNameResolver;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Environment;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Subclass;
import org.hibernate.metamodel.binding.AttributeBinding;
import org.hibernate.metamodel.binding.EntityBinding;
import org.hibernate.property.Getter;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.property.Setter;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.ProxyFactory;
import org.hibernate.tuple.Instantiator;
import org.hibernate.tuple.entity.AbstractEntityTuplizer;
import org.hibernate.tuple.entity.EntityMetamodel;
import org.hibernate.type.CompositeType;

public class EMFTuplizer
extends AbstractEntityTuplizer {
    private static Log log = LogFactory.getLog(EMFTuplizer.class);
    private Class<?> mappedClass;
    private PersistentClass persistentClass;

    public EMFTuplizer(EntityMetamodel entityMetamodel, PersistentClass mappedEntity) {
        super(entityMetamodel, mappedEntity);
        this.mappedClass = mappedEntity.getMappedClass() != null ? mappedEntity.getMappedClass() : EObject.class;
        this.persistentClass = mappedEntity;
    }

    public Serializable getIdentifier(Object object) throws HibernateException {
        Serializable id = (Serializable)IdentifierCacheHandler.getInstance().getID(object);
        if (id != null) {
            return id;
        }
        return super.getIdentifier(object);
    }

    public String determineConcreteSubclassEntityName(Object entityInstance, SessionFactoryImplementor factory) {
        if (entityInstance instanceof EObject) {
            EObject instance = (EObject)entityInstance;
            HbDataStore ds = HbHelper.INSTANCE.getDataStore(this.persistentClass);
            return ds.toEntityName(instance.eClass());
        }
        Class<?> concreteEntityClass = entityInstance.getClass();
        if (concreteEntityClass == this.getMappedClass()) {
            return this.getEntityName();
        }
        String entityName = this.getEntityMetamodel().findEntityNameByEntityClass(concreteEntityClass);
        if (entityName == null) {
            throw new HibernateException("Unable to resolve entity name from Class [" + concreteEntityClass.getName() + "]" + " expected instance/subclass of [" + this.getEntityName() + "]");
        }
        return entityName;
    }

    public EntityNameResolver[] getEntityNameResolvers() {
        HbDataStore ds = HbHelper.INSTANCE.getDataStore(this.persistentClass);
        return new EntityNameResolver[]{ds.getEntityNameResolver()};
    }

    public Object getVersion(Object object) throws HibernateException {
        Object version = super.getVersion(object);
        if (version != null) {
            return version;
        }
        return IdentifierCacheHandler.getInstance().getVersion(object);
    }

    public void setIdentifier(Object object, Serializable id) throws HibernateException {
        IdentifierCacheHandler.getInstance().setID(object, id);
        super.setIdentifier(object, id);
    }

    protected Instantiator buildInstantiator(PersistentClass persistentClass) {
        if (persistentClass.getEntityName().equals("EAV_EObject")) {
            return new EAVInstantiator();
        }
        HbDataStore ds = HbHelper.INSTANCE.getDataStore(persistentClass);
        EClass eclass = ds.toEClass(persistentClass.getEntityName());
        if (eclass == null) {
            throw new HbMapperException("No eclass found for entityname: " + persistentClass.getEntityName());
        }
        return new EMFInstantiator(eclass, persistentClass);
    }

    protected Getter buildPropertyGetter(Property mappedProperty, PersistentClass mappedEntity) {
        if (HbUtil.isEAVMapped(mappedEntity) && mappedProperty.getName().equals("values")) {
            HbDataStore ds = HbHelper.INSTANCE.getDataStore(mappedEntity);
            Getter getter = mappedProperty.getGetter(EObjectImpl.class);
            if (getter instanceof EAVPropertyHandler) {
                ((EAVPropertyHandler)getter).setHbDataStore(ds);
            }
            return getter;
        }
        return this.getPropertyAccessor(mappedProperty, mappedEntity).getGetter(null, mappedProperty.getName());
    }

    protected Setter buildPropertySetter(Property mappedProperty, PersistentClass mappedEntity) {
        if (HbUtil.isEAVMapped(mappedEntity) && mappedProperty.getName().equals("values")) {
            HbDataStore ds = HbHelper.INSTANCE.getDataStore(mappedEntity);
            Setter setter = mappedProperty.getSetter(EObjectImpl.class);
            if (setter instanceof EAVPropertyHandler) {
                ((EAVPropertyHandler)setter).setHbDataStore(ds);
            }
            return setter;
        }
        return this.getPropertyAccessor(mappedProperty, mappedEntity).getSetter(null, mappedProperty.getName());
    }

    protected ProxyFactory buildProxyFactory(PersistentClass persistentClass, Getter idGetter, Setter idSetter) {
        Class<DynamicEObjectImpl> mappedClass;
        if (persistentClass.getProxyInterface() == null) {
            return null;
        }
        HbDataStore ds = HbHelper.INSTANCE.getDataStore(persistentClass);
        EClass eclass = ds.toEClass(persistentClass.getEntityName());
        if (eclass == null && !persistentClass.getEntityName().equals("EAV_EObject")) {
            throw new HbMapperException("No eclass found for entityname: " + persistentClass.getEntityName());
        }
        LinkedHashSet<Class> proxyInterfaces = new LinkedHashSet<Class>();
        Class pInterface = persistentClass.getProxyInterface();
        if (pInterface != null && pInterface.isInterface()) {
            proxyInterfaces.add(pInterface);
        }
        if ((mappedClass = persistentClass.getMappedClass()) == null) {
            mappedClass = DynamicEObjectImpl.class;
        }
        if (mappedClass.isInterface()) {
            proxyInterfaces.add(mappedClass);
        }
        proxyInterfaces.add(HibernateProxy.class);
        proxyInterfaces.add(TeneoInternalEObject.class);
        Class<?>[] classArray = mappedClass.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> interfaces = classArray[n2];
            proxyInterfaces.add(interfaces);
            ++n2;
        }
        Iterator iter = persistentClass.getSubclassIterator();
        while (iter.hasNext()) {
            Subclass subclass = (Subclass)iter.next();
            Class subclassProxy = subclass.getProxyInterface();
            Class subclassClass = subclass.getMappedClass();
            if (subclassProxy == null || subclassClass == null || subclassClass.equals(subclassProxy)) continue;
            proxyInterfaces.add(subclassProxy);
        }
        Method theIdGetterMethod = idGetter == null ? null : idGetter.getMethod();
        Method theIdSetterMethod = idSetter == null ? null : idSetter.getMethod();
        Method proxyGetIdentifierMethod = theIdGetterMethod == null || pInterface == null ? null : ReflectHelper.getMethod((Class)pInterface, (Method)theIdGetterMethod);
        Method proxySetIdentifierMethod = theIdSetterMethod == null || pInterface == null ? null : ReflectHelper.getMethod((Class)pInterface, (Method)theIdSetterMethod);
        ProxyFactory pf = Environment.getBytecodeProvider().getProxyFactoryFactory().buildProxyFactory();
        try {
            pf.postInstantiate(this.getEntityName(), mappedClass, proxyInterfaces, proxyGetIdentifierMethod, proxySetIdentifierMethod, persistentClass.hasEmbeddedIdentifier() ? (CompositeType)persistentClass.getIdentifier().getType() : null);
        }
        catch (HbStoreException e) {
            log.warn((Object)("could not create proxy factory for:" + this.getEntityName()), (Throwable)((Object)e));
            pf = null;
        }
        return pf;
    }

    public EntityMode getEntityMode() {
        return EntityMode.POJO;
    }

    public Class<?> getConcreteProxyClass() {
        return EObject.class;
    }

    public boolean isInstrumented() {
        return false;
    }

    public Class<?> getMappedClass() {
        return this.mappedClass;
    }

    protected PropertyAccessor getPropertyAccessor(Property mappedProperty, PersistentClass pc) {
        HbDataStore ds = HbHelper.INSTANCE.getDataStore(pc);
        return HbUtil.getPropertyAccessor(mappedProperty, ds, pc.getEntityName(), null);
    }

    protected Getter buildPropertyGetter(AttributeBinding mappedProperty) {
        return null;
    }

    protected Setter buildPropertySetter(AttributeBinding mappedProperty) {
        return null;
    }

    protected Instantiator buildInstantiator(EntityBinding mappingInfo) {
        return null;
    }

    protected ProxyFactory buildProxyFactory(EntityBinding mappingInfo, Getter idGetter, Setter idSetter) {
        return null;
    }
}

