/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.resource;

import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.teneo.hibernate.HbDataStore;
import org.eclipse.emf.teneo.hibernate.HbMapperException;
import org.eclipse.emf.teneo.hibernate.SessionWrapper;
import org.hibernate.Session;

public class SessionController {
    private static Log log = LogFactory.getLog(SessionController.class);
    private static Hashtable<String, SessionController> sessionControllers = new Hashtable();
    protected SessionWrapper sessionWrapper;
    protected HbDataStore hbDataStore;

    public static synchronized void registerSessionController(String name, SessionController sc) {
        if (sessionControllers.get(name) != null) {
            throw new HbMapperException("There is already a session controller registered with the name: " + name);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registering session controller: " + name));
        }
        sessionControllers.put(name, sc);
    }

    public static synchronized void deRegisterSessionController(String name) {
        if (sessionControllers.get(name) == null) {
            throw new HbMapperException("There is no session controller registered with the name: " + name);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("De-Registering session controller: " + name));
        }
        sessionControllers.remove(name);
    }

    public static synchronized SessionController getSessionController(String name) {
        return sessionControllers.get(name);
    }

    public HbDataStore getHbDataStore() {
        return this.hbDataStore;
    }

    public void setHbDataStore(HbDataStore hbDataStore) {
        this.hbDataStore = hbDataStore;
    }

    @Deprecated
    public Session getSession() {
        return (Session)this.getSessionWrapper().getSession();
    }

    public SessionWrapper getSessionWrapper() {
        if (this.sessionWrapper == null) {
            this.sessionWrapper = this.hbDataStore.createSessionWrapper();
        }
        return this.sessionWrapper;
    }
}

