/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapping.identifier;

import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.teneo.hibernate.mapping.identifier.IdentifierCacheHandler;

public class IdentifierCacheCleaningRunnable
implements Runnable {
    private static final Log LOG = LogFactory.getLog(IdentifierCacheHandler.class);
    private static final String TIME_PROPERTY = "org.eclipse.teneo.hibernate.identifierPurgingLogTimeThreshold";
    private static final int DEFAULT_TIME_THRESHOLD = 1000;
    private static final int REMOVE_TIME_LOG_THRESHOLD = Integer.parseInt(System.getProperty("org.eclipse.teneo.hibernate.identifierPurgingLogTimeThreshold", "1000"));
    private final Map<IdentifierCacheHandler.Key, Object> map;
    private final String name;

    public IdentifierCacheCleaningRunnable(Map<IdentifierCacheHandler.Key, Object> map, String name) {
        if (map == null || name == null) {
            throw new IllegalArgumentException("Expecting an instance of map and an instance of name!");
        }
        this.map = map;
        this.name = name;
    }

    @Override
    public void run() {
        long start = System.currentTimeMillis();
        int originalRecords = this.map.size();
        long removedRecords = this.purgeMap();
        long time = System.currentTimeMillis() - start;
        String msg = "Finished purging map '" + this.name + "', original records: " + originalRecords + ", removed records: " + removedRecords + ", final records: " + this.map.size() + ", time[ms]: " + time;
        if (time > (long)REMOVE_TIME_LOG_THRESHOLD) {
            LOG.info((Object)msg);
        } else {
            LOG.debug((Object)msg);
        }
    }

    public long purgeMap() {
        long removedRecords = 0L;
        Iterator<IdentifierCacheHandler.Key> it = this.map.keySet().iterator();
        while (it.hasNext()) {
            if (it.next().isValid()) continue;
            it.remove();
            ++removedRecords;
        }
        return removedRecords;
    }
}

