/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapping.elist;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.teneo.Constants;
import org.eclipse.emf.teneo.hibernate.HbDataStore;
import org.eclipse.emf.teneo.hibernate.HbHelper;
import org.eclipse.emf.teneo.hibernate.HbMapperException;
import org.eclipse.emf.teneo.hibernate.HbUtil;
import org.eclipse.emf.teneo.hibernate.mapping.elist.FeatureMapEntryInstantiator;
import org.eclipse.emf.teneo.hibernate.mapping.property.WildCardAttributePropertyHandler;
import org.eclipse.emf.teneo.hibernate.mapping.property.WildCardReferencePropertyHandler;
import org.eclipse.emf.teneo.hibernate.tuplizer.EMFTuplizer;
import org.eclipse.emf.teneo.util.StoreUtil;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.tuple.Instantiator;
import org.hibernate.tuple.entity.EntityMetamodel;

public class FeatureMapEntryTuplizer
extends EMFTuplizer {
    private static Log log = LogFactory.getLog(FeatureMapEntryTuplizer.class);

    public FeatureMapEntryTuplizer(EntityMetamodel entityMetamodel, PersistentClass mappedEntity) {
        super(entityMetamodel, mappedEntity);
    }

    @Override
    protected Instantiator buildInstantiator(PersistentClass persistentClass) {
        return new FeatureMapEntryInstantiator(persistentClass);
    }

    @Override
    public Class<?> getConcreteProxyClass() {
        return EObject.class;
    }

    @Override
    public Class<?> getMappedClass() {
        return EObject.class;
    }

    @Override
    protected PropertyAccessor getPropertyAccessor(Property mappedProperty, PersistentClass pc) {
        HbDataStore hds = HbHelper.INSTANCE.getDataStore(pc);
        if (mappedProperty.getMetaAttribute("syntheticVersion") != null) {
            return hds.getHbContext().createVersionAccessor();
        }
        if (mappedProperty.getName().compareToIgnoreCase("fme_feature") == 0) {
            return hds.getHbContext().createFeatureMapEntryFeatureURIAccessor();
        }
        if (mappedProperty.getName().compareToIgnoreCase("fme_mixed_cdata") == 0) {
            return hds.getHbContext().createFeatureMapEntryAccessor(Constants.CDATA);
        }
        if (mappedProperty.getName().compareToIgnoreCase("fme_mixed_comment") == 0) {
            return hds.getHbContext().createFeatureMapEntryAccessor(Constants.COMMENT);
        }
        if (mappedProperty.getName().compareToIgnoreCase("fme_mixed_text") == 0) {
            return hds.getHbContext().createFeatureMapEntryAccessor(Constants.TEXT);
        }
        if (mappedProperty.getName().endsWith("fme_any_data")) {
            return (PropertyAccessor)hds.getExtensionManager().getExtension(WildCardAttributePropertyHandler.class);
        }
        if (mappedProperty.getName().endsWith("fme_any_reference")) {
            return (PropertyAccessor)hds.getExtensionManager().getExtension(WildCardReferencePropertyHandler.class);
        }
        String eclassUri = HbUtil.getEClassNameFromFeatureMapMeta(pc);
        EClass eClass = hds.toEClass(eclassUri);
        EStructuralFeature efeature = StoreUtil.getEStructuralFeature((EClass)eClass, (String)mappedProperty.getName());
        if (efeature == null) {
            throw new HbMapperException("Feature not found for entity/property " + pc.getEntityName() + "/" + mappedProperty.getName());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating property accessor for " + mappedProperty.getName() + "/" + pc.getEntityName() + "/" + eclassUri + "/" + efeature.getName()));
        }
        return hds.getHbContext().createFeatureMapEntryAccessor(efeature);
    }
}

