/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.teneo.TeneoException;
import org.eclipse.emf.teneo.classloader.ClassLoaderResolver;
import org.eclipse.emf.teneo.classloader.StoreClassLoadException;
import org.eclipse.emf.teneo.ecore.EModelResolver;
import org.eclipse.emf.teneo.util.StoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERuntime
extends EModelResolver {
    private static Log log = LogFactory.getLog(ERuntime.class);
    public static final ERuntime INSTANCE = new ERuntime();
    private final ArrayList<EPackage> epackages = new ArrayList();
    private final ArrayList<Integer> registrationCount = new ArrayList();
    private final HashMap<Class<?>, EClass> concreteToEClass = new HashMap();
    private final HashMap<Class<?>, EClass> interfaceToEClass = new HashMap();
    private final HashMap<EClassifier, Class<?>> eclassifierToConcrete = new HashMap();
    private final ArrayList<Class<?>> topClasses = new ArrayList();
    private final ArrayList<Class<?>> containedClasses = new ArrayList();

    @Override
    public void removeEPackages(List<EPackage> ePackages) {
        for (EPackage ePackage : ePackages) {
            this.epackages.remove(ePackage);
        }
        this.computeConcreteInstanceMapping();
        this.computeContainedClasses();
    }

    @Override
    public synchronized void register(EPackage[] epacks) {
        int i = 0;
        while (i < epacks.length) {
            if (!this.epackages.contains(epacks[i])) {
                this.epackages.add(epacks[i]);
            }
            ++i;
        }
        this.computeConcreteInstanceMapping();
        this.computeContainedClasses();
    }

    @Override
    public void clear() {
        this.epackages.clear();
        this.containedClasses.clear();
        this.concreteToEClass.clear();
        this.interfaceToEClass.clear();
        this.eclassifierToConcrete.clear();
        this.topClasses.clear();
    }

    private void computeContainedClasses() {
        this.topClasses.clear();
        this.containedClasses.clear();
        int i = 0;
        while (i < this.epackages.size()) {
            EPackage epack = this.epackages.get(i);
            if (!ERuntime.ignorePackage(epack)) {
                for (EClassifier eclassifier : epack.getEClassifiers()) {
                    EClass eclass;
                    if (!(eclassifier instanceof EClass) || ExtendedMetaData.INSTANCE.isDocumentRoot(eclass = (EClass)eclassifier)) continue;
                    for (EReference eref : eclass.getEReferences()) {
                        Class toClass;
                        if (!eref.isContainment() || this.containedClasses.contains(toClass = eref.getEType().getInstanceClass())) continue;
                        this.containedClasses.add(toClass);
                    }
                }
            }
            ++i;
        }
        for (Class<?> clazz : this.interfaceToEClass.keySet()) {
            if (this.containedClasses.contains(clazz)) continue;
            if (this.isSelfOrSuperContained(clazz, this.containedClasses)) {
                this.containedClasses.add(clazz);
                continue;
            }
            EClass eClass = this.getEClass(clazz);
            if (eClass != null && eClass.isAbstract()) continue;
            this.topClasses.add(clazz);
        }
        this.cleanList(this.topClasses);
        this.cleanList(this.containedClasses);
    }

    private boolean isSelfOrSuperContained(Class<?> checkClass, ArrayList<Class<?>> containedClasses) {
        Class<?>[] interfaces;
        if (containedClasses.contains(checkClass)) {
            return true;
        }
        Class<?>[] classArray = interfaces = checkClass.getInterfaces();
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> element = classArray[n2];
            if (this.isSelfOrSuperContained(element, containedClasses)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public Class<?>[] getTopClasses() {
        return this.topClasses.toArray(new Class[this.topClasses.size()]);
    }

    public Set<Class<?>> getAllInterfaces() {
        return this.interfaceToEClass.keySet();
    }

    public Set<Class<?>> getAllConcreteClasses() {
        return this.concreteToEClass.keySet();
    }

    private void cleanList(ArrayList<Class<?>> list) {
        ArrayList toRemove = new ArrayList();
        block0: for (Class clazz : list) {
            Class<?>[] supers;
            if (clazz == null) continue;
            Class<?>[] classArray = supers = clazz.getInterfaces();
            int n = supers.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> element = classArray[n2];
                if (list.contains(element)) {
                    toRemove.add(clazz);
                    continue block0;
                }
                ++n2;
            }
        }
        list.removeAll(toRemove);
    }

    private void computeConcreteInstanceMapping() {
        this.concreteToEClass.clear();
        this.eclassifierToConcrete.clear();
        this.interfaceToEClass.clear();
        int i = 0;
        while (i < this.epackages.size()) {
            EPackage ePackage = this.epackages.get(i);
            if (ERuntime.ignorePackage(ePackage)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Not determining concrete classes for package " + ePackage.getName()));
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Determining concrete classes for package " + ePackage.getName()));
                }
                for (EClassifier eclassifier : ePackage.getEClassifiers()) {
                    if (!(eclassifier instanceof EClass)) continue;
                    Object instance = this.create((EClass)eclassifier);
                    if (instance != null && !(instance instanceof DynamicEObjectImpl)) {
                        this.eclassifierToConcrete.put(eclassifier, instance.getClass());
                        this.concreteToEClass.put(instance.getClass(), (EClass)eclassifier);
                    }
                    if (eclassifier.getInstanceClass() == null) continue;
                    this.interfaceToEClass.put(eclassifier.getInstanceClass(), (EClass)eclassifier);
                }
            }
            ++i;
        }
        ArrayList classes = new ArrayList(this.concreteToEClass.keySet());
        for (Class clazz : classes) {
            this.addAbstractSupers(clazz);
        }
    }

    private void addAbstractSupers(Class<?> clazz) {
        Class<?>[] interf;
        if (clazz == null || !EObject.class.isAssignableFrom(clazz)) {
            return;
        }
        if (this.concreteToEClass.get(clazz) != null) {
            this.addAbstractSupers(clazz.getSuperclass());
            return;
        }
        Class<?>[] classArray = interf = clazz.getInterfaces();
        int n = interf.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> element = classArray[n2];
            if (EObject.class.isAssignableFrom(element)) {
                EClass eclass = this.interfaceToEClass.get(element);
                this.concreteToEClass.put(clazz, eclass);
                this.eclassifierToConcrete.put((EClassifier)eclass, clazz);
            }
            ++n2;
        }
    }

    @Override
    public synchronized EPackage[] getEPackages() {
        return this.epackages.toArray(new EPackage[this.epackages.size()]);
    }

    @Override
    public synchronized boolean isRegistered(EPackage epackage) {
        return this.epackages.contains(epackage);
    }

    private static boolean ignorePackage(EPackage epack) {
        return false;
    }

    public synchronized Class<?> getInstanceClass(Class<?> interf) {
        EClass eclass = this.interfaceToEClass.get(interf);
        if (eclass == null) {
            throw new TeneoException("No eclass for interf " + interf.getName());
        }
        return this.getJavaClass((EClassifier)eclass);
    }

    @Override
    public synchronized Class<?> getJavaClass(EClassifier eclassifier) {
        EClass eclass;
        if (eclassifier instanceof EClass && (eclass = (EClass)eclassifier).isInterface()) {
            return eclass.getInstanceClass();
        }
        return this.eclassifierToConcrete.get(eclassifier);
    }

    @Override
    public synchronized Class<?> getJavaInterfaceClass(EClass eclass) {
        return eclass.getInstanceClass();
    }

    @Override
    public synchronized boolean hasImplementationClass(EClassifier eclassifier) {
        return this.getJavaClass(eclassifier) != null;
    }

    @Override
    public synchronized Object create(EClass eclass) {
        if (eclass.isAbstract() || eclass.isInterface()) {
            return null;
        }
        try {
            return EcoreUtil.create((EClass)eclass);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("The classifier: " + eclass.getName() + " is not a valid eclass"));
            }
            return null;
        }
    }

    @Override
    public synchronized EClass getEClass(Class<?> clazz) {
        if (clazz.isInterface()) {
            return this.interfaceToEClass.get(clazz);
        }
        return this.concreteToEClass.get(clazz);
    }

    public synchronized EClass getEClass(String classname) {
        try {
            return this.getEClass(ClassLoaderResolver.classForName(classname));
        }
        catch (StoreClassLoadException e) {
            log.debug((Object)("Failed to retreive ECLass for name: " + classname));
            return null;
        }
    }

    public synchronized EStructuralFeature getStructuralFeature(Class<?> clazz, String FieldName) {
        EClass eclass = this.getEClass(clazz);
        if (eclass == null) {
            return null;
        }
        return StoreUtil.getEStructuralFeature(eclass, FieldName);
    }

    public synchronized Class<?>[] getContainedInterfaces() {
        return this.containedClasses.toArray(new Class[this.containedClasses.size()]);
    }

    @Override
    public synchronized List<Class<?>> getAllClassesAndInterfaces() {
        ArrayList result = new ArrayList();
        result.addAll(this.getAllConcreteClasses());
        result.addAll(this.getAllInterfaces());
        return result;
    }
}

