/**
 * <copyright>
 * </copyright>
 *
 * $Id: EntityValidator.java,v 1.1 2009/07/23 11:16:29 mtaal Exp $
 */
package org.eclipse.emf.teneo.jpa.orm.validation;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.teneo.jpa.orm.AccessType;
import org.eclipse.emf.teneo.jpa.orm.AssociationOverride;
import org.eclipse.emf.teneo.jpa.orm.AttributeOverride;
import org.eclipse.emf.teneo.jpa.orm.Attributes;
import org.eclipse.emf.teneo.jpa.orm.DiscriminatorColumn;
import org.eclipse.emf.teneo.jpa.orm.EmptyType;
import org.eclipse.emf.teneo.jpa.orm.EntityListeners;
import org.eclipse.emf.teneo.jpa.orm.IdClass;
import org.eclipse.emf.teneo.jpa.orm.Inheritance;
import org.eclipse.emf.teneo.jpa.orm.NamedNativeQuery;
import org.eclipse.emf.teneo.jpa.orm.NamedQuery;
import org.eclipse.emf.teneo.jpa.orm.PostLoad;
import org.eclipse.emf.teneo.jpa.orm.PostPersist;
import org.eclipse.emf.teneo.jpa.orm.PostRemove;
import org.eclipse.emf.teneo.jpa.orm.PostUpdate;
import org.eclipse.emf.teneo.jpa.orm.PrePersist;
import org.eclipse.emf.teneo.jpa.orm.PreRemove;
import org.eclipse.emf.teneo.jpa.orm.PreUpdate;
import org.eclipse.emf.teneo.jpa.orm.PrimaryKeyJoinColumn;
import org.eclipse.emf.teneo.jpa.orm.SecondaryTable;
import org.eclipse.emf.teneo.jpa.orm.SequenceGenerator;
import org.eclipse.emf.teneo.jpa.orm.SqlResultSetMapping;
import org.eclipse.emf.teneo.jpa.orm.Table;
import org.eclipse.emf.teneo.jpa.orm.TableGenerator;

/**
 * A sample validator interface for {@link org.eclipse.emf.teneo.jpa.orm.Entity}.
 * This doesn't really do anything, and it's not a real EMF artifact.
 * It was generated by the org.eclipse.emf.examples.generator.validator plug-in to illustrate how EMF's code generator can be extended.
 * This can be disabled with -vmargs -Dorg.eclipse.emf.examples.generator.validator=false.
 */
public interface EntityValidator {
	boolean validate();

	boolean validateDescription(String value);
	boolean validateTable(Table value);
	boolean validateSecondaryTable(EList<SecondaryTable> value);
	boolean validatePrimaryKeyJoinColumn(EList<PrimaryKeyJoinColumn> value);
	boolean validateIdClass(IdClass value);
	boolean validateInheritance(Inheritance value);
	boolean validateDiscriminatorValue(String value);
	boolean validateDiscriminatorColumn(DiscriminatorColumn value);
	boolean validateSequenceGenerator(SequenceGenerator value);
	boolean validateTableGenerator(TableGenerator value);
	boolean validateNamedQuery(EList<NamedQuery> value);
	boolean validateNamedNativeQuery(EList<NamedNativeQuery> value);
	boolean validateSqlResultSetMapping(EList<SqlResultSetMapping> value);
	boolean validateExcludeDefaultListeners(EmptyType value);
	boolean validateExcludeSuperclassListeners(EmptyType value);
	boolean validateEntityListeners(EntityListeners value);
	boolean validatePrePersist(PrePersist value);
	boolean validatePostPersist(PostPersist value);
	boolean validatePreRemove(PreRemove value);
	boolean validatePostRemove(PostRemove value);
	boolean validatePreUpdate(PreUpdate value);
	boolean validatePostUpdate(PostUpdate value);
	boolean validatePostLoad(PostLoad value);
	boolean validateAttributeOverride(EList<AttributeOverride> value);
	boolean validateAssociationOverride(EList<AssociationOverride> value);
	boolean validateAttributes(Attributes value);
	boolean validateAccess(AccessType value);
	boolean validateClass(String value);
	boolean validateMetadataComplete(boolean value);
	boolean validateName(String value);
}
