/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.samples.emf.sample.schemaprimerpo.util;

import java.math.BigInteger;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.xml.type.util.XMLTypeUtil;
import org.eclipse.emf.ecore.xml.type.util.XMLTypeValidator;
import org.eclipse.emf.teneo.samples.emf.sample.schemaprimerpo.DocumentRoot;
import org.eclipse.emf.teneo.samples.emf.sample.schemaprimerpo.Item;
import org.eclipse.emf.teneo.samples.emf.sample.schemaprimerpo.PurchaseOrder;
import org.eclipse.emf.teneo.samples.emf.sample.schemaprimerpo.SchemaprimerpoPackage;
import org.eclipse.emf.teneo.samples.emf.sample.schemaprimerpo.USAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaprimerpoValidator
extends EObjectValidator {
    public static final SchemaprimerpoValidator INSTANCE = new SchemaprimerpoValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.emf.teneo.samples.emf.sample.schemaprimerpo";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected XMLTypeValidator xmlTypeValidator = XMLTypeValidator.INSTANCE;
    public static final BigInteger QUANTITY_TYPE__MAX__VALUE = new BigInteger("100");
    public static final EValidator.PatternMatcher[][] SKU__PATTERN__VALUES = new EValidator.PatternMatcher[][]{{XMLTypeUtil.createPatternMatcher((String)"\\d{3}-[A-Z]{2}")}};

    protected EPackage getEPackage() {
        return SchemaprimerpoPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateDocumentRoot((DocumentRoot)value, diagnostics, context);
            }
            case 1: {
                return this.validateItem((Item)value, diagnostics, context);
            }
            case 2: {
                return this.validatePurchaseOrder((PurchaseOrder)value, diagnostics, context);
            }
            case 3: {
                return this.validateUSAddress((USAddress)value, diagnostics, context);
            }
            case 4: {
                return this.validateQuantityType((BigInteger)value, diagnostics, context);
            }
            case 5: {
                return this.validateSKU((String)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateDocumentRoot(DocumentRoot documentRoot, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(documentRoot, diagnostics, context);
    }

    public boolean validateItem(Item item, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(item, diagnostics, context);
    }

    public boolean validatePurchaseOrder(PurchaseOrder purchaseOrder, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(purchaseOrder, diagnostics, context);
    }

    public boolean validateUSAddress(USAddress usAddress, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(usAddress, diagnostics, context);
    }

    public boolean validateQuantityType(BigInteger quantityType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.xmlTypeValidator.validatePositiveInteger_Min(quantityType, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validateQuantityType_Max(quantityType, diagnostics, context);
        }
        return result;
    }

    public boolean validateQuantityType_Max(BigInteger quantityType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        boolean bl = result = quantityType.compareTo(QUANTITY_TYPE__MAX__VALUE) < 0;
        if (!result && diagnostics != null) {
            this.reportMaxViolation(SchemaprimerpoPackage.Literals.QUANTITY_TYPE, quantityType, QUANTITY_TYPE__MAX__VALUE, false, diagnostics, context);
        }
        return result;
    }

    public boolean validateSKU(String sku, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateSKU_Pattern(sku, diagnostics, context);
        return result;
    }

    public boolean validateSKU_Pattern(String sku, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validatePattern(SchemaprimerpoPackage.Literals.SKU, sku, SKU__PATTERN__VALUES, diagnostics, context);
    }
}

