/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.eclipselink;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectEList;
import org.eclipse.emf.teneo.eclipselink.EmfHelper;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.descriptors.InstanceVariableAttributeAccessor;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetMethodReturnType;
import org.eclipse.persistence.internal.security.PrivilegedGetValueFromField;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.internal.security.PrivilegedSetValueInField;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.DatabaseMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmfInstanceVariableAccessor
extends AttributeAccessor {
    private static final long serialVersionUID = 1L;
    protected static Set<String> nonBeanLikeAttributes;
    protected static String[] emfAttributesNames;
    protected Field isSetEField;
    protected String getMethodName;
    protected transient Method getMethod;
    protected transient Field attributeField;

    static {
        emfAttributesNames = new String[]{"eAdapters", "eContainer", "eContainerFeatureID", "eFlags", "eProperties"};
        nonBeanLikeAttributes = new HashSet<String>();
        Collections.addAll(nonBeanLikeAttributes, emfAttributesNames);
    }

    public static void customize(DatabaseMapping dbMapping) {
        AttributeAccessor accessor = dbMapping.getAttributeAccessor();
        if (nonBeanLikeAttributes.contains(dbMapping.getAttributeName())) {
            InstanceVariableAttributeAccessor instanceVarAccessor = new InstanceVariableAttributeAccessor();
            instanceVarAccessor.setAttributeName(accessor.getAttributeName());
            dbMapping.setAttributeAccessor((AttributeAccessor)instanceVarAccessor);
        } else {
            EmfInstanceVariableAccessor emfAttributeAccessor = new EmfInstanceVariableAccessor(accessor);
            dbMapping.setAttributeAccessor((AttributeAccessor)emfAttributeAccessor);
        }
    }

    protected EmfInstanceVariableAccessor(AttributeAccessor attributeAccessor) {
        String attrName = attributeAccessor.getAttributeName();
        this.setAttributeName(attrName);
    }

    private String getGetterMethodName(String attrName) {
        String getterMethodName = null;
        String getterPrefix = null;
        String leadingChar = String.valueOf(attrName.charAt(0)).toUpperCase();
        String restOfName = attrName.substring(1);
        Class<?> attributeType = this.getAttributeField().getType();
        getterPrefix = attributeType.equals(Boolean.TYPE) || attributeType.equals(Boolean.class) ? "is" : "get";
        getterMethodName = getterPrefix.concat(leadingChar).concat(restOfName);
        return getterMethodName;
    }

    public Class getAttributeClass() {
        if (this.getGetMethod() == null) {
            return null;
        }
        return this.getGetMethodReturnType();
    }

    public Object getAttributeValueFromObject(Object anObject) throws DescriptorException {
        try {
            if (this.getGetMethodName() == null) {
                return this.getAttributeValueFromObjectUsingDirectAccess(anObject);
            }
            return this.getAttributeValueFromObjectUsingGetter(anObject);
        }
        catch (IllegalArgumentException exception) {
            throw DescriptorException.illegalArgumentWhileGettingValueThruMethodAccessor((String)this.getGetMethodName(), (String)anObject.getClass().getName(), (Throwable)exception);
        }
        catch (IllegalAccessException exception) {
            throw DescriptorException.illegalAccessWhileGettingValueThruMethodAccessor((String)this.getGetMethodName(), (String)anObject.getClass().getName(), (Throwable)exception);
        }
        catch (InvocationTargetException exception) {
            throw DescriptorException.targetInvocationWhileGettingValueThruMethodAccessor((String)this.getGetMethodName(), (String)anObject.getClass().getName(), (Throwable)exception);
        }
        catch (NullPointerException exception) {
            throw DescriptorException.nullPointerWhileGettingValueThruMethodAccessor((String)this.getGetMethodName(), (String)anObject.getClass().getName(), (Throwable)exception);
        }
    }

    private Object getAttributeValueFromObjectUsingGetter(Object anObject) throws IllegalAccessException, InvocationTargetException {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                return AccessController.doPrivileged(new PrivilegedMethodInvoker(this.getGetMethod(), anObject, null));
            }
            catch (PrivilegedActionException exception) {
                Exception throwableException = exception.getException();
                if (throwableException instanceof IllegalAccessException) {
                    throw DescriptorException.illegalAccessWhileGettingValueThruMethodAccessor((String)this.getGetMethodName(), (String)anObject.getClass().getName(), (Throwable)throwableException);
                }
                throw DescriptorException.targetInvocationWhileGettingValueThruMethodAccessor((String)this.getGetMethodName(), (String)anObject.getClass().getName(), (Throwable)throwableException);
            }
        }
        return PrivilegedAccessHelper.invokeMethod((Method)this.getGetMethod(), (Object)anObject, null);
    }

    private Object getAttributeValueFromObjectUsingDirectAccess(Object anObject) throws IllegalAccessException {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                return AccessController.doPrivileged(new PrivilegedGetValueFromField(this.attributeField, anObject));
            }
            catch (PrivilegedActionException exception) {
                throw DescriptorException.illegalAccesstWhileGettingValueThruInstanceVaraibleAccessor((String)this.getAttributeName(), (String)anObject.getClass().getName(), (Throwable)exception.getException());
            }
        }
        return PrivilegedAccessHelper.getValueFromField((Field)this.attributeField, (Object)anObject);
    }

    protected Method getGetMethod() {
        return this.getMethod;
    }

    public String getGetMethodName() {
        return this.getMethodName;
    }

    public Class<?> getGetMethodReturnType() {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                return (Class)AccessController.doPrivileged(new PrivilegedGetMethodReturnType(this.getGetMethod()));
            }
            catch (PrivilegedActionException privilegedActionException) {
                return null;
            }
        }
        return PrivilegedAccessHelper.getMethodReturnType((Method)this.getGetMethod());
    }

    public void initializeAttributes(Class theJavaClass) throws DescriptorException {
        if (this.getAttributeName() == null) {
            throw DescriptorException.attributeNameNotSpecified();
        }
        try {
            this.setAttributeField(Helper.getField((Class)theJavaClass, (String)this.getAttributeName()));
            this.setGetMethodName(this.getGetterMethodName(this.getAttributeName()));
            this.setGetMethod(Helper.getDeclaredMethod((Class)theJavaClass, (String)this.getGetMethodName(), null));
        }
        catch (NoSuchFieldException exception) {
            throw DescriptorException.noSuchFieldWhileInitializingAttributesInInstanceVariableAccessor((String)this.getAttributeName(), (String)theJavaClass.getName(), (Throwable)exception);
        }
        catch (NoSuchMethodException ex) {
            DescriptorException descriptorException = DescriptorException.noSuchMethodWhileInitializingAttributesInMethodAccessor((String)"", (String)this.getGetMethodName(), (String)theJavaClass.getName());
            descriptorException.setInternalException((Throwable)ex);
            throw descriptorException;
        }
        catch (SecurityException exception) {
            DescriptorException descriptorException = DescriptorException.securityWhileInitializingAttributesInMethodAccessor((String)"", (String)this.getGetMethodName(), (String)theJavaClass.getName());
            descriptorException.setInternalException((Throwable)exception);
            throw descriptorException;
        }
    }

    public boolean isMethodAttributeAccessor() {
        return false;
    }

    protected void setGetMethod(Method getMethod) {
        this.getMethod = getMethod;
    }

    public void setGetMethodName(String getMethodName) {
        this.getMethodName = getMethodName;
    }

    protected Field getAttributeField() {
        return this.attributeField;
    }

    public Class<?> getAttributeType() {
        return this.attributeField.getType();
    }

    protected void setAttributeField(Field field) {
        this.attributeField = field;
    }

    public void setAttributeValueInObject(Object anObject, Object value) throws DescriptorException {
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    AccessController.doPrivileged(new PrivilegedSetValueInField(this.attributeField, anObject, value));
                }
                catch (PrivilegedActionException exception) {
                    throw DescriptorException.nullPointerWhileSettingValueThruInstanceVariableAccessor((String)this.getAttributeName(), (Object)value, (Throwable)exception.getException());
                }
            } else {
                PrivilegedAccessHelper.setValueInField((Field)this.attributeField, (Object)anObject, (Object)value);
            }
            if (value instanceof EObjectEList) {
                EmfHelper.getInstance().setEObjectEListOwner((EObjectEList)value, (InternalEObject)anObject);
            }
        }
        catch (IllegalAccessException accessException) {
            throw DescriptorException.nullPointerWhileSettingValueThruInstanceVariableAccessor((String)this.getAttributeName(), (Object)value, (Throwable)accessException);
        }
    }
}

