/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.samples.emf.schemaconstructs.simpletypes.util;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.xml.type.util.XMLTypeValidator;
import org.eclipse.emf.teneo.samples.emf.schemaconstructs.simpletypes.SimpleEnum;
import org.eclipse.emf.teneo.samples.emf.schemaconstructs.simpletypes.SimpleList;
import org.eclipse.emf.teneo.samples.emf.schemaconstructs.simpletypes.SimpleType;
import org.eclipse.emf.teneo.samples.emf.schemaconstructs.simpletypes.SimpleTypeObject;
import org.eclipse.emf.teneo.samples.emf.schemaconstructs.simpletypes.SimpletypesPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpletypesValidator
extends EObjectValidator {
    public static final SimpletypesValidator INSTANCE = new SimpletypesValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.emf.teneo.samples.emf.schemaconstructs.simpletypes";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected XMLTypeValidator xmlTypeValidator = XMLTypeValidator.INSTANCE;

    protected EPackage getEPackage() {
        return SimpletypesPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateSimpleList((SimpleList)value, diagnostics, context);
            }
            case 1: {
                return this.validateSimpleType((SimpleType)value, diagnostics, context);
            }
            case 2: {
                return this.validateSimpleTypeObject((SimpleTypeObject)value, diagnostics, context);
            }
            case 3: {
                return this.validateSimpleEnum((SimpleEnum)((Object)value), diagnostics, context);
            }
            case 4: {
                return this.validateBool((Boolean)value, diagnostics, context);
            }
            case 5: {
                return this.validateByte((Byte)value, diagnostics, context);
            }
            case 6: {
                return this.validateByteArray((byte[])value, diagnostics, context);
            }
            case 7: {
                return this.validateDate((Date)value, diagnostics, context);
            }
            case 8: {
                return this.validateDouble((Double)value, diagnostics, context);
            }
            case 9: {
                return this.validateDoubleArray((double[])value, diagnostics, context);
            }
            case 10: {
                return this.validateExtraLimitedString((String)value, diagnostics, context);
            }
            case 11: {
                return this.validateFloat((Float)value, diagnostics, context);
            }
            case 12: {
                return this.validateInt((Integer)value, diagnostics, context);
            }
            case 13: {
                return this.validateIntArray((int[])value, diagnostics, context);
            }
            case 14: {
                return this.validateLimitedDecimal((BigDecimal)value, diagnostics, context);
            }
            case 15: {
                return this.validateLimitedString((String)value, diagnostics, context);
            }
            case 16: {
                return this.validateLong((Long)value, diagnostics, context);
            }
            case 17: {
                return this.validateSimpleEnumObject((SimpleEnum)((Object)value), diagnostics, context);
            }
            case 18: {
                return this.validateStringArray((String[])value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateSimpleList(SimpleList simpleList, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(simpleList, diagnostics, context);
    }

    public boolean validateSimpleType(SimpleType simpleType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(simpleType, diagnostics, context);
    }

    public boolean validateSimpleTypeObject(SimpleTypeObject simpleTypeObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(simpleTypeObject, diagnostics, context);
    }

    public boolean validateSimpleEnum(SimpleEnum simpleEnum, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateBool(Boolean bool, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateByte(Byte byte_, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateByteArray(byte[] byteArray, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateDate(Date date, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateDouble(Double double_, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateDoubleArray(double[] doubleArray, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateExtraLimitedString(String extraLimitedString, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateExtraLimitedString_MaxLength(extraLimitedString, diagnostics, context);
        return result;
    }

    public boolean validateExtraLimitedString_MaxLength(String extraLimitedString, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        int length = extraLimitedString.length();
        boolean bl = result = length <= 5;
        if (!result && diagnostics != null) {
            this.reportMaxLengthViolation(SimpletypesPackage.Literals.EXTRA_LIMITED_STRING, extraLimitedString, length, 5, diagnostics, context);
        }
        return result;
    }

    public boolean validateFloat(Float float_, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateInt(Integer int_, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateIntArray(int[] intArray, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateLimitedDecimal(BigDecimal limitedDecimal, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateLimitedDecimal_TotalDigits(limitedDecimal, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validateLimitedDecimal_FractionDigits(limitedDecimal, diagnostics, context);
        }
        return result;
    }

    public boolean validateLimitedDecimal_TotalDigits(BigDecimal limitedDecimal, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        boolean bl = result = limitedDecimal.unscaledValue().abs().toString().length() <= 4;
        if (!result && diagnostics != null) {
            this.reportTotalDigitsViolation(SimpletypesPackage.Literals.LIMITED_DECIMAL, limitedDecimal, 4, diagnostics, context);
        }
        return result;
    }

    public boolean validateLimitedDecimal_FractionDigits(BigDecimal limitedDecimal, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        boolean bl = result = limitedDecimal.scale() <= 1;
        if (!result && diagnostics != null) {
            this.reportFractionDigitsViolation(SimpletypesPackage.Literals.LIMITED_DECIMAL, limitedDecimal, 1, diagnostics, context);
        }
        return result;
    }

    public boolean validateLimitedString(String limitedString, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateLimitedString_MinLength(limitedString, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validateLimitedString_MaxLength(limitedString, diagnostics, context);
        }
        return result;
    }

    public boolean validateLimitedString_MinLength(String limitedString, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        int length = limitedString.length();
        boolean bl = result = length >= 10;
        if (!result && diagnostics != null) {
            this.reportMinLengthViolation(SimpletypesPackage.Literals.LIMITED_STRING, limitedString, length, 10, diagnostics, context);
        }
        return result;
    }

    public boolean validateLimitedString_MaxLength(String limitedString, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        int length = limitedString.length();
        boolean bl = result = length <= 10;
        if (!result && diagnostics != null) {
            this.reportMaxLengthViolation(SimpletypesPackage.Literals.LIMITED_STRING, limitedString, length, 10, diagnostics, context);
        }
        return result;
    }

    public boolean validateLong(Long long_, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateSimpleEnumObject(SimpleEnum simpleEnumObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateStringArray(String[] stringArray, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }
}

