/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.eclipselink.resource;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class EclipseLinkResourceUtil {
    public static URI createEclipseLinkURI(String persistenceUnitName, String contentsQueryAlias) {
        if (persistenceUnitName == null || persistenceUnitName.trim().length() == 0) {
            String msg = "Argument for parameter 'persistenceUnitName' must not be blank.";
            throw new WrappedException((Exception)new IllegalArgumentException(msg));
        }
        if (contentsQueryAlias == null || contentsQueryAlias.trim().length() == 0) {
            String msg = "Argument for parameter 'contentsQueryAlias' must not be blank.";
            throw new WrappedException((Exception)new IllegalArgumentException(msg));
        }
        String result = "eclipselink:///" + persistenceUnitName + "?" + contentsQueryAlias;
        return URI.createURI((String)result);
    }

    public static boolean isEclipseLinkURI(URI uri) {
        if (uri == null) {
            String msg = "Argument for parameter 'uri' must not be null.";
            throw new WrappedException((Exception)new IllegalArgumentException(msg));
        }
        return "eclipselink".equals(uri.scheme());
    }

    public static String createContentsInstancesOfQuery(EClass contentsType) {
        if (contentsType == null) {
            String msg = "Argument for parameter 'contentsType' must not be null.";
            throw new WrappedException((Exception)new IllegalArgumentException(msg));
        }
        return "select o from " + contentsType.getName() + " o";
    }

    public static String createContentsEqualQuery(EClass contentsType, EStructuralFeature feature, Object value) {
        if (contentsType == null) {
            String msg = "Argument for parameter 'contentsType' must not be null.";
            throw new WrappedException((Exception)new IllegalArgumentException(msg));
        }
        if (feature == null) {
            String msg = "Argument for parameter 'feature' must not be null.";
            throw new WrappedException((Exception)new IllegalArgumentException(msg));
        }
        if (value == null) {
            String msg = "Argument for parameter 'value' must not be null.";
            throw new WrappedException((Exception)new IllegalArgumentException(msg));
        }
        return "select o from " + contentsType.getName() + " o where o." + feature.getName() + " = '" + value + "'";
    }

    public static String createContentsExampleQuery(EObject contentsExample) {
        if (contentsExample == null) {
            String msg = "Argument for parameter 'contentsExample' must not be null.";
            throw new WrappedException((Exception)new IllegalArgumentException(msg));
        }
        EAttribute idAttribute = contentsExample.eClass().getEIDAttribute();
        if (idAttribute != null) {
            return EclipseLinkResourceUtil.createContentsEqualQuery(contentsExample.eClass(), (EStructuralFeature)idAttribute, contentsExample.eGet((EStructuralFeature)idAttribute));
        }
        return "";
    }
}

