/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.samples.emf.elist.featuremap;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ProductClassification implements Enumerator
{
    NORMAL_LITERAL(0, "Normal", "Normal"),
    SPECIAL_LITERAL(1, "Special", "Special");

    public static final int NORMAL = 0;
    public static final int SPECIAL = 1;
    private static final ProductClassification[] VALUES_ARRAY;
    public static final List<ProductClassification> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ProductClassification[]{NORMAL_LITERAL, SPECIAL_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ProductClassification get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ProductClassification result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ProductClassification getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ProductClassification result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ProductClassification get(int value) {
        switch (value) {
            case 0: {
                return NORMAL_LITERAL;
            }
            case 1: {
                return SPECIAL_LITERAL;
            }
        }
        return null;
    }

    private ProductClassification(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

