/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.eclipselink;

import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.teneo.eclipselink.EmfHelper;
import org.eclipse.emf.teneo.eclipselink.EmfTransparentIndirectionPolicy;
import org.eclipse.emf.teneo.eclipselink.elist.IndirectEList;
import org.eclipse.emf.teneo.eclipselink.elistfactory.EListFactory;
import org.eclipse.emf.teneo.eclipselink.emap.IndirectEMap;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.descriptors.DescriptorEventAdapter;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmfCollectionAdjuster
extends DescriptorEventAdapter {
    public void postMerge(DescriptorEvent event) {
        this.configureEmfCollectionMappings(event);
    }

    public void postBuild(DescriptorEvent event) {
        this.configureEmfCollectionMappings(event);
    }

    public void postClone(DescriptorEvent event) {
        this.configureEmfCollectionMappings(event);
    }

    private void configureEmfCollectionMappings(DescriptorEvent event) {
        ClassDescriptor desc = event.getDescriptor();
        EObject source = (EObject)event.getSource();
        for (DatabaseMapping dbMapping : desc.getMappings()) {
            if (!dbMapping.isCollectionMapping()) continue;
            CollectionMapping collectionMapping = (CollectionMapping)dbMapping;
            if (this.isEMapMapping(collectionMapping)) {
                this.configureEMapMapping(source, collectionMapping);
                continue;
            }
            this.configureEListMapping(source, collectionMapping);
        }
    }

    private boolean isEMapMapping(CollectionMapping collectionMapping) {
        Class containerClass = collectionMapping.getContainerPolicy().getContainerClass();
        return Helper.classImplementsInterface((Class)containerClass, EMap.class);
    }

    private void configureEMapMapping(EObject source, CollectionMapping collectionMapping) {
        if (collectionMapping.usesIndirection()) {
            Object collectionValue = collectionMapping.getAttributeValueFromObject((Object)source);
            if (collectionValue instanceof IndirectEMap) {
                IndirectEMap contentsMap = (IndirectEMap)collectionValue;
                if (contentsMap.isInstantiated()) {
                    this.replaceWithEmfMap(source, collectionMapping);
                } else {
                    EmfTransparentIndirectionPolicy policy = (EmfTransparentIndirectionPolicy)collectionMapping.getIndirectionPolicy();
                    policy.setAttributeOwner(collectionMapping.getAttributeName(), source);
                }
            }
        } else {
            this.replaceWithEmfMap(source, collectionMapping);
        }
    }

    private void configureEListMapping(EObject source, CollectionMapping collectionMapping) {
        if (collectionMapping.usesIndirection()) {
            Object collectionValue = collectionMapping.getAttributeValueFromObject((Object)source);
            if (collectionValue instanceof IndirectEList) {
                IndirectEList contentsList = (IndirectEList)collectionValue;
                if (contentsList.isInstantiated()) {
                    this.replaceWithEmfList(source, collectionMapping);
                } else {
                    EmfTransparentIndirectionPolicy policy = (EmfTransparentIndirectionPolicy)collectionMapping.getIndirectionPolicy();
                    policy.setAttributeOwner(collectionMapping.getAttributeName(), source);
                }
            }
        } else {
            this.replaceWithEmfList(source, collectionMapping);
        }
    }

    private <K, V> void replaceWithEmfMap(EObject source, CollectionMapping collectionMapping) {
        EMap contentsMap = (EMap)collectionMapping.getAttributeValueFromObject((Object)source);
        try {
            EMap newMap = EListFactory.eINSTANCE.createEMap(source, collectionMapping.getAttributeName());
            EmfHelper.getInstance().setEMapContents(contentsMap, newMap);
            if (contentsMap instanceof IndirectEMap) {
                IndirectEMap indirectEMap = (IndirectEMap)contentsMap;
                indirectEMap.setDelegate(newMap);
            } else {
                collectionMapping.setAttributeValueInObject((Object)source, (Object)newMap);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException("Exception building correct EList implementation", e);
        }
    }

    private <E> void replaceWithEmfList(EObject source, CollectionMapping collectionMapping) {
        List contentsList = (List)collectionMapping.getAttributeValueFromObject((Object)source);
        try {
            BasicEList newList = (BasicEList)EListFactory.eINSTANCE.createEList(source, collectionMapping.getAttributeName());
            newList.setData(contentsList.size(), contentsList.toArray());
            collectionMapping.setAttributeValueInObject((Object)source, (Object)newList);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException("Exception building correct EList implementation", e);
        }
    }
}

