/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.jpox.elist;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jdo.JDOHelper;
import javax.jdo.spi.PersistenceCapable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.teneo.jpox.JpoxStoreException;
import org.eclipse.emf.teneo.jpox.JpoxUtil;
import org.eclipse.emf.teneo.jpox.elist.AnyFeatureMapEntry;
import org.eclipse.emf.teneo.jpox.elist.GenericFeatureMapEntry;
import org.eclipse.emf.teneo.jpox.elist.JPOXArrayList;
import org.eclipse.emf.teneo.jpox.resource.JPOXResource;
import org.eclipse.emf.teneo.mapping.elist.PersistableEList;
import org.eclipse.emf.teneo.mapping.elist.PersistableFeatureMap;
import org.eclipse.emf.teneo.resource.StoreResource;
import org.eclipse.emf.teneo.type.FeatureMapEntry;
import org.eclipse.emf.teneo.util.AssertUtil;
import org.eclipse.emf.teneo.util.StoreUtil;
import org.jpox.StateManager;
import org.jpox.sco.SCO;
import org.jpox.sco.SCOList;
import org.jpox.sco.exceptions.QueryUnownedSCOException;
import org.jpox.state.FetchPlanState;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.query.Queryable;
import org.jpox.store.query.ResultObjectFactory;
import org.jpox.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureMapWrapper
extends PersistableFeatureMap
implements SCO,
Queryable,
SCOList {
    private static final long serialVersionUID = 7582443003647643367L;
    private static Log log = LogFactory.getLog(FeatureMapWrapper.class);
    private StateManager stateManager = null;
    private String fieldName = null;
    private JPOXArrayList jdoDelegate;
    private final ArrayList<FeatureMap.Entry> deletedObjects = new ArrayList();
    private final ArrayList<Integer> deletedObjectsIndex = new ArrayList();

    public FeatureMapWrapper(StateManager ownerSM, String fieldName) {
        this(ownerSM, fieldName, new ArrayList<FeatureMap.Entry>());
    }

    public FeatureMapWrapper(StateManager ownerSM, String featureFieldName, List<FeatureMap.Entry> list) {
        super((InternalEObject)ownerSM.getObject(), StoreUtil.getEStructuralFeature((EObject)((InternalEObject)ownerSM.getObject()), (String)featureFieldName), list);
        this.stateManager = ownerSM;
        this.fieldName = featureFieldName;
        this.jdoDelegate = new JPOXArrayList(ownerSM, featureFieldName);
        log.debug((Object)("Creating feature map wrapper for " + this.getElementType().getName()));
        if (this.jdoDelegate.isLoaded()) {
            this.load();
        }
    }

    protected Class<? extends FeatureMap.Entry> determineElementType() {
        if (StoreUtil.isWildCard((EStructuralFeature)this.getEStructuralFeature())) {
            return AnyFeatureMapEntry.class;
        }
        return GenericFeatureMapEntry.class;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.jdoDelegate = null;
        this.stateManager = null;
        out.defaultWriteObject();
    }

    public boolean isPersistencyWrapped() {
        return true;
    }

    private boolean isOwnerDetached() {
        PersistenceCapable pc = (PersistenceCapable)this.getEObject();
        return pc.jdoIsDetached();
    }

    public Object clone() {
        throw new UnsupportedOperationException("Not yet supported for featuremap");
    }

    protected void deleteDependent(EStructuralFeature feature, Object value) {
        EReference eref;
        if (this.isOwnerDetached()) {
            return;
        }
        if (feature instanceof EReference && (eref = (EReference)feature).isContainment() && value instanceof PersistenceCapable) {
            PersistenceCapable pc = (PersistenceCapable)this.owner;
            pc.jdoGetPersistenceManager().deletePersistent(value);
        }
    }

    public void detachSelf() {
        this.jdoDelegate = null;
        this.stateManager = null;
    }

    public void makeDirty() {
        if (this.jdoDelegate != null) {
            this.jdoDelegate.makeDirty();
        }
    }

    protected synchronized void doLoad() {
        boolean setLoading;
        AssertUtil.assertTrue((String)("EList " + this.getLogString() + " is already loaded"), (!this.isLoaded() ? 1 : 0) != 0);
        Resource res = this.getEObject().eResource();
        boolean bl = setLoading = res != null && res instanceof JPOXResource && !((StoreResource)res).isLoading();
        if (setLoading) {
            ((StoreResource)res).setIsLoading(true);
        }
        List list = this.getDelegate();
        Iterator iter = this.jdoDelegate.iterator();
        while (iter.hasNext()) {
            FeatureMap.Entry child = (FeatureMap.Entry)iter.next();
            assert (this.getElementType().isInstance(child));
            list.add(child);
            ((FeatureMapEntry)child).setContainer(this.owner);
        }
        log.debug((Object)("Loaded " + list.size() + " objects from the backing store for elist " + this.getLogString()));
        if (setLoading) {
            ((JPOXResource)res).setIsLoading(false);
        }
    }

    public void attachCopy(Object value) {
        if (!((PersistableEList)value).isLoaded()) {
            return;
        }
        this.load();
        Collection c = (Collection)value;
        ArrayList<FeatureMap.Entry> attachedElements = new ArrayList<FeatureMap.Entry>(c.size());
        for (Object detachedElement : c) {
            if (ClassUtils.isPersistenceCapable(detachedElement)) {
                attachedElements.add((FeatureMap.Entry)this.stateManager.getPersistenceManager().attachCopy(detachedElement, true));
                continue;
            }
            throw new JpoxStoreException("A FeatureMap may only contain persistable objects, this object " + detachedElement.getClass().getName() + " is not persistable.");
        }
        log.debug((Object)("Attaching " + attachedElements.size() + " objects to " + this.getLogString()));
        JpoxUtil.updateListWithListElements((List)((Object)this.jdoDelegate), attachedElements);
    }

    public void detach(FetchPlanState state) {
        Object[] values;
        this.load();
        this.jdoDelegate.detach(state);
        Object[] objectArray = values = this.toArray();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element != null && element instanceof PersistenceCapable) {
                this.stateManager.getPersistenceManager().detachInternal(element, state);
            }
            ++n2;
        }
        this.stateManager = null;
        this.jdoDelegate = null;
    }

    public void makeTransient(FetchPlanState state) {
        Object[] values;
        Object[] objectArray = values = this.toArray();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element != null && element instanceof PersistenceCapable) {
                this.stateManager.getPersistenceManager().findStateManager((PersistenceCapable)element).makeTransient(state);
            }
            ++n2;
        }
        this.stateManager = null;
        this.jdoDelegate = null;
    }

    public Object detachCopy(FetchPlanState state) {
        Object[] values;
        this.load();
        this.jdoDelegate.detachCopy(state);
        ArrayList<FeatureMap.Entry> detached = new ArrayList<FeatureMap.Entry>();
        Object[] objectArray = values = this.toArray();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object == null) {
                detached.add(null);
            } else if (object instanceof PersistenceCapable) {
                detached.add((FeatureMap.Entry)this.stateManager.getPersistenceManager().detachCopyInternal(object, state));
            } else {
                detached.add((FeatureMap.Entry)object);
            }
            ++n2;
        }
        return detached;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Object getOwner() {
        return this.getEObject();
    }

    public void setValueFrom(Object obj) throws ClassCastException {
        Collection c = (Collection)obj;
        this.clear();
        this.addAll(c);
    }

    public void setValueFrom(Object arg0, boolean arg1) throws ClassCastException {
        Collection c = (Collection)arg0;
        if (arg1) {
            this.clear();
            this.addAll(c);
        } else {
            this.getDelegate().clear();
            this.getDelegate().addAll(c);
        }
    }

    public void unsetOwner() {
        log.debug((Object)("Unsetting owner of " + this.getLogString()));
        if (this.jdoDelegate != null) {
            this.jdoDelegate = null;
            this.stateManager = null;
            this.fieldName = null;
        }
    }

    public void runReachability(Set reachables) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object value;
            Object element = iterator.next();
            FeatureMapEntry gfm = (FeatureMapEntry)element;
            StateManager sm = this.stateManager.getPersistenceManager().findStateManager((PersistenceCapable)gfm);
            if (!reachables.contains(sm.getInternalObjectId())) {
                sm.flush();
                reachables.add(sm.getInternalObjectId());
            }
            if (!((value = gfm.getValue()) instanceof PersistenceCapable)) continue;
            StateManager valueSM = this.stateManager.getPersistenceManager().findStateManager((PersistenceCapable)value);
            valueSM.runReachability(reachables);
        }
    }

    public Object set(int arg0, Object arg1, boolean arg2) {
        return this.set(arg0, (FeatureMap.Entry)arg1);
    }

    public void updateEmbeddedElement(Object element, int fieldNumber, Object value) {
        if (this.jdoDelegate == null) {
            throw new JpoxStoreException("List is detached can not update embedded element, " + this.getLogString());
        }
        this.jdoDelegate.updateEmbeddedElement(element, fieldNumber, value);
    }

    public synchronized QueryExpression newQueryStatement() {
        if (this.jdoDelegate == null) {
            throw new QueryUnownedSCOException();
        }
        return this.jdoDelegate.newQueryStatement();
    }

    public synchronized QueryExpression newQueryStatement(Class candidate_class) {
        if (this.jdoDelegate == null) {
            throw new QueryUnownedSCOException();
        }
        return this.jdoDelegate.newQueryStatement(candidate_class);
    }

    public synchronized ResultObjectFactory newResultObjectFactory(QueryExpression stmt, boolean ignoreCache, Class resultClass, boolean useFetchPlan) {
        if (this.jdoDelegate == null) {
            throw new QueryUnownedSCOException();
        }
        return this.jdoDelegate.newResultObjectFactory(stmt, ignoreCache, resultClass, useFetchPlan);
    }

    protected void didChange() {
        if (!this.isLoaded()) {
            return;
        }
        this.makeDirty();
    }

    protected void didAdd(int index, FeatureMap.Entry newObject) {
        assert (newObject instanceof FeatureMapEntry);
        if (!this.isLoaded()) {
            return;
        }
        if (this.jdoDelegate != null) {
            Object value;
            if (newObject instanceof AnyFeatureMapEntry && (value = ((FeatureMapEntry)newObject).getValue()) instanceof PersistenceCapable && ((PersistenceCapable)value).jdoGetObjectId() == null) {
                this.stateManager.getPersistenceManager().makePersistent(value);
                ((AnyFeatureMapEntry)newObject).initializeSpecificImplementation();
            }
            this.jdoDelegate.add(index, newObject);
        }
        super.didAdd(index, (Object)newObject);
    }

    protected void didClear(int size, Object[] oldObjects) {
        if (oldObjects == null) {
            return;
        }
        if (this.jdoDelegate != null) {
            this.jdoDelegate.clear();
        }
        super.didClear(size, oldObjects);
    }

    protected void didMove(int index, FeatureMap.Entry movedObject, int oldIndex) {
        assert (movedObject instanceof FeatureMapEntry);
        if (this.jdoDelegate != null) {
            FeatureMap.Entry newObject = this.createEntry(((FeatureMapEntry)movedObject).getEStructuralFeature(), ((FeatureMapEntry)movedObject).getValue());
            this.jdoDelegate.remove(oldIndex);
            this.jdoDelegate.add(index, newObject);
            assert (JDOHelper.isPersistent((Object)newObject));
        }
        super.didMove(index, (Object)movedObject, oldIndex);
    }

    protected void didRemove(int index, FeatureMap.Entry oldObject) {
        assert (oldObject instanceof FeatureMapEntry);
        assert (!this.deletedObjects.contains(oldObject));
        this.deletedObjects.add(oldObject);
        this.deletedObjectsIndex.add(new Integer(index));
        super.didRemove(index, (Object)oldObject);
    }

    private synchronized void doRemove() {
        if (this.deletedObjects.size() == 0) {
            return;
        }
        if (this.jdoDelegate == null) {
            this.deletedObjects.clear();
            this.deletedObjectsIndex.clear();
            return;
        }
        try {
            int i = 0;
            while (i < this.deletedObjects.size()) {
                int index = this.deletedObjectsIndex.get(i);
                FeatureMap.Entry oldObject = this.deletedObjects.get(i);
                FeatureMapEntry entry = (FeatureMapEntry)oldObject;
                EStructuralFeature feature = entry.getEStructuralFeature();
                Object value = entry.getValue();
                this.jdoDelegate.remove(index);
                this.deleteDependent(feature, value);
                ++i;
            }
        }
        finally {
            this.deletedObjects.clear();
            this.deletedObjectsIndex.clear();
        }
    }

    protected void didSet(int index, FeatureMap.Entry newObject, FeatureMap.Entry oldObject) {
        assert (newObject instanceof FeatureMapEntry);
        assert (oldObject instanceof FeatureMapEntry);
        if (this.jdoDelegate != null) {
            Object obj = this.jdoDelegate.set(index, newObject);
            assert (obj == oldObject);
            if (oldObject != newObject) {
                FeatureMapEntry entry = (FeatureMapEntry)oldObject;
                EStructuralFeature feature = entry.getEStructuralFeature();
                Object value = entry.getValue();
                this.jdoDelegate.remove(entry);
                this.deleteDependent(feature, value);
            }
        }
        super.didSet(index, (Object)newObject, (Object)oldObject);
    }

    public FeatureMap.Entry createEntry(EStructuralFeature feature, Object value) {
        try {
            FeatureMapEntry entry = (FeatureMapEntry)this.getElementType().newInstance();
            entry.setFields(feature, value);
            return entry;
        }
        catch (Exception e) {
            throw this.createException("Exception while instantiating for elementClass " + this.getElementType().getName(), e);
        }
    }

    public void clear(EStructuralFeature feature) {
        this.load();
        try {
            assert (this.deletedObjects.size() == 0);
            super.clear(feature);
        }
        finally {
            this.doRemove();
        }
    }

    public synchronized Object remove(EStructuralFeature feature, int index) {
        this.load();
        try {
            assert (this.deletedObjects.size() == 0);
            Object object = super.remove(feature, index);
            return object;
        }
        finally {
            this.doRemove();
        }
    }

    public synchronized boolean remove(EStructuralFeature feature, Object object) {
        this.load();
        try {
            assert (this.deletedObjects.size() == 0);
            boolean bl = super.remove(feature, object);
            return bl;
        }
        finally {
            this.doRemove();
        }
    }

    public synchronized boolean removeAll(EStructuralFeature feature, Collection<?> collection) {
        this.load();
        try {
            assert (this.deletedObjects.size() == 0);
            boolean bl = super.removeAll(feature, collection);
            return bl;
        }
        finally {
            this.doRemove();
        }
    }

    public void clear() {
        this.load();
        super.clear();
    }

    public FeatureMap.Entry remove(int index) {
        this.load();
        try {
            assert (this.deletedObjects.size() == 0);
            FeatureMap.Entry entry = (FeatureMap.Entry)super.remove(index);
            return entry;
        }
        finally {
            this.doRemove();
        }
    }

    public boolean removeAll(Collection<?> collection) {
        this.load();
        try {
            assert (this.deletedObjects.size() == 0);
            boolean bl = super.removeAll(collection);
            return bl;
        }
        finally {
            this.doRemove();
        }
    }

    public synchronized boolean remove(Object object) {
        this.load();
        try {
            assert (this.deletedObjects.size() == 0);
            boolean bl = super.remove(object);
            return bl;
        }
        finally {
            this.doRemove();
        }
    }

    protected synchronized void removeRange(int arg0, int arg1) {
        this.load();
        try {
            assert (this.deletedObjects.size() == 0);
            super.removeRange(arg0, arg1);
        }
        finally {
            this.doRemove();
        }
    }

    public boolean isInitialized() {
        return this.isLoaded();
    }

    public void load() {
        super.load();
    }

    public void loadFieldsInFetchPlan(FetchPlanState arg0) {
        Object[] values;
        Object[] objectArray = values = this.toArray();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element != null && element instanceof PersistenceCapable) {
                this.stateManager.getPersistenceManager().findStateManager((PersistenceCapable)element).loadFieldsInFetchPlan(arg0);
            }
            ++n2;
        }
    }
}

