/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.jpox.mapper.property;

import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEAttribute;
import org.eclipse.emf.teneo.extension.ExtensionPoint;
import org.eclipse.emf.teneo.jpox.elist.AnyFeatureMapEntry;
import org.eclipse.emf.teneo.jpox.mapper.AbstractMapper;
import org.eclipse.emf.teneo.jpox.mapper.MappingUtil;
import org.eclipse.emf.teneo.jpox.mapping.AnyTypeObject;
import org.eclipse.emf.teneo.simpledom.Element;
import org.eclipse.emf.teneo.util.StoreUtil;

public class ManyBasicMapper
extends AbstractMapper
implements ExtensionPoint {
    protected static final Log log = LogFactory.getLog(ManyBasicMapper.class);

    public void map(PAnnotatedEAttribute aAttribute, Element eclassElement) {
        log.debug((Object)("Processing one to many attribute: " + aAttribute.getModelElement().getName()));
        Element field = eclassElement.addElement("field");
        field.addAttribute("name", this.namingHandler.correctName(this.mappingContext, (EStructuralFeature)aAttribute.getModelElement())).addAttribute("persistence-modifier", "persistent");
        EAttribute eAttribute = (EAttribute)aAttribute.getModelElement();
        boolean isArray = eAttribute.getEType().getInstanceClass() != null && eAttribute.getEType().getInstanceClass().isArray();
        Element join = null;
        if (isArray) {
            field.addElement("array");
            join = field.addElement("join");
            field.addElement("element");
            if (aAttribute.getJoinTable() != null && aAttribute.getJoinTable().getName() != null) {
                field.addAttribute("table", aAttribute.getJoinTable().getName());
            }
            return;
        }
        if (StoreUtil.isMixed((EStructuralFeature)eAttribute)) {
            field.addElement("collection").addAttribute("element-type", AnyFeatureMapEntry.class.getName());
            join = field.addElement("join");
            MappingUtil.addFeatureMapEntryMapping(field);
        } else if (FeatureMapUtil.isFeatureMap((EStructuralFeature)eAttribute)) {
            MappingUtil.addGenericFeatureMapEntryMapping(field, aAttribute, aAttribute.getOneToMany().getFetch());
        } else if (isArray) {
            field.addElement("array");
            join = field.addElement("join");
            field.addElement("element");
        } else {
            String elemType = aAttribute.getOneToMany().getTargetEntity();
            boolean isAnyType = false;
            if (elemType.indexOf(44) > -1) {
                elemType = AnyTypeObject.class.getName();
                isAnyType = true;
            } else if (elemType.indexOf(".") == -1) {
                elemType = this.getObjectClassName(elemType);
            }
            Element collection = field.addElement("collection").addAttribute("element-type", elemType);
            MappingUtil.addEagerLazyLoading(collection, aAttribute.getOneToMany().getFetch());
            join = field.addElement("join");
            if (isAnyType) {
                MappingUtil.addAnytypeMapping(field);
            }
        }
        if (join != null && aAttribute.getJoinTable() != null && aAttribute.getJoinTable().getName() != null) {
            field.addAttribute("table", aAttribute.getJoinTable().getName());
        }
        Element order = field.addElement("order");
        order.addAttribute("column", this.namingHandler.getUniqueIndexColumnName((EStructuralFeature)eAttribute));
    }

    private String getObjectClassName(String primitive) {
        if (primitive.compareTo("boolean") == 0) {
            return Boolean.class.getName();
        }
        if (primitive.compareTo("int") == 0) {
            return Integer.class.getName();
        }
        if (primitive.compareTo("long") == 0) {
            return Long.class.getName();
        }
        if (primitive.compareTo("float") == 0) {
            return Float.class.getName();
        }
        if (primitive.compareTo("double") == 0) {
            return Double.class.getName();
        }
        if (primitive.compareTo("short") == 0) {
            return Short.class.getName();
        }
        if (primitive.compareTo("dateTime") == 0) {
            return Date.class.getName();
        }
        log.debug((Object)(String.valueOf(primitive) + " could not be translated to its Object type, returning passed value"));
        return primitive;
    }
}

