/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.jpox.mapper.association;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEReference;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEStructuralFeature;
import org.eclipse.emf.teneo.annotations.pannotation.CascadeType;
import org.eclipse.emf.teneo.extension.ExtensionPoint;
import org.eclipse.emf.teneo.jpox.mapper.MappingUtil;
import org.eclipse.emf.teneo.jpox.mapper.association.AssociationMapper;
import org.eclipse.emf.teneo.simpledom.Element;

public class OneToOneMapper
extends AssociationMapper
implements ExtensionPoint {
    protected static final Log log = LogFactory.getLog(OneToOneMapper.class);

    public void map(PAnnotatedEReference aReference, Element eclassElement) {
        log.debug((Object)("Processing one to one ereference: " + aReference.getModelElement().getName()));
        EReference eReference = (EReference)aReference.getModelElement();
        EList cascade = aReference.getOneToOne().getCascade();
        boolean cascadeRemove = cascade.contains(CascadeType.ALL) || cascade.contains(CascadeType.REMOVE);
        log.debug((Object)("Cascaderemove " + cascadeRemove));
        Element field = eclassElement.addElement("field");
        field.addAttribute("name", this.namingHandler.correctName(this.mappingContext, (EStructuralFeature)eReference)).addAttribute("persistence-modifier", "persistent");
        this.setCommonReferenceAttributes(field, aReference, cascadeRemove);
        boolean setNullable = this.mappingContext.isForceOptional() || aReference.getOneToOne().isOptional() || eReference.getEOpposite() != null || cascadeRemove;
        field.addAttribute("null-value", setNullable ? "none" : "exception");
        if (aReference.getEmbedded() != null) {
            this.mappingContext.getEmbeddedMapper().map(aReference, field);
        } else {
            if (aReference.getOneToOne() != null && aReference.getOneToOne().getMappedBy() != null) {
                aReference.getModelEReference().isContainment();
            }
            Element fk = cascadeRemove && aReference.getEmbedded() == null ? field.addElement("foreign-key").addAttribute("delete-action", "cascade").addAttribute("update-action", "cascade") : field.addElement("foreign-key");
            this.setFKName((PAnnotatedEStructuralFeature)aReference, fk);
            if (aReference.getJoinColumns() != null && aReference.getJoinColumns().size() > 0) {
                this.mappingContext.getJoinColumnMapper().map((List)aReference.getJoinColumns(), field);
            }
        }
        field.addElement("extension").addAttribute("vendor-name", "jpox").addAttribute("key", "implementation-classes").addAttribute("value", MappingUtil.getImplNameOfEClass(aReference.getOneToOne().getTargetEntity(), this.mappingContext));
    }
}

