/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.annotations.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.teneo.annotations.parser.AnnotationParserException;
import org.eclipse.emf.teneo.annotations.parser.ArrayValueNode;
import org.eclipse.emf.teneo.annotations.parser.EClassResolver;
import org.eclipse.emf.teneo.annotations.parser.NamedParserNode;
import org.eclipse.emf.teneo.annotations.parser.ParserUtil;
import org.eclipse.emf.teneo.annotations.parser.PrimitiveValueNode;
import org.eclipse.emf.teneo.annotations.parser.ReferenceValueNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ComplexNode
extends NamedParserNode {
    private static final Log log = LogFactory.getLog(ComplexNode.class);
    private List<NamedParserNode> children = new ArrayList<NamedParserNode>();
    private boolean isList = false;

    ComplexNode() {
    }

    List<NamedParserNode> getChildren() {
        return this.children;
    }

    @Override
    Object convert(EClassResolver ecr) {
        log.debug((Object)("Converting " + this.getName() + " to EObject "));
        EClass eClass = ecr.getEClass(this.getName());
        if (this.isList() && eClass == null) {
            assert (this.children.size() == 1);
            assert (this.children.get(0) instanceof ArrayValueNode);
            return ((ArrayValueNode)this.children.get(0)).convert(ecr);
        }
        if (eClass == null) {
            throw new AnnotationParserException("No eclass found with name " + this.getName());
        }
        EObject eobj = EcoreUtil.create((EClass)eClass);
        for (NamedParserNode child : this.children) {
            EReference eref;
            EStructuralFeature efeature = ecr.getEStructuralFeature(eClass, child.getName());
            if (child instanceof PrimitiveValueNode) {
                PrimitiveValueNode pvn = (PrimitiveValueNode)child;
                log.debug((Object)("Primitive child: " + pvn.getName() + ": " + pvn.getValue()));
                if (!(efeature instanceof EAttribute)) {
                    throw new AnnotationParserException("The EFeature " + efeature.getName() + "/" + eClass.getName() + " is not an eattribute but a " + efeature.getClass().getName());
                }
                EClassifier eType = efeature.getEType();
                if (!efeature.isMany()) {
                    eobj.eSet(efeature, ParserUtil.convertValue((EDataType)eType, pvn.getValue()));
                    continue;
                }
                String[] sources = pvn.getValue().split("\\s+");
                log.debug((Object)("Child is many, splitting content into " + sources.length + " parts"));
                ArrayList<Object> referenced = new ArrayList<Object>(sources.length);
                String[] stringArray = sources;
                int n = sources.length;
                int n2 = 0;
                while (n2 < n) {
                    String source = stringArray[n2];
                    referenced.add(ParserUtil.convertValue((EDataType)eType, source));
                    ++n2;
                }
                List currentList = (List)eobj.eGet(efeature);
                currentList.addAll(referenced);
                continue;
            }
            if (child instanceof ArrayValueNode && efeature instanceof EAttribute) {
                EAttribute eattr = (EAttribute)efeature;
                if (!eattr.isMany()) {
                    throw new AnnotationParserException("The EFeature " + efeature.getName() + "/" + eClass.getName() + " is not ismany");
                }
                log.debug((Object)"Array child with primitive values");
                Object list = ((ArrayValueNode)child).convert(ecr);
                ArrayList<Object> convertedList = new ArrayList<Object>();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Object object = iterator.next();
                    String val = (String)object;
                    log.debug((Object)("Value " + val));
                    convertedList.add(ParserUtil.convertValue((EDataType)eattr.getEType(), val));
                }
                List currentList = (List)eobj.eGet(efeature);
                currentList.addAll(convertedList);
                continue;
            }
            if (child instanceof ArrayValueNode) {
                if (!(efeature instanceof EReference)) {
                    throw new AnnotationParserException("The EFeature " + efeature.getName() + "/" + eClass.getName() + " is not an ereference but a " + efeature.getClass().getName());
                }
                eref = (EReference)efeature;
                if (!eref.isMany()) {
                    throw new AnnotationParserException("The EFeature " + efeature.getName() + "/" + eClass.getName() + " is not ismany");
                }
                log.debug((Object)"Array child");
                eobj.eSet((EStructuralFeature)eref, ((ArrayValueNode)child).convert(ecr));
                continue;
            }
            if (!(child instanceof ReferenceValueNode)) continue;
            if (!(efeature instanceof EReference)) {
                throw new AnnotationParserException("The EFeature " + efeature.getName() + "/" + eClass.getName() + " is not an ereference but a " + efeature.getClass().getName());
            }
            eref = (EReference)efeature;
            log.debug((Object)("Reference child " + child.getName()));
            if (eref.isMany()) {
                ((List)eobj.eGet((EStructuralFeature)eref)).add(((ReferenceValueNode)child).convert(ecr));
                continue;
            }
            eobj.eSet((EStructuralFeature)eref, ((ReferenceValueNode)child).convert(ecr));
        }
        return eobj;
    }

    public boolean isList() {
        return this.isList;
    }

    public void setList(boolean isList) {
        this.isList = isList;
    }
}

