/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.logical.resolver;

import com.google.common.eventbus.EventBus;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.CrossReferenceResolutionScope;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.DiagnosticSupport;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.IResourceDependencyLocalResolver;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.IResourceDependencyRemoteResolver;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.SynchronizedResourceSet;
import org.eclipse.emf.compare.ide.ui.internal.util.ThreadSafeProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.Before;
import org.mockito.Mockito;

public class AbstractMonitoredProxyCreationListenerTest {
    EventBus eventBus;
    SynchronizedResourceSet synchronizedResourceSet;
    IResourceDependencyLocalResolver localResolver;
    IResourceDependencyRemoteResolver remoteResolver;
    DiagnosticSupport diagnostic;
    ThreadSafeProgressMonitor monitor;
    URI from;
    URI to;
    EObject eObject;
    EStructuralFeature feature;
    Resource source;
    InternalEObject proxy;

    @Before
    public void setUp() {
        this.monitor = (ThreadSafeProgressMonitor)Mockito.mock(ThreadSafeProgressMonitor.class);
        this.eventBus = (EventBus)Mockito.mock(EventBus.class);
        this.localResolver = (IResourceDependencyLocalResolver)Mockito.mock(IResourceDependencyLocalResolver.class);
        this.remoteResolver = (IResourceDependencyRemoteResolver)Mockito.mock(IResourceDependencyRemoteResolver.class);
        this.diagnostic = (DiagnosticSupport)Mockito.mock(DiagnosticSupport.class);
        this.synchronizedResourceSet = (SynchronizedResourceSet)Mockito.mock(SynchronizedResourceSet.class);
    }

    public void prepareTest(String toUri, CrossReferenceResolutionScope scope) {
        this.source = (Resource)Mockito.mock(Resource.class);
        this.eObject = (EObject)Mockito.mock(EObject.class);
        this.feature = (EStructuralFeature)Mockito.mock(EStructuralFeature.Internal.class);
        this.proxy = (InternalEObject)Mockito.mock(InternalEObject.class);
        this.from = URI.createURI((String)"platform:/resource/from");
        Mockito.when((Object)this.source.getURI()).thenReturn((Object)this.from);
        Mockito.when((Object)this.source.getResourceSet()).thenReturn((Object)this.synchronizedResourceSet);
        this.to = URI.createURI((String)toUri);
        Mockito.when((Object)this.proxy.eProxyURI()).thenReturn((Object)this.to);
        this.setResolutionScopeTo(scope);
    }

    private void setResolutionScopeTo(CrossReferenceResolutionScope scope) {
        EMFCompareIDEUIPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.emf.compare.ide.ui.preference.disableResolving", false);
        EMFCompareIDEUIPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.emf.compare.ide.ui.preference.resolutionScope", scope.name());
    }
}

