/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.internal.utils;

import com.google.common.base.Predicate;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.EMFCompareMessages;
import org.eclipse.emf.compare.FeatureMapChange;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.internal.utils.ComparisonUtil;
import org.eclipse.emf.compare.utils.IEqualityHelper;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public final class DiffUtil {
    private static final double SIMILAR = Double.longBitsToDouble(0x3FEFFFFFFFFFFFFFL);
    private static WeakReference<IgnoredElementsEntry> ignoredElementsEntry = new WeakReference<Object>(null);

    private DiffUtil() {
    }

    public static Set<Diff> getAllRefiningDiffs(Diff diff) {
        LinkedHashSet<Diff> result = new LinkedHashSet<Diff>();
        if (diff != null) {
            for (Diff refiningDiff : diff.getRefinedBy()) {
                result.add(refiningDiff);
                if (refiningDiff.getRefinedBy().isEmpty()) continue;
                result.addAll(DiffUtil.getAllRefiningDiffs(refiningDiff));
            }
        }
        return result;
    }

    public static List<Diff> getRootRefinedDiffs(Diff diff) {
        ArrayList rootRefinedDiffs = Lists.newArrayList();
        for (Diff refinedDiff : diff.getRefines()) {
            if (refinedDiff.getRefines().isEmpty()) {
                rootRefinedDiffs.add(refinedDiff);
                continue;
            }
            rootRefinedDiffs.addAll(DiffUtil.getRootRefinedDiffs(refinedDiff));
        }
        return rootRefinedDiffs;
    }

    public static Set<Diff> getAllAtomicRefiningDiffs(Diff diff) {
        LinkedHashSet<Diff> result = new LinkedHashSet<Diff>();
        if (diff != null) {
            for (Diff refiningDiff : diff.getRefinedBy()) {
                if (refiningDiff.getRefinedBy().isEmpty()) {
                    result.add(refiningDiff);
                    continue;
                }
                result.addAll(DiffUtil.getAllAtomicRefiningDiffs(refiningDiff));
            }
        }
        return result;
    }

    public static double diceCoefficient(String first, String second) {
        double coefficient;
        char[] str2;
        char[] str1 = first.toCharArray();
        if (Arrays.equals(str1, str2 = second.toCharArray())) {
            return 1.0;
        }
        if (str1.length == 0 || str2.length == 0) {
            coefficient = 0.0;
        } else if (str1.length == 1 || str2.length == 1 || str1.length == 2 && str2.length == 2) {
            int equalChars = 0;
            int i = 0;
            while (i < Math.min(str1.length, str2.length)) {
                if (str1[i] == str2[i]) {
                    ++equalChars;
                }
                ++i;
            }
            int union = str1.length + str2.length;
            coefficient = str1.length != str2.length ? (double)equalChars / (double)union : (double)equalChars * 2.0 / (double)union;
        } else {
            int[] s1Bigrams = DiffUtil.toBigrams(str1);
            int[] s2Bigrams = DiffUtil.toBigrams(str2);
            Arrays.sort(s1Bigrams);
            Arrays.sort(s2Bigrams);
            int matchingBigrams = 0;
            int index1 = 0;
            int index2 = 0;
            while (index1 < s1Bigrams.length && index2 < s2Bigrams.length) {
                if (s1Bigrams[index1] == s2Bigrams[index2]) {
                    ++matchingBigrams;
                    ++index1;
                    ++index2;
                    continue;
                }
                if (s1Bigrams[index1] < s2Bigrams[index2]) {
                    ++index1;
                    continue;
                }
                ++index2;
            }
            coefficient = 2.0 * (double)matchingBigrams / (double)(s1Bigrams.length + s2Bigrams.length);
        }
        return Math.min(coefficient, SIMILAR);
    }

    private static int[] toBigrams(char[] strArray) {
        int[] bigrams = new int[strArray.length - 1];
        int charBitLength = 16;
        int i = 0;
        while (i < strArray.length - 1) {
            bigrams[i] = strArray[i] | strArray[i + 1] << 16;
            ++i;
        }
        return bigrams;
    }

    public static <E> List<E> longestCommonSubsequence(Comparison comparison, Iterable<E> ignoredElements, List<E> sequence1, List<E> sequence2) {
        IEqualityHelper equalityHelper = comparison.getEqualityHelper();
        ArrayList copy1 = Lists.newArrayList(sequence1);
        ArrayList copy2 = Lists.newArrayList(sequence2);
        ArrayList<Object> ignoredElementsList = new ArrayList<Object>();
        ignoredElements.forEach(ignoredElementsList::add);
        List<E> prefix = DiffUtil.trimPrefix(comparison, equalityHelper, ignoredElementsList, copy1, copy2);
        List<E> suffix = DiffUtil.trimSuffix(comparison, equalityHelper, ignoredElementsList, copy1, copy2);
        List<E> subLCS = copy1.size() > Short.MAX_VALUE || copy2.size() > Short.MAX_VALUE ? DiffUtil.intLongestCommonSubsequence(comparison, equalityHelper, ignoredElementsList, copy1, copy2) : DiffUtil.shortLongestCommonSubsequence(comparison, equalityHelper, ignoredElementsList, copy1, copy2);
        ArrayList<E> lcs = new ArrayList<E>(prefix.size() + subLCS.size() + suffix.size());
        lcs.addAll(prefix);
        lcs.addAll(subLCS);
        lcs.addAll(suffix);
        return Collections.unmodifiableList(lcs);
    }

    public static <E> List<E> longestCommonSubsequence(Comparison comparison, List<E> sequence1, List<E> sequence2) {
        return DiffUtil.longestCommonSubsequence(comparison, Collections.emptyList(), sequence1, sequence2);
    }

    private static <E> List<E> trimPrefix(Comparison comparison, IEqualityHelper equalityHelper, List<Object> ignoredElements, List<E> sequence1, List<E> sequence2) {
        int size1 = sequence1.size();
        int size2 = sequence2.size();
        ArrayList<Object> ignoredElements1 = new ArrayList<Object>(ignoredElements);
        ArrayList<Object> ignoredElements2 = new ArrayList<Object>(ignoredElements);
        ArrayList prefix = Lists.newArrayList();
        int start1 = 1;
        int start2 = 1;
        boolean matching = true;
        while (start1 <= size1 && start2 <= size2 && matching) {
            int ignore2;
            E second;
            E first = sequence1.get(start1 - 1);
            if (equalityHelper.matchingValues(first, second = sequence2.get(start2 - 1))) {
                prefix.add(first);
                ++start1;
                ++start2;
                continue;
            }
            int ignore1 = DiffUtil.indexOf(equalityHelper, ignoredElements1, first);
            if (ignore1 != -1) {
                ignoredElements1.remove(ignore1);
                ++start1;
            }
            if ((ignore2 = DiffUtil.indexOf(equalityHelper, ignoredElements2, second)) != -1) {
                ignoredElements2.remove(ignore2);
                ++start2;
            }
            if (ignore1 != -1 || ignore2 != -1) continue;
            matching = false;
        }
        sequence1.subList(0, start1 - 1).clear();
        sequence2.subList(0, start2 - 1).clear();
        return prefix;
    }

    private static <E> List<E> trimSuffix(Comparison comparison, IEqualityHelper equalityHelper, List<Object> ignoredElements, List<E> sequence1, List<E> sequence2) {
        int size1 = sequence1.size();
        int size2 = sequence2.size();
        ArrayList<Object> ignoredElements1 = new ArrayList<Object>(ignoredElements);
        ArrayList<Object> ignoredElements2 = new ArrayList<Object>(ignoredElements);
        ArrayList suffix = Lists.newArrayList();
        int end1 = size1;
        int end2 = size2;
        boolean matching = true;
        while (end1 > 0 && end2 > 0 && matching) {
            int ignore2;
            E second;
            E first = sequence1.get(end1 - 1);
            if (equalityHelper.matchingValues(first, second = sequence2.get(end2 - 1))) {
                suffix.add(first);
                --end1;
                --end2;
                continue;
            }
            int ignore1 = DiffUtil.indexOf(equalityHelper, ignoredElements1, first);
            if (ignore1 != -1) {
                ignoredElements1.remove(ignore1);
                --end1;
            }
            if ((ignore2 = DiffUtil.indexOf(equalityHelper, ignoredElements2, second)) != -1) {
                ignoredElements2.remove(ignore2);
                --end2;
            }
            if (ignore1 != -1 || ignore2 != -1) continue;
            matching = false;
        }
        sequence1.subList(end1, size1).clear();
        sequence2.subList(end2, size2).clear();
        return Lists.reverse((List)suffix);
    }

    private static int indexOf(IEqualityHelper equalityHelper, List<Object> sequence, Object element) {
        int i = 0;
        while (i < sequence.size()) {
            if (equalityHelper.matchingValues(element, sequence.get(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static <E> List<E> shortLongestCommonSubsequence(Comparison comparison, IEqualityHelper equalityHelper, List<Object> ignoredElements, List<E> sequence1, List<E> sequence2) {
        int size1 = sequence1.size();
        int size2 = sequence2.size();
        short[][] matrix = new short[size1 + 1][size2 + 1];
        int i = 1;
        while (i <= size1) {
            E first = sequence1.get(i - 1);
            int j = 1;
            while (j <= size2) {
                E second;
                short current = matrix[i - 1][j - 1];
                short nextIfNoMatch = (short)Math.max(matrix[i - 1][j], matrix[i][j - 1]);
                matrix[i][j] = nextIfNoMatch > current ? nextIfNoMatch : (equalityHelper.matchingValues(first, second = sequence2.get(j - 1)) && DiffUtil.indexOf(equalityHelper, ignoredElements, second) == -1 ? (short)(1 + current) : nextIfNoMatch);
                ++j;
            }
            ++i;
        }
        int current1 = size1;
        int current2 = size2;
        ArrayList result = Lists.newArrayList();
        while (current1 > 0 && current2 > 0) {
            short currentLength = matrix[current1][current2];
            short nextLeft = matrix[current1][current2 - 1];
            short nextUp = matrix[current1 - 1][current2];
            if (currentLength > nextLeft && currentLength > nextUp) {
                result.add(sequence1.get(current1 - 1));
                --current1;
                --current2;
                continue;
            }
            if (nextLeft >= nextUp) {
                --current2;
                continue;
            }
            --current1;
        }
        return Lists.reverse((List)result);
    }

    private static <E> List<E> intLongestCommonSubsequence(Comparison comparison, IEqualityHelper equalityHelper, List<Object> ignoredElements, List<E> sequence1, List<E> sequence2) {
        int size1 = sequence1.size();
        int size2 = sequence2.size();
        int[][] matrix = new int[size1 + 1][size2 + 1];
        int i = 1;
        while (i <= size1) {
            E first = sequence1.get(i - 1);
            int j = 1;
            while (j <= size2) {
                E second;
                int current = matrix[i - 1][j - 1];
                int nextIfNoMatch = Math.max(matrix[i - 1][j], matrix[i][j - 1]);
                matrix[i][j] = nextIfNoMatch > current ? nextIfNoMatch : (equalityHelper.matchingValues(first, second = sequence2.get(j - 1)) && DiffUtil.indexOf(equalityHelper, ignoredElements, second) == -1 ? 1 + current : nextIfNoMatch);
                ++j;
            }
            ++i;
        }
        int current1 = size1;
        int current2 = size2;
        ArrayList result = Lists.newArrayList();
        while (current1 > 0 && current2 > 0) {
            int currentLength = matrix[current1][current2];
            int nextLeft = matrix[current1][current2 - 1];
            int nextUp = matrix[current1 - 1][current2];
            if (currentLength > nextLeft && currentLength > nextUp) {
                result.add(sequence1.get(current1 - 1));
                --current1;
                --current2;
                continue;
            }
            if (nextLeft >= nextUp) {
                --current2;
                continue;
            }
            --current1;
        }
        return Lists.reverse((List)result);
    }

    public static <E> int findInsertionIndex(Comparison comparison, Iterable<E> ignoredElements, List<E> source, List<E> target, E newElement) {
        IEqualityHelper equalityHelper = comparison.getEqualityHelper();
        List<E> lcs = ignoredElements != null ? DiffUtil.longestCommonSubsequence(comparison, ignoredElements, source, target) : DiffUtil.longestCommonSubsequence(comparison, source, target);
        E firstLCS = null;
        E lastLCS = null;
        int lcsSize = lcs.size();
        if (lcsSize > 0) {
            firstLCS = lcs.get(0);
            lastLCS = lcs.get(lcsSize - 1);
        }
        int noLCS = -2;
        int currentIndex = -1;
        int firstLCSIndex = -1;
        int lastLCSIndex = -1;
        if (firstLCS == null) {
            firstLCSIndex = -2;
            lastLCSIndex = -2;
        }
        ListIterator<E> sourceIterator = source.listIterator();
        Iterator<E> lcsIterator = lcs.iterator();
        Object currentLCS = null;
        if (lcsIterator.hasNext()) {
            currentLCS = lcsIterator.next();
        }
        int i = 0;
        while (sourceIterator.hasNext() && (currentIndex == -1 || firstLCSIndex == -1)) {
            E sourceElement = sourceIterator.next();
            if (currentLCS != null && equalityHelper.matchingValues(sourceElement, currentLCS)) {
                if (firstLCSIndex == -1) {
                    firstLCSIndex = i;
                }
                currentLCS = lcsIterator.hasNext() ? lcsIterator.next() : null;
            } else if (equalityHelper.matchingValues(sourceElement, newElement)) {
                currentIndex = i;
            }
            ++i;
        }
        int sourceSize = source.size();
        sourceIterator = source.listIterator(sourceSize);
        int i2 = sourceSize - 1;
        while (sourceIterator.hasPrevious() && lastLCSIndex == -1) {
            E sourceElement = sourceIterator.previous();
            if (lastLCSIndex == -1 && equalityHelper.matchingValues(lastLCS, sourceElement)) {
                lastLCSIndex = i2;
            }
            --i2;
        }
        int insertionIndex = -1;
        insertionIndex = firstLCSIndex == -2 ? target.size() : (currentIndex < firstLCSIndex ? DiffUtil.insertBeforeLCS(target, equalityHelper, firstLCS) : (currentIndex > lastLCSIndex ? DiffUtil.findInsertionIndexAfterLCS(target, equalityHelper, lastLCS) : DiffUtil.findInsertionIndexWithinLCS(source, target, equalityHelper, lcs, currentIndex)));
        if (insertionIndex == -1) {
            insertionIndex = target.size();
        }
        return insertionIndex;
    }

    public static <E> int findInsertionIndexForElementAt(Comparison comparison, List<E> source, List<E> target, List<E> lcs, int currentIndexInSource) {
        IEqualityHelper equalityHelper = comparison.getEqualityHelper();
        E firstLCS = null;
        E lastLCS = null;
        int lcsSize = lcs.size();
        if (lcsSize > 0) {
            firstLCS = lcs.get(0);
            lastLCS = lcs.get(lcsSize - 1);
        }
        int noLCS = -2;
        int firstLCSIndex = -1;
        int lastLCSIndex = -1;
        if (firstLCS == null) {
            firstLCSIndex = -2;
            lastLCSIndex = -2;
        }
        ListIterator<E> sourceIterator = source.listIterator();
        int i = 0;
        while (sourceIterator.hasNext() && firstLCSIndex == -1) {
            E sourceElement = sourceIterator.next();
            if (firstLCSIndex == -1 && equalityHelper.matchingValues(sourceElement, firstLCS)) {
                firstLCSIndex = i;
            }
            ++i;
        }
        int sourceSize = source.size();
        sourceIterator = source.listIterator(sourceSize);
        int i2 = sourceSize - 1;
        while (sourceIterator.hasPrevious() && lastLCSIndex == -1) {
            E sourceElement = sourceIterator.previous();
            if (lastLCSIndex == -1 && equalityHelper.matchingValues(lastLCS, sourceElement)) {
                lastLCSIndex = i2;
            }
            --i2;
        }
        int insertionIndex = -1;
        insertionIndex = firstLCSIndex == -2 ? target.size() : (currentIndexInSource < firstLCSIndex ? DiffUtil.insertBeforeLCS(target, equalityHelper, firstLCS) : (currentIndexInSource > lastLCSIndex ? DiffUtil.findInsertionIndexAfterLCS(target, equalityHelper, lastLCS) : DiffUtil.findInsertionIndexWithinLCS(source, target, equalityHelper, lcs, currentIndexInSource)));
        if (insertionIndex == -1) {
            insertionIndex = target.size();
        }
        return insertionIndex;
    }

    private static <E> int findInsertionIndexWithinLCS(List<E> source, List<E> target, IEqualityHelper equalityHelper, List<E> lcs, int currentIndex) {
        int insertionIndex = -1;
        int lcsIndexOfSubsequenceStart = -1;
        int i = 0;
        while (i < currentIndex) {
            E sourceElement = source.get(i);
            boolean isInLCS = false;
            int j = lcsIndexOfSubsequenceStart + 1;
            while (j < lcs.size() && !isInLCS) {
                E lcsElement = lcs.get(j);
                if (equalityHelper.matchingValues(sourceElement, lcsElement)) {
                    isInLCS = true;
                    ++lcsIndexOfSubsequenceStart;
                }
                ++j;
            }
            ++i;
        }
        if (lcsIndexOfSubsequenceStart > -1) {
            HashMultiset dupesLCS = HashMultiset.create(lcs.subList(0, lcsIndexOfSubsequenceStart + 1));
            E subsequenceStart = lcs.get(lcsIndexOfSubsequenceStart);
            int duplicatesToGo = dupesLCS.count(subsequenceStart) - 1;
            int i2 = 0;
            while (i2 < target.size() && insertionIndex == -1) {
                E targetElement = target.get(i2);
                if (equalityHelper.matchingValues(subsequenceStart, targetElement)) {
                    if (duplicatesToGo > 0) {
                        --duplicatesToGo;
                    } else {
                        insertionIndex = i2 + 1;
                    }
                }
                ++i2;
            }
        }
        return insertionIndex;
    }

    private static <E> int findInsertionIndexAfterLCS(List<E> target, IEqualityHelper equalityHelper, E lastLCS) {
        int insertionIndex = -1;
        int i = target.size() - 1;
        while (i >= 0 && insertionIndex == -1) {
            E targetElement = target.get(i);
            if (equalityHelper.matchingValues(lastLCS, targetElement)) {
                insertionIndex = i + 1;
            }
            --i;
        }
        return insertionIndex;
    }

    private static <E> int insertBeforeLCS(List<E> target, IEqualityHelper equalityHelper, E firstLCS) {
        int insertionIndex = -1;
        int i = 0;
        while (i < target.size() && insertionIndex == -1) {
            E targetElement = target.get(i);
            if (equalityHelper.matchingValues(firstLCS, targetElement)) {
                insertionIndex = i;
            }
            ++i;
        }
        return insertionIndex;
    }

    public static <E> int findInsertionIndex(Comparison comparison, List<E> source, List<E> target, E newElement) {
        return DiffUtil.findInsertionIndex(comparison, null, source, target, newElement);
    }

    public static int findInsertionIndex(Comparison comparison, Diff diff, boolean rightToLeft) {
        EStructuralFeature targetFeature = DiffUtil.getTargetFeature(comparison, diff, rightToLeft);
        if (!targetFeature.isMany()) {
            throw new IllegalArgumentException(EMFCompareMessages.getString("DiffUtil.IllegalFeature", targetFeature.getName()));
        }
        List<Object> sourceList = DiffUtil.getSourceList(comparison, diff, rightToLeft);
        List<Object> targetList = DiffUtil.getTargetList(comparison, diff, rightToLeft);
        Object changedValue = DiffUtil.getChangedValue(diff);
        Set<Object> ignoredElements = DiffUtil.computeIgnoredElements(comparison, comparison.getEqualityHelper(), targetList, diff, rightToLeft);
        if (ignoredElements.isEmpty()) {
            ignoredElements = Collections.singleton(changedValue);
        } else {
            ignoredElements.add(changedValue);
        }
        return DiffUtil.findInsertionIndex(comparison, ignoredElements, sourceList, targetList, changedValue);
    }

    private static EStructuralFeature getChangedFeature(Diff diff) {
        EAttribute feature;
        if (diff instanceof AttributeChange) {
            feature = ((AttributeChange)diff).getAttribute();
        } else if (diff instanceof ReferenceChange) {
            feature = ((ReferenceChange)diff).getReference();
        } else if (diff instanceof FeatureMapChange) {
            feature = ((FeatureMapChange)diff).getAttribute();
        } else {
            throw new IllegalArgumentException(EMFCompareMessages.getString("DiffUtil.IllegalDiff", diff.eClass().getName()));
        }
        return feature;
    }

    private static Object getChangedValue(Diff diff) {
        Object value;
        if (diff instanceof AttributeChange) {
            value = ((AttributeChange)diff).getValue();
        } else if (diff instanceof ReferenceChange) {
            value = ((ReferenceChange)diff).getValue();
        } else if (diff instanceof FeatureMapChange) {
            value = ((FeatureMapChange)diff).getValue();
        } else {
            throw new IllegalArgumentException(EMFCompareMessages.getString("DiffUtil.IllegalDiff", diff.eClass().getName()));
        }
        return value;
    }

    private static List<Object> getSourceList(Comparison comparison, Diff diff, boolean rightToLeft) {
        EObject expectedContainer;
        Match match = diff.getMatch();
        if (diff.getKind() == DifferenceKind.MOVE) {
            EObject targetContainer = DiffUtil.getTargetContainer(comparison, diff, rightToLeft);
            Match targetMatch = comparison.getMatch(targetContainer);
            expectedContainer = ComparisonUtil.getExpectedSide(targetMatch, diff.getSource(), rightToLeft);
        } else {
            expectedContainer = diff.getKind() == DifferenceKind.DELETE && match.getOrigin() != null && rightToLeft == (diff.getSource() == DifferenceSource.LEFT) ? match.getOrigin() : (rightToLeft ? match.getRight() : match.getLeft());
        }
        EStructuralFeature feature = DiffUtil.getTargetFeature(comparison, diff, rightToLeft);
        return ReferenceUtil.getAsList(expectedContainer, feature);
    }

    private static List<Object> getTargetList(Comparison comparison, Diff diff, boolean rightToLeft) {
        EStructuralFeature targetFeature = DiffUtil.getTargetFeature(comparison, diff, rightToLeft);
        EObject expectedContainer = DiffUtil.getTargetContainer(comparison, diff, rightToLeft);
        return ReferenceUtil.getAsList(expectedContainer, targetFeature);
    }

    private static EObject getTargetContainer(Comparison comparison, Diff diff, boolean rightToLeft) {
        EObject targetContainer;
        Match match = diff.getMatch();
        if (diff.getKind() == DifferenceKind.MOVE && ComparisonUtil.isFeatureMapContainment(diff)) {
            targetContainer = ComparisonUtil.moveElementGetExpectedContainer(comparison, (FeatureMapChange)diff, rightToLeft);
        } else if (DiffUtil.isContainmentReferenceMove(diff)) {
            Object value = DiffUtil.getChangedValue(diff);
            Match valueMatch = comparison.getMatch((EObject)value);
            EObject target = rightToLeft ? valueMatch.getRight() : valueMatch.getLeft();
            if (target == null) {
                target = valueMatch.getOrigin();
            }
            Match targetContainerMatch = comparison.getMatch(target.eContainer());
            targetContainer = rightToLeft ? targetContainerMatch.getLeft() : targetContainerMatch.getRight();
        } else {
            targetContainer = rightToLeft ? match.getLeft() : match.getRight();
        }
        return targetContainer;
    }

    private static EStructuralFeature getTargetFeature(Comparison comparison, Diff diff, boolean rightToLeft) {
        EStructuralFeature targetFeature;
        EStructuralFeature changedFeature = DiffUtil.getChangedFeature(diff);
        if (diff.getKind() == DifferenceKind.MOVE && DiffUtil.isTargetOnTheRight(diff, rightToLeft) && DiffUtil.isContainmentReference(changedFeature)) {
            Object diffValue = DiffUtil.getChangedValue(diff);
            Match valueMatch = comparison.getMatch((EObject)diffValue);
            EObject expectedValue = ComparisonUtil.getExpectedSide(valueMatch, diff.getSource(), rightToLeft);
            targetFeature = expectedValue.eContainingFeature();
        } else {
            targetFeature = changedFeature;
        }
        return targetFeature;
    }

    private static boolean isContainmentReferenceMove(Diff diff) {
        EStructuralFeature diffFeature = DiffUtil.getChangedFeature(diff);
        return diff.getKind() == DifferenceKind.MOVE && DiffUtil.isContainmentReference(diffFeature);
    }

    public static boolean isContainmentReference(EStructuralFeature feature) {
        return feature != null && ((EStructuralFeature.Internal)feature).isContainment();
    }

    private static boolean isTargetOnTheRight(Diff diff, boolean rightToLeft) {
        DifferenceSource source = diff.getSource();
        if (rightToLeft) {
            return source == DifferenceSource.LEFT;
        }
        return source == DifferenceSource.RIGHT;
    }

    public static <E> Set<E> computeIgnoredElements(Comparison comparison, IEqualityHelper equalityHelper, List<E> candidates, Diff diff, boolean rightToLeft) {
        if (!candidates.isEmpty()) {
            return Collections.emptySet();
        }
        IgnoredElementsEntry currentIgnoredElementsEntry = null;
        ArrayList filteredCandidates = null;
        LinkedHashSet ignored = Sets.newLinkedHashSet();
        UnresolvedDiffMatching predicate = new UnresolvedDiffMatching(comparison, equalityHelper, diff, rightToLeft);
        for (E candidate : candidates) {
            predicate.setReferenceValue(candidate);
            if (candidate instanceof EObject) {
                List<Diff> differences;
                if (!(currentIgnoredElementsEntry != null || (currentIgnoredElementsEntry = (IgnoredElementsEntry)ignoredElementsEntry.get()) != null && currentIgnoredElementsEntry.appliesTo(candidates))) {
                    currentIgnoredElementsEntry = new IgnoredElementsEntry(comparison, candidates);
                    ignoredElementsEntry = new WeakReference<IgnoredElementsEntry>(currentIgnoredElementsEntry);
                }
                if (!Iterables.any(differences = currentIgnoredElementsEntry.getDifferences(candidate), (Predicate)predicate)) continue;
                ignored.add(candidate);
                continue;
            }
            if (filteredCandidates == null) {
                Match match = diff.getMatch();
                filteredCandidates = Lists.newArrayList(match.getDifferences());
            }
            if (!Iterables.any(filteredCandidates, (Predicate)predicate)) continue;
            ignored.add(candidate);
        }
        return ignored;
    }

    private static class IgnoredElementsEntry {
        private final Comparison comparison;
        private final Object[] data;
        private final Map<Object, EList<Diff>> allDifferences;

        protected IgnoredElementsEntry(Comparison comparison, List<?> candidates) {
            this.comparison = comparison;
            if (candidates instanceof BasicEList) {
                this.data = ((BasicEList)candidates).data();
                this.allDifferences = Maps.newHashMap();
            } else {
                this.data = null;
                this.allDifferences = null;
            }
        }

        public boolean appliesTo(List<?> candidates) {
            if (candidates instanceof BasicEList) {
                return this.data == ((BasicEList)candidates).data();
            }
            return false;
        }

        public List<Diff> getDifferences(Object object) {
            if (this.allDifferences == null) {
                return this.comparison.getDifferences((EObject)object);
            }
            EList<Diff> differences = this.allDifferences.get(object);
            if (differences == null) {
                differences = this.comparison.getDifferences((EObject)object);
                this.allDifferences.put(object, differences);
            } else {
                differences.size();
            }
            return differences;
        }
    }

    private static class UnresolvedDiffMatching
    implements Predicate<Diff> {
        private Object referenceValue;
        private final EStructuralFeature referenceFeature;
        private final EObject referenceContainer;
        private final Comparison comparison;
        private final IEqualityHelper equalityHelper;
        private final boolean rightToLeft;

        UnresolvedDiffMatching(Comparison comparison, IEqualityHelper equalityHelper, Diff diff, boolean rightToLeft) {
            this.comparison = comparison;
            this.equalityHelper = equalityHelper;
            this.rightToLeft = rightToLeft;
            this.referenceFeature = DiffUtil.getTargetFeature(comparison, diff, rightToLeft);
            this.referenceContainer = DiffUtil.getTargetContainer(comparison, diff, rightToLeft);
        }

        public void setReferenceValue(Object referenceValue) {
            this.referenceValue = referenceValue;
        }

        public boolean apply(Diff input) {
            return input.getKind() == DifferenceKind.MOVE && this.isUnresolved(input) && this.matchesTarget(input) && this.matchesValue(input);
        }

        private boolean isUnresolved(Diff input) {
            return input.getState() == DifferenceState.UNRESOLVED;
        }

        private boolean matchesTarget(Diff input) {
            boolean isSupportedDiff;
            boolean bl = isSupportedDiff = input instanceof AttributeChange || input instanceof ReferenceChange || input instanceof FeatureMapChange;
            return isSupportedDiff && this.matchesTargetFeature(input) && this.matchesTargetContainer(input);
        }

        private boolean matchesTargetFeature(Diff input) {
            EStructuralFeature inputFeature = DiffUtil.getTargetFeature(this.comparison, input, this.rightToLeft);
            return this.referenceFeature == inputFeature;
        }

        private boolean matchesTargetContainer(Diff input) {
            EObject inputContainer = DiffUtil.getTargetContainer(this.comparison, input, this.rightToLeft);
            return this.referenceContainer == inputContainer;
        }

        private boolean matchesValue(Diff input) {
            Object inputValue = DiffUtil.getChangedValue(input);
            boolean matchesValue = inputValue == this.referenceValue ? true : (input instanceof AttributeChange || input instanceof FeatureMapChange ? this.equalityHelper.matchingAttributeValues(inputValue, this.referenceValue) : (input instanceof ReferenceChange ? this.equalityHelper.matchingValues(inputValue, this.referenceValue) : false));
            return matchesValue;
        }
    }
}

