/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.fragmentation;

import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.merge.BatchMerger;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.fragmentation.data.FragmentationInputData;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class FragmentationTest {
    private final FragmentationInputData input = new FragmentationInputData();
    private final IMerger.Registry mergerRegistry = IMerger.RegistryImpl.createStandaloneInstance();

    @Test
    public void testUncontroledObjectResourceSet() throws IOException {
        Resource left = this.input.getUncontrolLeft();
        Resource origin = this.input.getUncontrolOrigin();
        Resource right = this.input.getUncontrolRight();
        ResourceSet leftSet = left.getResourceSet();
        ResourceSet originSet = origin.getResourceSet();
        ResourceSet rightSet = right.getResourceSet();
        Assert.assertNotNull((Object)leftSet);
        Assert.assertNotNull((Object)originSet);
        Assert.assertNotNull((Object)rightSet);
        EcoreUtil.resolveAll((ResourceSet)leftSet);
        EcoreUtil.resolveAll((ResourceSet)originSet);
        EcoreUtil.resolveAll((ResourceSet)rightSet);
        Assert.assertEquals((long)1L, (long)leftSet.getResources().size());
        Assert.assertEquals((long)2L, (long)originSet.getResources().size());
        Assert.assertEquals((long)2L, (long)rightSet.getResources().size());
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)leftSet, (Notifier)rightSet, (Notifier)originSet);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        Diff diff = (Diff)differences.get(0);
        Assert.assertTrue((boolean)(diff instanceof ResourceAttachmentChange));
        Assert.assertEquals((Object)diff.getMatch().getLeft(), (Object)this.getNodeNamed((Notifier)leftSet, "fragmented"));
        Assert.assertEquals((Object)diff.getMatch().getRight(), (Object)this.getNodeNamed((Notifier)rightSet, "fragmented"));
        Assert.assertEquals((Object)diff.getMatch().getOrigin(), (Object)this.getNodeNamed((Notifier)originSet, "fragmented"));
        Assert.assertSame((Object)diff.getSource(), (Object)DifferenceSource.LEFT);
        Assert.assertSame((Object)diff.getKind(), (Object)DifferenceKind.DELETE);
    }

    @Test
    public void testMergeUncontroledObjectResourceSetLtR() throws IOException {
        Resource left = this.input.getUncontrolLeft();
        Resource origin = this.input.getUncontrolOrigin();
        Resource right = this.input.getUncontrolRight();
        ResourceSet leftSet = left.getResourceSet();
        ResourceSet originSet = origin.getResourceSet();
        ResourceSet rightSet = right.getResourceSet();
        EcoreUtil.resolveAll((ResourceSet)leftSet);
        EcoreUtil.resolveAll((ResourceSet)originSet);
        EcoreUtil.resolveAll((ResourceSet)rightSet);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)leftSet, (Notifier)rightSet, (Notifier)originSet);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Diff diff = (Diff)differences.get(0);
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        Assert.assertEquals((long)1L, (long)leftSet.getResources().size());
        Assert.assertEquals((long)2L, (long)originSet.getResources().size());
        Assert.assertEquals((long)2L, (long)rightSet.getResources().size());
        for (Resource resource : rightSet.getResources()) {
            if (resource == right) continue;
            Assert.assertTrue((boolean)resource.getContents().isEmpty());
        }
        EObject leftFragmentedNode = this.getNodeNamed((Notifier)leftSet, "fragmented");
        EObject originFragmentedNode = this.getNodeNamed((Notifier)originSet, "fragmented");
        EObject rightFragmentedNode = this.getNodeNamed((Notifier)rightSet, "fragmented");
        Assert.assertTrue((leftFragmentedNode.eContainer().eResource() == leftFragmentedNode.eResource() ? 1 : 0) != 0);
        Assert.assertTrue((originFragmentedNode.eContainer().eResource() != originFragmentedNode.eResource() ? 1 : 0) != 0);
        Assert.assertTrue((rightFragmentedNode.eContainer().eResource() == rightFragmentedNode.eResource() ? 1 : 0) != 0);
        Comparison lrCompare = EMFCompare.builder().build().compare((IComparisonScope)new DefaultComparisonScope((Notifier)leftSet, (Notifier)rightSet, null));
        Assert.assertEquals((long)0L, (long)lrCompare.getDifferences().size());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
        Assert.assertEquals((long)1L, (long)comparison.getConflicts().size());
        Assert.assertSame((Object)ConflictKind.PSEUDO, (Object)((Conflict)comparison.getConflicts().get(0)).getKind());
    }

    @Ignore
    @Test
    public void testMergeUncontroledObjectResourceSetRtL() throws IOException {
        Resource left = this.input.getUncontrolLeft();
        Resource origin = this.input.getUncontrolOrigin();
        Resource right = this.input.getUncontrolRight();
        ResourceSet leftSet = left.getResourceSet();
        ResourceSet originSet = origin.getResourceSet();
        ResourceSet rightSet = right.getResourceSet();
        EcoreUtil.resolveAll((ResourceSet)leftSet);
        EcoreUtil.resolveAll((ResourceSet)originSet);
        EcoreUtil.resolveAll((ResourceSet)rightSet);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)leftSet, (Notifier)rightSet, (Notifier)originSet);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Diff diff = (Diff)differences.get(0);
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        Assert.assertEquals((long)2L, (long)leftSet.getResources().size());
        Assert.assertEquals((long)2L, (long)originSet.getResources().size());
        Assert.assertEquals((long)2L, (long)rightSet.getResources().size());
        EObject leftFragmentedNode = this.getNodeNamed((Notifier)leftSet, "fragmented");
        EObject originFragmentedNode = this.getNodeNamed((Notifier)originSet, "fragmented");
        EObject rightFragmentedNode = this.getNodeNamed((Notifier)rightSet, "fragmented");
        Assert.assertTrue((leftFragmentedNode.eContainer().eResource() != leftFragmentedNode.eResource() ? 1 : 0) != 0);
        Assert.assertTrue((originFragmentedNode.eContainer().eResource() != originFragmentedNode.eResource() ? 1 : 0) != 0);
        Assert.assertTrue((rightFragmentedNode.eContainer().eResource() != rightFragmentedNode.eResource() ? 1 : 0) != 0);
        Comparison lrCompare = EMFCompare.builder().build().compare((IComparisonScope)new DefaultComparisonScope((Notifier)leftSet, (Notifier)rightSet, null));
        Assert.assertTrue((boolean)lrCompare.getDifferences().isEmpty());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertTrue((boolean)comparison.getDifferences().isEmpty());
    }

    @Test
    public void testUncontroledObjectResource() throws IOException {
        Diff deletion;
        Diff addition;
        Resource left = this.input.getUncontrolLeft();
        Resource origin = this.input.getUncontrolOrigin();
        Resource right = this.input.getUncontrolRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)2L, (long)differences.size());
        if (((Diff)differences.get(0)).getKind() == DifferenceKind.ADD) {
            addition = (Diff)differences.get(0);
            deletion = (Diff)differences.get(1);
        } else {
            deletion = (Diff)differences.get(0);
            addition = (Diff)differences.get(1);
        }
        Assert.assertTrue((boolean)(addition instanceof ReferenceChange));
        Assert.assertEquals((Object)addition.getMatch().getLeft(), (Object)this.getNodeNamed((Notifier)left, "root"));
        Assert.assertEquals((Object)addition.getMatch().getRight(), (Object)this.getNodeNamed((Notifier)right, "root"));
        Assert.assertEquals((Object)addition.getMatch().getOrigin(), (Object)this.getNodeNamed((Notifier)origin, "root"));
        Assert.assertEquals((Object)((ReferenceChange)addition).getValue(), (Object)this.getNodeNamed((Notifier)left, "fragmented"));
        Assert.assertSame((Object)addition.getSource(), (Object)DifferenceSource.LEFT);
        Assert.assertSame((Object)addition.getKind(), (Object)DifferenceKind.ADD);
        Assert.assertTrue((boolean)(deletion instanceof ReferenceChange));
        Assert.assertEquals((Object)deletion.getMatch().getLeft(), (Object)this.getNodeNamed((Notifier)left, "root"));
        Assert.assertEquals((Object)deletion.getMatch().getRight(), (Object)this.getNodeNamed((Notifier)right, "root"));
        Assert.assertEquals((Object)deletion.getMatch().getOrigin(), (Object)this.getNodeNamed((Notifier)origin, "root"));
        Assert.assertTrue((boolean)((ReferenceChange)deletion).getValue().eIsProxy());
        Assert.assertSame((Object)deletion.getSource(), (Object)DifferenceSource.LEFT);
        Assert.assertSame((Object)deletion.getKind(), (Object)DifferenceKind.DELETE);
    }

    @Test
    public void testMergeUncontroledObjectResourceLtR() throws IOException {
        Resource left = this.input.getUncontrolLeft();
        Resource origin = this.input.getUncontrolOrigin();
        Resource right = this.input.getUncontrolRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        BatchMerger merger = new BatchMerger(this.mergerRegistry);
        merger.copyAllLeftToRight((Iterable)differences, (Monitor)new BasicMonitor());
        EObject leftFragmentedNode = this.getNodeNamed((Notifier)left, "fragmented");
        EObject originFragmentedNode = this.getNodeNamed((Notifier)origin, "fragmented");
        EObject rightFragmentedNode = this.getNodeNamed((Notifier)right, "fragmented");
        Assert.assertTrue((leftFragmentedNode.eContainer().eResource() == leftFragmentedNode.eResource() ? 1 : 0) != 0);
        Assert.assertNull((Object)originFragmentedNode);
        Assert.assertTrue((rightFragmentedNode.eContainer().eResource() == rightFragmentedNode.eResource() ? 1 : 0) != 0);
        List leftRootContent = ((InternalEList)this.getNodeNamed((Notifier)left, "root").eContents()).basicList();
        List originRootContent = ((InternalEList)this.getNodeNamed((Notifier)origin, "root").eContents()).basicList();
        List rightRootContent = ((InternalEList)this.getNodeNamed((Notifier)right, "root").eContents()).basicList();
        Assert.assertEquals((long)1L, (long)leftRootContent.size());
        Assert.assertEquals((long)1L, (long)originRootContent.size());
        Assert.assertEquals((long)1L, (long)rightRootContent.size());
        Assert.assertTrue((leftRootContent.get(0) == leftFragmentedNode ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((EObject)originRootContent.get(0)).eIsProxy());
        Assert.assertTrue((rightRootContent.get(0) == rightFragmentedNode ? 1 : 0) != 0);
        Comparison lrCompare = EMFCompare.builder().build().compare((IComparisonScope)new DefaultComparisonScope((Notifier)left, (Notifier)right, null));
        Assert.assertEquals((long)0L, (long)lrCompare.getDifferences().size());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)4L, (long)comparison.getDifferences().size());
        Assert.assertEquals((long)2L, (long)comparison.getConflicts().size());
        Assert.assertSame((Object)ConflictKind.PSEUDO, (Object)((Conflict)comparison.getConflicts().get(0)).getKind());
        Assert.assertSame((Object)ConflictKind.PSEUDO, (Object)((Conflict)comparison.getConflicts().get(1)).getKind());
    }

    @Test
    public void testMergeUncontroledObjectResourceRtL() throws IOException {
        Resource left = this.input.getUncontrolLeft();
        Resource origin = this.input.getUncontrolOrigin();
        Resource right = this.input.getUncontrolRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        BatchMerger merger = new BatchMerger(this.mergerRegistry);
        merger.copyAllRightToLeft((Iterable)differences, (Monitor)new BasicMonitor());
        EObject leftFragmentedNode = this.getNodeNamed((Notifier)left, "fragmented");
        EObject originFragmentedNode = this.getNodeNamed((Notifier)origin, "fragmented");
        EObject rightFragmentedNode = this.getNodeNamed((Notifier)right, "fragmented");
        Assert.assertNull((Object)leftFragmentedNode);
        Assert.assertNull((Object)originFragmentedNode);
        Assert.assertNull((Object)rightFragmentedNode);
        List leftRootContent = ((InternalEList)this.getNodeNamed((Notifier)left, "root").eContents()).basicList();
        List originRootContent = ((InternalEList)this.getNodeNamed((Notifier)origin, "root").eContents()).basicList();
        List rightRootContent = ((InternalEList)this.getNodeNamed((Notifier)right, "root").eContents()).basicList();
        Assert.assertEquals((long)1L, (long)leftRootContent.size());
        Assert.assertEquals((long)1L, (long)originRootContent.size());
        Assert.assertEquals((long)1L, (long)rightRootContent.size());
        Assert.assertTrue((boolean)((EObject)leftRootContent.get(0)).eIsProxy());
        Assert.assertTrue((boolean)((EObject)originRootContent.get(0)).eIsProxy());
        Assert.assertTrue((boolean)((EObject)rightRootContent.get(0)).eIsProxy());
        Comparison lrCompare = EMFCompare.builder().build().compare((IComparisonScope)new DefaultComparisonScope((Notifier)left, (Notifier)right, null));
        Assert.assertEquals((long)0L, (long)lrCompare.getDifferences().size());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertTrue((boolean)comparison.getDifferences().isEmpty());
    }

    @Test
    public void testControledObjectResourceSet() throws IOException {
        Resource left = this.input.getControlLeft();
        Resource origin = this.input.getControlOrigin();
        Resource right = this.input.getControlRight();
        ResourceSet leftSet = left.getResourceSet();
        ResourceSet originSet = origin.getResourceSet();
        ResourceSet rightSet = right.getResourceSet();
        Assert.assertNotNull((Object)leftSet);
        Assert.assertNotNull((Object)originSet);
        Assert.assertNotNull((Object)rightSet);
        EcoreUtil.resolveAll((ResourceSet)leftSet);
        EcoreUtil.resolveAll((ResourceSet)originSet);
        EcoreUtil.resolveAll((ResourceSet)rightSet);
        Assert.assertEquals((long)2L, (long)leftSet.getResources().size());
        Assert.assertEquals((long)1L, (long)originSet.getResources().size());
        Assert.assertEquals((long)1L, (long)rightSet.getResources().size());
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)leftSet, (Notifier)rightSet, (Notifier)originSet);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        Diff diff = (Diff)differences.get(0);
        Assert.assertTrue((boolean)(diff instanceof ResourceAttachmentChange));
        Assert.assertEquals((Object)diff.getMatch().getLeft(), (Object)this.getNodeNamed((Notifier)leftSet, "fragmented"));
        Assert.assertEquals((Object)diff.getMatch().getRight(), (Object)this.getNodeNamed((Notifier)rightSet, "fragmented"));
        Assert.assertEquals((Object)diff.getMatch().getOrigin(), (Object)this.getNodeNamed((Notifier)originSet, "fragmented"));
        Assert.assertSame((Object)diff.getSource(), (Object)DifferenceSource.LEFT);
        Assert.assertSame((Object)diff.getKind(), (Object)DifferenceKind.ADD);
    }

    @Ignore
    @Test
    public void testMergeControledObjectResourceSetLtR() throws IOException {
        Resource left = this.input.getControlLeft();
        Resource origin = this.input.getControlOrigin();
        Resource right = this.input.getControlRight();
        ResourceSet leftSet = left.getResourceSet();
        ResourceSet originSet = origin.getResourceSet();
        ResourceSet rightSet = right.getResourceSet();
        EcoreUtil.resolveAll((ResourceSet)leftSet);
        EcoreUtil.resolveAll((ResourceSet)originSet);
        EcoreUtil.resolveAll((ResourceSet)rightSet);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)leftSet, (Notifier)rightSet, (Notifier)originSet);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Diff diff = (Diff)differences.get(0);
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        Assert.assertEquals((long)2L, (long)leftSet.getResources().size());
        Assert.assertEquals((long)1L, (long)originSet.getResources().size());
        Assert.assertEquals((long)2L, (long)rightSet.getResources().size());
        EObject leftFragmentedNode = this.getNodeNamed((Notifier)leftSet, "fragmented");
        EObject originFragmentedNode = this.getNodeNamed((Notifier)originSet, "fragmented");
        EObject rightFragmentedNode = this.getNodeNamed((Notifier)rightSet, "fragmented");
        Assert.assertTrue((leftFragmentedNode.eContainer().eResource() != leftFragmentedNode.eResource() ? 1 : 0) != 0);
        Assert.assertTrue((originFragmentedNode.eContainer().eResource() == originFragmentedNode.eResource() ? 1 : 0) != 0);
        Assert.assertTrue((rightFragmentedNode.eContainer().eResource() != rightFragmentedNode.eResource() ? 1 : 0) != 0);
        Comparison lrCompare = EMFCompare.builder().build().compare((IComparisonScope)new DefaultComparisonScope((Notifier)leftSet, (Notifier)rightSet, null));
        Assert.assertEquals((long)0L, (long)lrCompare.getDifferences().size());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
        Assert.assertEquals((long)1L, (long)comparison.getConflicts().size());
        Assert.assertSame((Object)ConflictKind.PSEUDO, (Object)((Conflict)comparison.getConflicts().get(0)).getKind());
    }

    @Test
    public void testMergeControledObjectResourceSetRtL() throws IOException {
        Resource left = this.input.getControlLeft();
        Resource origin = this.input.getControlOrigin();
        Resource right = this.input.getControlRight();
        ResourceSet leftSet = left.getResourceSet();
        ResourceSet originSet = origin.getResourceSet();
        ResourceSet rightSet = right.getResourceSet();
        EcoreUtil.resolveAll((ResourceSet)leftSet);
        EcoreUtil.resolveAll((ResourceSet)originSet);
        EcoreUtil.resolveAll((ResourceSet)rightSet);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)leftSet, (Notifier)rightSet, (Notifier)originSet);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Diff diff = (Diff)differences.get(0);
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        Assert.assertEquals((long)2L, (long)leftSet.getResources().size());
        Assert.assertEquals((long)1L, (long)originSet.getResources().size());
        Assert.assertEquals((long)1L, (long)rightSet.getResources().size());
        for (Resource res : leftSet.getResources()) {
            if (res == left) continue;
            Assert.assertTrue((boolean)res.getContents().isEmpty());
        }
        EObject leftFragmentedNode = this.getNodeNamed((Notifier)leftSet, "fragmented");
        EObject originFragmentedNode = this.getNodeNamed((Notifier)originSet, "fragmented");
        EObject rightFragmentedNode = this.getNodeNamed((Notifier)rightSet, "fragmented");
        Assert.assertTrue((leftFragmentedNode.eContainer().eResource() == leftFragmentedNode.eResource() ? 1 : 0) != 0);
        Assert.assertTrue((originFragmentedNode.eContainer().eResource() == originFragmentedNode.eResource() ? 1 : 0) != 0);
        Assert.assertTrue((rightFragmentedNode.eContainer().eResource() == rightFragmentedNode.eResource() ? 1 : 0) != 0);
        Comparison lrCompare = EMFCompare.builder().build().compare((IComparisonScope)new DefaultComparisonScope((Notifier)leftSet, (Notifier)rightSet, null));
        Assert.assertTrue((boolean)lrCompare.getDifferences().isEmpty());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertTrue((boolean)comparison.getDifferences().isEmpty());
    }

    @Test
    public void testControledObjectResource() throws IOException {
        Diff deletion;
        Diff addition;
        Resource left = this.input.getControlLeft();
        Resource origin = this.input.getControlOrigin();
        Resource right = this.input.getControlRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)2L, (long)differences.size());
        if (((Diff)differences.get(0)).getKind() == DifferenceKind.ADD) {
            addition = (Diff)differences.get(0);
            deletion = (Diff)differences.get(1);
        } else {
            deletion = (Diff)differences.get(0);
            addition = (Diff)differences.get(1);
        }
        Assert.assertTrue((boolean)(addition instanceof ReferenceChange));
        Assert.assertEquals((Object)addition.getMatch().getLeft(), (Object)this.getNodeNamed((Notifier)left, "root"));
        Assert.assertEquals((Object)addition.getMatch().getRight(), (Object)this.getNodeNamed((Notifier)right, "root"));
        Assert.assertEquals((Object)addition.getMatch().getOrigin(), (Object)this.getNodeNamed((Notifier)origin, "root"));
        Assert.assertTrue((boolean)((ReferenceChange)addition).getValue().eIsProxy());
        Assert.assertSame((Object)addition.getSource(), (Object)DifferenceSource.LEFT);
        Assert.assertSame((Object)addition.getKind(), (Object)DifferenceKind.ADD);
        Assert.assertTrue((boolean)(deletion instanceof ReferenceChange));
        Assert.assertEquals((Object)deletion.getMatch().getLeft(), (Object)this.getNodeNamed((Notifier)left, "root"));
        Assert.assertEquals((Object)deletion.getMatch().getRight(), (Object)this.getNodeNamed((Notifier)right, "root"));
        Assert.assertEquals((Object)deletion.getMatch().getOrigin(), (Object)this.getNodeNamed((Notifier)origin, "root"));
        Assert.assertEquals((Object)((ReferenceChange)deletion).getValue(), (Object)this.getNodeNamed((Notifier)origin, "fragmented"));
        Assert.assertSame((Object)deletion.getSource(), (Object)DifferenceSource.LEFT);
        Assert.assertSame((Object)deletion.getKind(), (Object)DifferenceKind.DELETE);
    }

    @Test
    public void testMergeControledObjectResourceLtR() throws IOException {
        Resource left = this.input.getControlLeft();
        Resource origin = this.input.getControlOrigin();
        Resource right = this.input.getControlRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        BatchMerger merger = new BatchMerger(this.mergerRegistry);
        merger.copyAllLeftToRight((Iterable)differences, (Monitor)new BasicMonitor());
        EObject leftFragmentedNode = this.getNodeNamed((Notifier)left, "fragmented");
        EObject originFragmentedNode = this.getNodeNamed((Notifier)origin, "fragmented");
        EObject rightFragmentedNode = this.getNodeNamed((Notifier)right, "fragmented");
        Assert.assertNull((Object)leftFragmentedNode);
        Assert.assertTrue((originFragmentedNode.eContainer().eResource() == originFragmentedNode.eResource() ? 1 : 0) != 0);
        Assert.assertNull((Object)rightFragmentedNode);
        List leftRootContent = ((InternalEList)this.getNodeNamed((Notifier)left, "root").eContents()).basicList();
        List originRootContent = ((InternalEList)this.getNodeNamed((Notifier)origin, "root").eContents()).basicList();
        List rightRootContent = ((InternalEList)this.getNodeNamed((Notifier)right, "root").eContents()).basicList();
        Assert.assertEquals((long)1L, (long)leftRootContent.size());
        Assert.assertEquals((long)1L, (long)originRootContent.size());
        Assert.assertEquals((long)1L, (long)rightRootContent.size());
        Assert.assertTrue((boolean)((EObject)leftRootContent.get(0)).eIsProxy());
        Assert.assertTrue((originRootContent.get(0) == originFragmentedNode ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((EObject)rightRootContent.get(0)).eIsProxy());
        Comparison lrCompare = EMFCompare.builder().build().compare((IComparisonScope)new DefaultComparisonScope((Notifier)left, (Notifier)right, null));
        Assert.assertEquals((long)0L, (long)lrCompare.getDifferences().size());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)4L, (long)comparison.getDifferences().size());
        Assert.assertEquals((long)2L, (long)comparison.getConflicts().size());
        Assert.assertSame((Object)ConflictKind.PSEUDO, (Object)((Conflict)comparison.getConflicts().get(0)).getKind());
        Assert.assertSame((Object)ConflictKind.PSEUDO, (Object)((Conflict)comparison.getConflicts().get(1)).getKind());
    }

    @Test
    public void testMergeControledObjectResourceRtL() throws IOException {
        Resource left = this.input.getControlLeft();
        Resource origin = this.input.getControlOrigin();
        Resource right = this.input.getControlRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        BatchMerger merger = new BatchMerger(this.mergerRegistry);
        merger.copyAllRightToLeft((Iterable)differences, (Monitor)new BasicMonitor());
        EObject leftFragmentedNode = this.getNodeNamed((Notifier)left, "fragmented");
        EObject originFragmentedNode = this.getNodeNamed((Notifier)origin, "fragmented");
        EObject rightFragmentedNode = this.getNodeNamed((Notifier)right, "fragmented");
        Assert.assertTrue((leftFragmentedNode.eContainer().eResource() == leftFragmentedNode.eResource() ? 1 : 0) != 0);
        Assert.assertTrue((originFragmentedNode.eContainer().eResource() == originFragmentedNode.eResource() ? 1 : 0) != 0);
        Assert.assertTrue((rightFragmentedNode.eContainer().eResource() == rightFragmentedNode.eResource() ? 1 : 0) != 0);
        List leftRootContent = ((InternalEList)this.getNodeNamed((Notifier)left, "root").eContents()).basicList();
        List originRootContent = ((InternalEList)this.getNodeNamed((Notifier)origin, "root").eContents()).basicList();
        List rightRootContent = ((InternalEList)this.getNodeNamed((Notifier)right, "root").eContents()).basicList();
        Assert.assertEquals((long)1L, (long)leftRootContent.size());
        Assert.assertEquals((long)1L, (long)originRootContent.size());
        Assert.assertEquals((long)1L, (long)rightRootContent.size());
        Assert.assertTrue((leftRootContent.get(0) == leftFragmentedNode ? 1 : 0) != 0);
        Assert.assertTrue((originRootContent.get(0) == originFragmentedNode ? 1 : 0) != 0);
        Assert.assertTrue((rightRootContent.get(0) == rightFragmentedNode ? 1 : 0) != 0);
        Comparison lrCompare = EMFCompare.builder().build().compare((IComparisonScope)new DefaultComparisonScope((Notifier)left, (Notifier)right, null));
        Assert.assertEquals((long)0L, (long)lrCompare.getDifferences().size());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertTrue((boolean)comparison.getDifferences().isEmpty());
    }

    @Test
    public void testControledObjectFolderResourceSet() throws IOException {
        Resource left = this.input.getControlLeftFolder();
        Resource origin = this.input.getControlOriginFolder();
        Resource right = this.input.getControlRightFolder();
        ResourceSet leftSet = left.getResourceSet();
        ResourceSet originSet = origin.getResourceSet();
        ResourceSet rightSet = right.getResourceSet();
        Assert.assertNotNull((Object)leftSet);
        Assert.assertNotNull((Object)originSet);
        Assert.assertNotNull((Object)rightSet);
        EcoreUtil.resolveAll((ResourceSet)leftSet);
        EcoreUtil.resolveAll((ResourceSet)originSet);
        EcoreUtil.resolveAll((ResourceSet)rightSet);
        Assert.assertEquals((long)2L, (long)leftSet.getResources().size());
        Assert.assertEquals((long)1L, (long)originSet.getResources().size());
        Assert.assertEquals((long)1L, (long)rightSet.getResources().size());
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)leftSet, (Notifier)rightSet, (Notifier)originSet);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        Diff diff = (Diff)differences.get(0);
        Assert.assertTrue((boolean)(diff instanceof ResourceAttachmentChange));
        Assert.assertEquals((Object)diff.getMatch().getLeft(), (Object)this.getNodeNamed((Notifier)leftSet, "fragmented"));
        Assert.assertEquals((Object)diff.getMatch().getRight(), (Object)this.getNodeNamed((Notifier)rightSet, "fragmented"));
        Assert.assertEquals((Object)diff.getMatch().getOrigin(), (Object)this.getNodeNamed((Notifier)originSet, "fragmented"));
        Assert.assertSame((Object)diff.getSource(), (Object)DifferenceSource.LEFT);
        Assert.assertSame((Object)diff.getKind(), (Object)DifferenceKind.ADD);
    }

    @Test
    public void testMergeControledObjectFolderResourceSetLtR() throws IOException {
        Resource left = this.input.getControlLeftFolder();
        Resource origin = this.input.getControlOriginFolder();
        Resource right = this.input.getControlRightFolder();
        ResourceSet leftSet = left.getResourceSet();
        ResourceSet originSet = origin.getResourceSet();
        ResourceSet rightSet = right.getResourceSet();
        EcoreUtil.resolveAll((ResourceSet)leftSet);
        EcoreUtil.resolveAll((ResourceSet)originSet);
        EcoreUtil.resolveAll((ResourceSet)rightSet);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)leftSet, (Notifier)rightSet, (Notifier)originSet);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Diff diff = (Diff)differences.get(0);
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        Assert.assertEquals((long)2L, (long)leftSet.getResources().size());
        Assert.assertEquals((long)1L, (long)originSet.getResources().size());
        Assert.assertEquals((long)2L, (long)rightSet.getResources().size());
        EObject leftFragmentedNode = this.getNodeNamed((Notifier)leftSet, "fragmented");
        EObject originFragmentedNode = this.getNodeNamed((Notifier)originSet, "fragmented");
        EObject rightFragmentedNode = this.getNodeNamed((Notifier)rightSet, "fragmented");
        Assert.assertTrue((leftFragmentedNode.eContainer().eResource() != leftFragmentedNode.eResource() ? 1 : 0) != 0);
        Assert.assertTrue((originFragmentedNode.eContainer().eResource() == originFragmentedNode.eResource() ? 1 : 0) != 0);
        Assert.assertTrue((rightFragmentedNode.eContainer().eResource() != rightFragmentedNode.eResource() ? 1 : 0) != 0);
        Comparison lrCompare = EMFCompare.builder().build().compare((IComparisonScope)new DefaultComparisonScope((Notifier)leftSet, (Notifier)rightSet, null));
        Assert.assertEquals((long)0L, (long)lrCompare.getDifferences().size());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
        Assert.assertEquals((long)1L, (long)comparison.getConflicts().size());
        Assert.assertSame((Object)ConflictKind.PSEUDO, (Object)((Conflict)comparison.getConflicts().get(0)).getKind());
    }

    @Test
    public void testMergeControledObjectFolderResourceSetRtL() throws IOException {
        Resource left = this.input.getControlLeftFolder();
        Resource origin = this.input.getControlOriginFolder();
        Resource right = this.input.getControlRightFolder();
        ResourceSet leftSet = left.getResourceSet();
        ResourceSet originSet = origin.getResourceSet();
        ResourceSet rightSet = right.getResourceSet();
        EcoreUtil.resolveAll((ResourceSet)leftSet);
        EcoreUtil.resolveAll((ResourceSet)originSet);
        EcoreUtil.resolveAll((ResourceSet)rightSet);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)leftSet, (Notifier)rightSet, (Notifier)originSet);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Diff diff = (Diff)differences.get(0);
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        Assert.assertEquals((long)2L, (long)leftSet.getResources().size());
        Assert.assertEquals((long)1L, (long)originSet.getResources().size());
        Assert.assertEquals((long)1L, (long)rightSet.getResources().size());
        for (Resource res : leftSet.getResources()) {
            if (res == left) continue;
            Assert.assertTrue((boolean)res.getContents().isEmpty());
        }
        EObject leftFragmentedNode = this.getNodeNamed((Notifier)leftSet, "fragmented");
        EObject originFragmentedNode = this.getNodeNamed((Notifier)originSet, "fragmented");
        EObject rightFragmentedNode = this.getNodeNamed((Notifier)rightSet, "fragmented");
        Assert.assertTrue((leftFragmentedNode.eContainer().eResource() == leftFragmentedNode.eResource() ? 1 : 0) != 0);
        Assert.assertTrue((originFragmentedNode.eContainer().eResource() == originFragmentedNode.eResource() ? 1 : 0) != 0);
        Assert.assertTrue((rightFragmentedNode.eContainer().eResource() == rightFragmentedNode.eResource() ? 1 : 0) != 0);
        Comparison lrCompare = EMFCompare.builder().build().compare((IComparisonScope)new DefaultComparisonScope((Notifier)leftSet, (Notifier)rightSet, null));
        Assert.assertTrue((boolean)lrCompare.getDifferences().isEmpty());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertTrue((boolean)comparison.getDifferences().isEmpty());
    }

    @Test
    public void testControledObjectFolderResource() throws IOException {
        Diff deletion;
        Diff addition;
        Resource left = this.input.getControlLeft();
        Resource origin = this.input.getControlOriginFolder();
        Resource right = this.input.getControlRightFolder();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)2L, (long)differences.size());
        if (((Diff)differences.get(0)).getKind() == DifferenceKind.ADD) {
            addition = (Diff)differences.get(0);
            deletion = (Diff)differences.get(1);
        } else {
            deletion = (Diff)differences.get(0);
            addition = (Diff)differences.get(1);
        }
        Assert.assertTrue((boolean)(addition instanceof ReferenceChange));
        Assert.assertEquals((Object)addition.getMatch().getLeft(), (Object)this.getNodeNamed((Notifier)left, "root"));
        Assert.assertEquals((Object)addition.getMatch().getRight(), (Object)this.getNodeNamed((Notifier)right, "root"));
        Assert.assertEquals((Object)addition.getMatch().getOrigin(), (Object)this.getNodeNamed((Notifier)origin, "root"));
        Assert.assertTrue((boolean)((ReferenceChange)addition).getValue().eIsProxy());
        Assert.assertSame((Object)addition.getSource(), (Object)DifferenceSource.LEFT);
        Assert.assertSame((Object)addition.getKind(), (Object)DifferenceKind.ADD);
        Assert.assertTrue((boolean)(deletion instanceof ReferenceChange));
        Assert.assertEquals((Object)deletion.getMatch().getLeft(), (Object)this.getNodeNamed((Notifier)left, "root"));
        Assert.assertEquals((Object)deletion.getMatch().getRight(), (Object)this.getNodeNamed((Notifier)right, "root"));
        Assert.assertEquals((Object)deletion.getMatch().getOrigin(), (Object)this.getNodeNamed((Notifier)origin, "root"));
        Assert.assertEquals((Object)((ReferenceChange)deletion).getValue(), (Object)this.getNodeNamed((Notifier)origin, "fragmented"));
        Assert.assertSame((Object)deletion.getSource(), (Object)DifferenceSource.LEFT);
        Assert.assertSame((Object)deletion.getKind(), (Object)DifferenceKind.DELETE);
    }

    @Test
    public void testMergeControledObjectFolderResourceLtR() throws IOException {
        Resource left = this.input.getControlLeftFolder();
        Resource origin = this.input.getControlOriginFolder();
        Resource right = this.input.getControlRightFolder();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        BatchMerger merger = new BatchMerger(this.mergerRegistry);
        merger.copyAllLeftToRight((Iterable)differences, (Monitor)new BasicMonitor());
        EObject leftFragmentedNode = this.getNodeNamed((Notifier)left, "fragmented");
        EObject originFragmentedNode = this.getNodeNamed((Notifier)origin, "fragmented");
        EObject rightFragmentedNode = this.getNodeNamed((Notifier)right, "fragmented");
        Assert.assertNull((Object)leftFragmentedNode);
        Assert.assertTrue((originFragmentedNode.eContainer().eResource() == originFragmentedNode.eResource() ? 1 : 0) != 0);
        Assert.assertNull((Object)rightFragmentedNode);
        List leftRootContent = ((InternalEList)this.getNodeNamed((Notifier)left, "root").eContents()).basicList();
        List originRootContent = ((InternalEList)this.getNodeNamed((Notifier)origin, "root").eContents()).basicList();
        List rightRootContent = ((InternalEList)this.getNodeNamed((Notifier)right, "root").eContents()).basicList();
        Assert.assertEquals((long)1L, (long)leftRootContent.size());
        Assert.assertEquals((long)1L, (long)originRootContent.size());
        Assert.assertEquals((long)1L, (long)rightRootContent.size());
        Assert.assertTrue((boolean)((EObject)leftRootContent.get(0)).eIsProxy());
        Assert.assertTrue((originRootContent.get(0) == originFragmentedNode ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((EObject)rightRootContent.get(0)).eIsProxy());
        Comparison lrCompare = EMFCompare.builder().build().compare((IComparisonScope)new DefaultComparisonScope((Notifier)left, (Notifier)right, null));
        Assert.assertEquals((long)0L, (long)lrCompare.getDifferences().size());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)4L, (long)comparison.getDifferences().size());
        Assert.assertEquals((long)2L, (long)comparison.getConflicts().size());
        Assert.assertSame((Object)ConflictKind.PSEUDO, (Object)((Conflict)comparison.getConflicts().get(0)).getKind());
        Assert.assertSame((Object)ConflictKind.PSEUDO, (Object)((Conflict)comparison.getConflicts().get(1)).getKind());
    }

    @Test
    public void testMergeControledObjectFolderResourceRtL() throws IOException {
        Resource left = this.input.getControlLeftFolder();
        Resource origin = this.input.getControlOriginFolder();
        Resource right = this.input.getControlRightFolder();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        BatchMerger merger = new BatchMerger(this.mergerRegistry);
        merger.copyAllRightToLeft((Iterable)differences, (Monitor)new BasicMonitor());
        EObject leftFragmentedNode = this.getNodeNamed((Notifier)left, "fragmented");
        EObject originFragmentedNode = this.getNodeNamed((Notifier)origin, "fragmented");
        EObject rightFragmentedNode = this.getNodeNamed((Notifier)right, "fragmented");
        Assert.assertTrue((leftFragmentedNode.eContainer().eResource() == leftFragmentedNode.eResource() ? 1 : 0) != 0);
        Assert.assertTrue((originFragmentedNode.eContainer().eResource() == originFragmentedNode.eResource() ? 1 : 0) != 0);
        Assert.assertTrue((rightFragmentedNode.eContainer().eResource() == rightFragmentedNode.eResource() ? 1 : 0) != 0);
        List leftRootContent = ((InternalEList)this.getNodeNamed((Notifier)left, "root").eContents()).basicList();
        List originRootContent = ((InternalEList)this.getNodeNamed((Notifier)origin, "root").eContents()).basicList();
        List rightRootContent = ((InternalEList)this.getNodeNamed((Notifier)right, "root").eContents()).basicList();
        Assert.assertEquals((long)1L, (long)leftRootContent.size());
        Assert.assertEquals((long)1L, (long)originRootContent.size());
        Assert.assertEquals((long)1L, (long)rightRootContent.size());
        Assert.assertTrue((leftRootContent.get(0) == leftFragmentedNode ? 1 : 0) != 0);
        Assert.assertTrue((originRootContent.get(0) == originFragmentedNode ? 1 : 0) != 0);
        Assert.assertTrue((rightRootContent.get(0) == rightFragmentedNode ? 1 : 0) != 0);
        Comparison lrCompare = EMFCompare.builder().build().compare((IComparisonScope)new DefaultComparisonScope((Notifier)left, (Notifier)right, null));
        Assert.assertEquals((long)0L, (long)lrCompare.getDifferences().size());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertTrue((boolean)comparison.getDifferences().isEmpty());
    }

    @Test
    public void testDeletedRootResourceSet() throws IOException {
        Resource left = this.input.getDeletedRootLeft();
        Resource origin = this.input.getDeletedRootOrigin();
        Resource right = this.input.getDeletedRootRight();
        ResourceSet leftSet = left.getResourceSet();
        ResourceSet originSet = origin.getResourceSet();
        ResourceSet rightSet = right.getResourceSet();
        Assert.assertNotNull((Object)leftSet);
        Assert.assertNotNull((Object)originSet);
        Assert.assertNotNull((Object)rightSet);
        EcoreUtil.resolveAll((ResourceSet)leftSet);
        EcoreUtil.resolveAll((ResourceSet)originSet);
        EcoreUtil.resolveAll((ResourceSet)rightSet);
        Assert.assertEquals((long)1L, (long)leftSet.getResources().size());
        Assert.assertEquals((long)1L, (long)originSet.getResources().size());
        Assert.assertEquals((long)1L, (long)rightSet.getResources().size());
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)leftSet, (Notifier)rightSet, (Notifier)originSet);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        Diff diff = (Diff)differences.get(0);
        Assert.assertTrue((boolean)(diff instanceof ResourceAttachmentChange));
        Assert.assertEquals((Object)diff.getMatch().getRight(), (Object)this.getNodeNamed((Notifier)right, "deletedRoot"));
        Assert.assertEquals((Object)diff.getMatch().getOrigin(), (Object)this.getNodeNamed((Notifier)origin, "deletedRoot"));
        Assert.assertNull((Object)diff.getMatch().getLeft());
        Assert.assertSame((Object)diff.getSource(), (Object)DifferenceSource.LEFT);
        Assert.assertSame((Object)diff.getKind(), (Object)DifferenceKind.DELETE);
    }

    @Test
    public void testMergeDeletedRootResourceSetLtR() throws IOException {
        Resource left = this.input.getDeletedRootLeft();
        Resource origin = this.input.getDeletedRootOrigin();
        Resource right = this.input.getDeletedRootRight();
        ResourceSet leftSet = left.getResourceSet();
        ResourceSet originSet = origin.getResourceSet();
        ResourceSet rightSet = right.getResourceSet();
        EcoreUtil.resolveAll((ResourceSet)leftSet);
        EcoreUtil.resolveAll((ResourceSet)originSet);
        EcoreUtil.resolveAll((ResourceSet)rightSet);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)leftSet, (Notifier)rightSet, (Notifier)originSet);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Diff diff = (Diff)differences.get(0);
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        Assert.assertEquals((long)1L, (long)left.getContents().size());
        Assert.assertEquals((long)2L, (long)origin.getContents().size());
        Assert.assertEquals((long)1L, (long)right.getContents().size());
        Comparison lrCompare = EMFCompare.builder().build().compare((IComparisonScope)new DefaultComparisonScope((Notifier)leftSet, (Notifier)rightSet, null));
        Assert.assertEquals((long)0L, (long)lrCompare.getDifferences().size());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
        Assert.assertEquals((long)1L, (long)comparison.getConflicts().size());
        Assert.assertSame((Object)ConflictKind.PSEUDO, (Object)((Conflict)comparison.getConflicts().get(0)).getKind());
    }

    @Test
    public void testMergeDeletedRootResourceSetRtL() throws IOException {
        Resource left = this.input.getDeletedRootLeft();
        Resource origin = this.input.getDeletedRootOrigin();
        Resource right = this.input.getDeletedRootRight();
        ResourceSet leftSet = left.getResourceSet();
        ResourceSet originSet = origin.getResourceSet();
        ResourceSet rightSet = right.getResourceSet();
        EcoreUtil.resolveAll((ResourceSet)leftSet);
        EcoreUtil.resolveAll((ResourceSet)originSet);
        EcoreUtil.resolveAll((ResourceSet)rightSet);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)leftSet, (Notifier)rightSet, (Notifier)originSet);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Diff diff = (Diff)differences.get(0);
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        Assert.assertEquals((long)2L, (long)left.getContents().size());
        Assert.assertEquals((long)2L, (long)origin.getContents().size());
        Assert.assertEquals((long)2L, (long)right.getContents().size());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testDeletedRootResource() throws IOException {
        Resource left = this.input.getDeletedRootLeft();
        Resource origin = this.input.getDeletedRootOrigin();
        Resource right = this.input.getDeletedRootRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        Diff diff = (Diff)differences.get(0);
        Assert.assertTrue((boolean)(diff instanceof ResourceAttachmentChange));
        Assert.assertEquals((Object)diff.getMatch().getRight(), (Object)this.getNodeNamed((Notifier)right, "deletedRoot"));
        Assert.assertEquals((Object)diff.getMatch().getOrigin(), (Object)this.getNodeNamed((Notifier)origin, "deletedRoot"));
        Assert.assertNull((Object)diff.getMatch().getLeft());
        Assert.assertSame((Object)diff.getSource(), (Object)DifferenceSource.LEFT);
        Assert.assertSame((Object)diff.getKind(), (Object)DifferenceKind.DELETE);
    }

    @Test
    public void testMergeDeletedRootResourceLtR() throws IOException {
        Resource left = this.input.getDeletedRootLeft();
        Resource origin = this.input.getDeletedRootOrigin();
        Resource right = this.input.getDeletedRootRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Diff diff = (Diff)differences.get(0);
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        Assert.assertEquals((long)1L, (long)left.getContents().size());
        Assert.assertEquals((long)2L, (long)origin.getContents().size());
        Assert.assertEquals((long)1L, (long)right.getContents().size());
        Comparison lrCompare = EMFCompare.builder().build().compare((IComparisonScope)new DefaultComparisonScope((Notifier)left, (Notifier)right, null));
        Assert.assertEquals((long)0L, (long)lrCompare.getDifferences().size());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
        Assert.assertEquals((long)1L, (long)comparison.getConflicts().size());
        Assert.assertSame((Object)ConflictKind.PSEUDO, (Object)((Conflict)comparison.getConflicts().get(0)).getKind());
    }

    @Test
    public void testMergeDeletedRootResourceRtL() throws IOException {
        Resource left = this.input.getDeletedRootLeft();
        Resource origin = this.input.getDeletedRootOrigin();
        Resource right = this.input.getDeletedRootRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Diff diff = (Diff)differences.get(0);
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        Assert.assertEquals((long)2L, (long)left.getContents().size());
        Assert.assertEquals((long)2L, (long)origin.getContents().size());
        Assert.assertEquals((long)2L, (long)right.getContents().size());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testNewRootResourceSet() throws IOException {
        Resource left = this.input.getNewRootLeft();
        Resource origin = this.input.getNewRootOrigin();
        Resource right = this.input.getNewRootRight();
        ResourceSet leftSet = left.getResourceSet();
        ResourceSet originSet = origin.getResourceSet();
        ResourceSet rightSet = right.getResourceSet();
        Assert.assertNotNull((Object)leftSet);
        Assert.assertNotNull((Object)originSet);
        Assert.assertNotNull((Object)rightSet);
        EcoreUtil.resolveAll((ResourceSet)leftSet);
        EcoreUtil.resolveAll((ResourceSet)originSet);
        EcoreUtil.resolveAll((ResourceSet)rightSet);
        Assert.assertEquals((long)2L, (long)left.getContents().size());
        Assert.assertEquals((long)1L, (long)origin.getContents().size());
        Assert.assertEquals((long)1L, (long)right.getContents().size());
        Assert.assertEquals((long)1L, (long)leftSet.getResources().size());
        Assert.assertEquals((long)1L, (long)originSet.getResources().size());
        Assert.assertEquals((long)1L, (long)rightSet.getResources().size());
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)leftSet, (Notifier)rightSet, (Notifier)originSet);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        Diff diff = (Diff)differences.get(0);
        Assert.assertTrue((boolean)(diff instanceof ResourceAttachmentChange));
        Assert.assertEquals((Object)diff.getMatch().getLeft(), (Object)this.getNodeNamed((Notifier)left, "newRoot"));
        Assert.assertNull((Object)diff.getMatch().getOrigin());
        Assert.assertNull((Object)diff.getMatch().getRight());
        Assert.assertSame((Object)diff.getSource(), (Object)DifferenceSource.LEFT);
        Assert.assertSame((Object)diff.getKind(), (Object)DifferenceKind.ADD);
    }

    @Test
    public void testMergeNewRootResourceSetLtR() throws IOException {
        Resource left = this.input.getNewRootLeft();
        Resource origin = this.input.getNewRootOrigin();
        Resource right = this.input.getNewRootRight();
        ResourceSet leftSet = left.getResourceSet();
        ResourceSet originSet = origin.getResourceSet();
        ResourceSet rightSet = right.getResourceSet();
        EcoreUtil.resolveAll((ResourceSet)leftSet);
        EcoreUtil.resolveAll((ResourceSet)originSet);
        EcoreUtil.resolveAll((ResourceSet)rightSet);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)leftSet, (Notifier)rightSet, (Notifier)originSet);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Diff diff = (Diff)differences.get(0);
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        Assert.assertEquals((long)2L, (long)left.getContents().size());
        Assert.assertEquals((long)1L, (long)origin.getContents().size());
        Assert.assertEquals((long)2L, (long)right.getContents().size());
        Comparison lrCompare = EMFCompare.builder().build().compare((IComparisonScope)new DefaultComparisonScope((Notifier)leftSet, (Notifier)rightSet, null));
        Assert.assertEquals((long)0L, (long)lrCompare.getDifferences().size());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
        Assert.assertEquals((long)1L, (long)comparison.getConflicts().size());
        Assert.assertSame((Object)ConflictKind.PSEUDO, (Object)((Conflict)comparison.getConflicts().get(0)).getKind());
    }

    @Test
    public void testMergeNewRootResourceSetRtL() throws IOException {
        Resource left = this.input.getNewRootLeft();
        Resource origin = this.input.getNewRootOrigin();
        Resource right = this.input.getNewRootRight();
        ResourceSet leftSet = left.getResourceSet();
        ResourceSet originSet = origin.getResourceSet();
        ResourceSet rightSet = right.getResourceSet();
        EcoreUtil.resolveAll((ResourceSet)leftSet);
        EcoreUtil.resolveAll((ResourceSet)originSet);
        EcoreUtil.resolveAll((ResourceSet)rightSet);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)leftSet, (Notifier)rightSet, (Notifier)originSet);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Diff diff = (Diff)differences.get(0);
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        Assert.assertEquals((long)1L, (long)left.getContents().size());
        Assert.assertEquals((long)1L, (long)origin.getContents().size());
        Assert.assertEquals((long)1L, (long)right.getContents().size());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testNewRootResource() throws IOException {
        Resource left = this.input.getNewRootLeft();
        Resource origin = this.input.getNewRootOrigin();
        Resource right = this.input.getNewRootRight();
        Assert.assertEquals((long)2L, (long)left.getContents().size());
        Assert.assertEquals((long)1L, (long)origin.getContents().size());
        Assert.assertEquals((long)1L, (long)right.getContents().size());
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        Diff diff = (Diff)differences.get(0);
        Assert.assertTrue((boolean)(diff instanceof ResourceAttachmentChange));
        Assert.assertEquals((Object)diff.getMatch().getLeft(), (Object)this.getNodeNamed((Notifier)left, "newRoot"));
        Assert.assertNull((Object)diff.getMatch().getOrigin());
        Assert.assertNull((Object)diff.getMatch().getRight());
        Assert.assertSame((Object)diff.getSource(), (Object)DifferenceSource.LEFT);
        Assert.assertSame((Object)diff.getKind(), (Object)DifferenceKind.ADD);
    }

    @Test
    public void testMergeNewRootResourceLtR() throws IOException {
        Resource left = this.input.getNewRootLeft();
        Resource origin = this.input.getNewRootOrigin();
        Resource right = this.input.getNewRootRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Diff diff = (Diff)differences.get(0);
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        Assert.assertEquals((long)2L, (long)left.getContents().size());
        Assert.assertEquals((long)1L, (long)origin.getContents().size());
        Assert.assertEquals((long)2L, (long)right.getContents().size());
        Comparison lrCompare = EMFCompare.builder().build().compare((IComparisonScope)new DefaultComparisonScope((Notifier)left, (Notifier)right, null));
        Assert.assertEquals((long)0L, (long)lrCompare.getDifferences().size());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
        Assert.assertEquals((long)1L, (long)comparison.getConflicts().size());
        Assert.assertSame((Object)ConflictKind.PSEUDO, (Object)((Conflict)comparison.getConflicts().get(0)).getKind());
    }

    @Test
    public void testMergeNewRootResourceRtL() throws IOException {
        Resource left = this.input.getNewRootLeft();
        Resource origin = this.input.getNewRootOrigin();
        Resource right = this.input.getNewRootRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Diff diff = (Diff)differences.get(0);
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        Assert.assertEquals((long)1L, (long)left.getContents().size());
        Assert.assertEquals((long)1L, (long)origin.getContents().size());
        Assert.assertEquals((long)1L, (long)right.getContents().size());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    private EObject getNodeNamed(Notifier notifier, String name) {
        Object iterator = notifier instanceof ResourceSet ? Iterators.filter((Iterator)EcoreUtil.getAllProperContents((ResourceSet)((ResourceSet)notifier), (boolean)false), EObject.class) : (notifier instanceof Resource ? EcoreUtil.getAllProperContents((Resource)((Resource)notifier), (boolean)false) : EcoreUtil.getAllProperContents((EObject)((EObject)notifier), (boolean)false));
        while (iterator.hasNext()) {
            EObject next = (EObject)iterator.next();
            EStructuralFeature nameFeature = next.eClass().getEStructuralFeature("name");
            if (nameFeature == null || !name.equals(next.eGet(nameFeature))) continue;
            return next;
        }
        return null;
    }
}

