/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.logical.resolver;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.util.concurrent.FutureCallback;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.IComputation;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.ResourceComputationScheduler;
import org.eclipse.emf.compare.ide.ui.tests.logical.resolver.ResourceComputationSchedulerTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ResourceComputationSchedulerWithEventBusTest
extends ResourceComputationSchedulerTest {
    private EventBus bus;

    @Test
    public void testEventsLaunchedInStandardCase() throws Exception {
        this.scheduler.initialize();
        final ArrayList receivedEvents = new ArrayList();
        this.bus.register(new Object(){

            @Subscribe
            public void callStatusChanged(ResourceComputationScheduler.CallStatus cs) {
                receivedEvents.add(cs);
            }
        });
        this.scheduler.call((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return "";
            }
        }, null);
        Assert.assertEquals((long)4L, (long)receivedEvents.size());
        Assert.assertEquals((Object)ResourceComputationScheduler.ComputationState.SETTING_UP, (Object)((ResourceComputationScheduler.CallStatus)receivedEvents.get(0)).getState());
        Assert.assertEquals((Object)ResourceComputationScheduler.ComputationState.SCHEDULED, (Object)((ResourceComputationScheduler.CallStatus)receivedEvents.get(1)).getState());
        Assert.assertEquals((Object)ResourceComputationScheduler.ComputationState.FINISHING, (Object)((ResourceComputationScheduler.CallStatus)receivedEvents.get(2)).getState());
        Assert.assertEquals((Object)ResourceComputationScheduler.ComputationState.FINISHED, (Object)((ResourceComputationScheduler.CallStatus)receivedEvents.get(3)).getState());
    }

    @Test
    public void testEventsLaunchedWhenCallThrowsException() throws Exception {
        this.scheduler.initialize();
        final ArrayList receivedEvents = new ArrayList();
        this.bus.register(new Object(){

            @Subscribe
            public void callStatusChanged(ResourceComputationScheduler.CallStatus cs) {
                receivedEvents.add(cs);
            }
        });
        Exception exceptionReceived = null;
        try {
            this.scheduler.call((Callable)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    throw new Exception("Test");
                }
            }, null);
        }
        catch (Exception e) {
            exceptionReceived = e;
        }
        Assert.assertEquals((long)5L, (long)receivedEvents.size());
        Assert.assertEquals((Object)ResourceComputationScheduler.ComputationState.SETTING_UP, (Object)((ResourceComputationScheduler.CallStatus)receivedEvents.get(0)).getState());
        Assert.assertEquals((Object)ResourceComputationScheduler.ComputationState.SCHEDULED, (Object)((ResourceComputationScheduler.CallStatus)receivedEvents.get(1)).getState());
        Assert.assertEquals((Object)ResourceComputationScheduler.ComputationState.FAILED, (Object)((ResourceComputationScheduler.CallStatus)receivedEvents.get(2)).getState());
        Assert.assertNotNull((Object)exceptionReceived);
        Assert.assertSame((Object)exceptionReceived.getCause(), (Object)((ResourceComputationScheduler.CallStatus)receivedEvents.get(2)).getCause());
        Assert.assertEquals((Object)ResourceComputationScheduler.ComputationState.FINISHING, (Object)((ResourceComputationScheduler.CallStatus)receivedEvents.get(3)).getState());
        Assert.assertEquals((Object)ResourceComputationScheduler.ComputationState.FINISHED, (Object)((ResourceComputationScheduler.CallStatus)receivedEvents.get(4)).getState());
    }

    @Test
    public void testEventsLaunchedWhenPostTreamentThrowsException() throws Exception {
        this.scheduler.initialize();
        final ArrayList receivedEvents = new ArrayList();
        this.bus.register(new Object(){

            @Subscribe
            public void callStatusChanged(ResourceComputationScheduler.CallStatus cs) {
                receivedEvents.add(cs);
            }
        });
        try {
            this.scheduler.call((Callable)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return "";
                }
            }, new Runnable(){

                @Override
                public void run() {
                    throw new RuntimeException();
                }
            });
            Assert.fail((String)"There should have been a RuntimeException");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertEquals((long)4L, (long)receivedEvents.size());
        Assert.assertEquals((Object)ResourceComputationScheduler.ComputationState.SETTING_UP, (Object)((ResourceComputationScheduler.CallStatus)receivedEvents.get(0)).getState());
        Assert.assertEquals((Object)ResourceComputationScheduler.ComputationState.SCHEDULED, (Object)((ResourceComputationScheduler.CallStatus)receivedEvents.get(1)).getState());
        Assert.assertEquals((Object)ResourceComputationScheduler.ComputationState.FINISHING, (Object)((ResourceComputationScheduler.CallStatus)receivedEvents.get(2)).getState());
        Assert.assertEquals((Object)ResourceComputationScheduler.ComputationState.FINISHED, (Object)((ResourceComputationScheduler.CallStatus)receivedEvents.get(3)).getState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDemandShutdownWithLongRunningTaskThatInterruptsImproperly() throws Exception {
        this.scheduler.initialize();
        final ResourceComputationSchedulerTest.CompStatus cs = new ResourceComputationSchedulerTest.CompStatus();
        final AtomicBoolean readyForFinalChecks = new AtomicBoolean(false);
        final TriggerableComputation tc = new TriggerableComputation(cs, "long1", false){

            @Override
            protected void succeeded(Object r) {
                cs.success("As expected");
            }

            @Override
            protected void failed(Throwable t) {
                cs.fail("failed() called, should have been succeeded().");
            }
        };
        this.bus.register(new Object(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Subscribe
            public void check(ResourceComputationScheduler.ShutdownStatus status) {
                ResourceComputationScheduler resourceComputationScheduler = ResourceComputationSchedulerWithEventBusTest.this.scheduler;
                synchronized (resourceComputationScheduler) {
                    switch (status.getState()) {
                        case FINISH_SUCCESS: {
                            cs.setShutdownStatus(status);
                            readyForFinalChecks.compareAndSet(false, true);
                            ResourceComputationSchedulerWithEventBusTest.this.scheduler.notifyAll();
                            break;
                        }
                        case FINISH_FAILED: {
                            cs.setShutdownStatus(status);
                            readyForFinalChecks.compareAndSet(false, true);
                            ResourceComputationSchedulerWithEventBusTest.this.scheduler.notifyAll();
                        }
                    }
                }
            }
        });
        try {
            Integer result = (Integer)this.scheduler.call((Callable)new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    ResourceComputationSchedulerWithEventBusTest.this.scheduler.scheduleComputation((IComputation)tc);
                    ResourceComputationSchedulerWithEventBusTest.this.scheduler.demandShutdown();
                    return 42;
                }
            }, null);
            Assert.assertEquals((Object)42, (Object)result);
            Assert.assertTrue((boolean)this.scheduler.getComputedElements().isEmpty());
            ResourceComputationScheduler resourceComputationScheduler = this.scheduler;
            synchronized (resourceComputationScheduler) {
                while (!readyForFinalChecks.get()) {
                    this.scheduler.wait();
                }
                Assert.assertEquals((long)1L, (long)cs.getCallCount());
                Assert.assertTrue((boolean)cs.isInterrupted());
                Assert.assertFalse((boolean)cs.isFailed());
                Assert.assertFalse((boolean)cs.isSuccess());
                Assert.assertNull((Object)cs.getMessage());
                Assert.assertEquals((Object)ResourceComputationScheduler.ShutdownState.FINISH_SUCCESS, (Object)cs.getShutdownStatus().getState());
            }
        }
        finally {
            tc.trigger();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDemandShutdownWithLongRunningTaskThatInterruptsGracefully() throws Exception {
        this.scheduler.initialize();
        final ResourceComputationSchedulerTest.CompStatus cs = new ResourceComputationSchedulerTest.CompStatus();
        final AtomicBoolean readyForFinalChecks = new AtomicBoolean(false);
        final TriggerableComputation tc = new TriggerableComputation(cs, "long1", true){

            @Override
            protected void failed(Throwable t) {
                cs.fail("As expected");
            }

            @Override
            protected void succeeded(Object r) {
                cs.success("Computation ends successfully when it should have failed.");
            }
        };
        this.bus.register(new Object(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Subscribe
            public void check(ResourceComputationScheduler.ShutdownStatus status) {
                ResourceComputationScheduler resourceComputationScheduler = ResourceComputationSchedulerWithEventBusTest.this.scheduler;
                synchronized (resourceComputationScheduler) {
                    switch (status.getState()) {
                        case FINISH_SUCCESS: {
                            cs.setShutdownStatus(status);
                            readyForFinalChecks.compareAndSet(false, true);
                            ResourceComputationSchedulerWithEventBusTest.this.scheduler.notifyAll();
                            break;
                        }
                        case FINISH_FAILED: {
                            cs.setShutdownStatus(status);
                            readyForFinalChecks.compareAndSet(false, true);
                            ResourceComputationSchedulerWithEventBusTest.this.scheduler.notifyAll();
                        }
                    }
                }
            }
        });
        Integer result = (Integer)this.scheduler.call((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                ResourceComputationSchedulerWithEventBusTest.this.scheduler.scheduleComputation((IComputation)tc);
                ResourceComputationSchedulerWithEventBusTest.this.scheduler.demandShutdown();
                return 42;
            }
        }, null);
        Assert.assertEquals((Object)42, (Object)result);
        Assert.assertTrue((boolean)this.scheduler.getComputedElements().isEmpty());
        ResourceComputationScheduler resourceComputationScheduler = this.scheduler;
        synchronized (resourceComputationScheduler) {
            while (!readyForFinalChecks.get()) {
                this.scheduler.wait();
            }
            Assert.assertEquals((long)1L, (long)cs.getCallCount());
            Assert.assertTrue((String)cs.getMessage(), (boolean)cs.isInterrupted());
            Assert.assertTrue((String)cs.getMessage(), (boolean)cs.isFailed());
            Assert.assertFalse((String)cs.getMessage(), (boolean)cs.isSuccess());
            Assert.assertEquals((Object)"As expected", (Object)cs.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDemandShutdownWithRunningTaskThatTerminatesGracefully() throws Exception {
        this.scheduler = new ResourceComputationScheduler(1, TimeUnit.SECONDS, this.bus);
        this.scheduler.initialize();
        final ResourceComputationSchedulerTest.CompStatus cs = new ResourceComputationSchedulerTest.CompStatus();
        final AtomicBoolean readyForFinalChecks = new AtomicBoolean(false);
        final TriggerableComputation tc = new TriggerableComputation(cs, "long1", false){

            @Override
            protected void succeeded(Object r) {
                this.getStatus().success("As expected");
            }

            @Override
            protected void failed(Throwable t) {
                this.getStatus().fail("failed() should not have been called.");
            }
        };
        this.bus.register(new Object(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Subscribe
            public void check(ResourceComputationScheduler.ShutdownStatus status) {
                ResourceComputationScheduler resourceComputationScheduler = ResourceComputationSchedulerWithEventBusTest.this.scheduler;
                synchronized (resourceComputationScheduler) {
                    switch (status.getState()) {
                        case FINISH_SUCCESS: {
                            cs.setShutdownStatus(status);
                            readyForFinalChecks.compareAndSet(false, true);
                            ResourceComputationSchedulerWithEventBusTest.this.scheduler.notifyAll();
                            break;
                        }
                        case FINISH_FAILED: {
                            cs.setShutdownStatus(status);
                            readyForFinalChecks.compareAndSet(false, true);
                            ResourceComputationSchedulerWithEventBusTest.this.scheduler.notifyAll();
                        }
                    }
                }
            }
        });
        Integer result = (Integer)this.scheduler.call((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                ResourceComputationSchedulerWithEventBusTest.this.scheduler.scheduleComputation((IComputation)tc);
                ResourceComputationSchedulerWithEventBusTest.this.scheduler.demandShutdown();
                tc.trigger();
                return 42;
            }
        }, null);
        Assert.assertEquals((Object)42, (Object)result);
        Assert.assertTrue((boolean)this.scheduler.getComputedElements().isEmpty());
        ResourceComputationScheduler resourceComputationScheduler = this.scheduler;
        synchronized (resourceComputationScheduler) {
            while (!readyForFinalChecks.get()) {
                this.scheduler.wait();
            }
            Assert.assertEquals((long)1L, (long)cs.getCallCount());
            Assert.assertFalse((String)cs.getMessage(), (boolean)cs.isInterrupted());
            Assert.assertTrue((String)cs.getMessage(), (boolean)cs.isSuccess());
            Assert.assertFalse((String)cs.getMessage(), (boolean)cs.isFailed());
            Assert.assertEquals((Object)"As expected", (Object)cs.getMessage());
            Assert.assertEquals((Object)ResourceComputationScheduler.ShutdownState.FINISH_SUCCESS, (Object)cs.getShutdownStatus().getState());
        }
    }

    @Override
    @Before
    public void setUp() {
        this.bus = new EventBus();
        this.scheduler = new ResourceComputationScheduler(10, TimeUnit.MILLISECONDS, this.bus);
    }

    private static class TriggerableComputation
    implements IComputation<String> {
        private volatile boolean start = false;
        private final ResourceComputationSchedulerTest.CompStatus cs;
        private final String name;
        private final boolean throwOnInterrupt;

        public TriggerableComputation(ResourceComputationSchedulerTest.CompStatus cs, String name, boolean throwOnInterrupt) {
            this.cs = cs;
            this.name = name;
            this.throwOnInterrupt = throwOnInterrupt;
        }

        public void trigger() {
            this.start = true;
        }

        public void run() {
            this.cs.addCall();
            while (!this.start) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.cs.interrupt();
                    if (!this.throwOnInterrupt) continue;
                    throw new RuntimeException("Interrupted");
                }
            }
        }

        public FutureCallback<Object> getPostTreatment() {
            return new FutureCallback<Object>(){

                public void onFailure(Throwable t) {
                    this.failed(t);
                }

                public void onSuccess(Object r) {
                    this.succeeded(r);
                }
            };
        }

        public ResourceComputationSchedulerTest.CompStatus getStatus() {
            return this.cs;
        }

        public String getKey() {
            return this.name;
        }

        protected void failed(Throwable t) {
            this.cs.fail("As expected");
        }

        protected void succeeded(Object r) {
            this.cs.success("As expected");
        }
    }
}

