/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.tests.implications;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.Arrays;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.merge.BatchMerger;
import org.eclipse.emf.compare.uml2.internal.DirectedRelationshipChange;
import org.eclipse.emf.compare.uml2.tests.AbstractUMLInputData;
import org.eclipse.emf.compare.uml2.tests.AbstractUMLTest;
import org.eclipse.emf.compare.uml2.tests.implications.data.ImplicationsInputData;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.uml2.uml.UMLPackage;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ImplicationsInterfaceRealizationTest
extends AbstractUMLTest {
    private static final int NB_DIFFS = 9;
    private static final int NB_INTERFACE_REALIZATION_DIFFS = 5;
    private ImplicationsInputData input = new ImplicationsInputData();

    @BeforeClass
    public static void setupClass() {
        ImplicationsInterfaceRealizationTest.fillRegistries();
    }

    @AfterClass
    public static void teardownClass() {
        ImplicationsInterfaceRealizationTest.resetRegistries();
    }

    private DiffsOfInterest getDiffs(Comparison comparison, AbstractUMLTest.TestKind kind) {
        EList differences = comparison.getDifferences();
        Predicate addInterfaceRealizationDescription = null;
        Predicate addClientInInterfaceRealizationDescription = null;
        Predicate addSupplierInInterfaceRealizationDescription = null;
        Predicate addContractInInterfaceRealizationDescription = null;
        Predicate addSubstitutionDescription = null;
        Predicate addClientInSubstitutionDescription = null;
        Predicate addSupplierInSubstitutionDescription = null;
        if (kind.equals((Object)AbstractUMLTest.TestKind.DELETE)) {
            addInterfaceRealizationDescription = EMFComparePredicates.removedFromReference((String)"model.Class0", (String)"interfaceRealization", (String)"model.Class0.InterfaceRealization0");
            addClientInInterfaceRealizationDescription = EMFComparePredicates.removedFromReference((String)"model.Class0.InterfaceRealization0", (String)"client", (String)"model.Class0");
            addSupplierInInterfaceRealizationDescription = EMFComparePredicates.removedFromReference((String)"model.Class0.InterfaceRealization0", (String)"supplier", (String)"model.Interface0");
            addContractInInterfaceRealizationDescription = EMFComparePredicates.changedReference((String)"model.Class0.InterfaceRealization0", (String)"contract", (String)"model.Interface0", null);
            addSubstitutionDescription = EMFComparePredicates.removedFromReference((String)"model.Class0", (String)"substitution", (String)"model.Class0.substitution1");
            addClientInSubstitutionDescription = EMFComparePredicates.removedFromReference((String)"model.Class0.substitution1", (String)"client", (String)"model.Class0");
            addSupplierInSubstitutionDescription = EMFComparePredicates.removedFromReference((String)"model.Class0.substitution1", (String)"supplier", (String)"model.Interface0");
        } else {
            addInterfaceRealizationDescription = EMFComparePredicates.addedToReference((String)"model.Class0", (String)"interfaceRealization", (String)"model.Class0.InterfaceRealization0");
            addClientInInterfaceRealizationDescription = EMFComparePredicates.addedToReference((String)"model.Class0.InterfaceRealization0", (String)"client", (String)"model.Class0");
            addSupplierInInterfaceRealizationDescription = EMFComparePredicates.addedToReference((String)"model.Class0.InterfaceRealization0", (String)"supplier", (String)"model.Interface0");
            addContractInInterfaceRealizationDescription = EMFComparePredicates.changedReference((String)"model.Class0.InterfaceRealization0", (String)"contract", null, (String)"model.Interface0");
            addSubstitutionDescription = EMFComparePredicates.addedToReference((String)"model.Class0", (String)"substitution", (String)"model.Class0.substitution1");
            addClientInSubstitutionDescription = EMFComparePredicates.addedToReference((String)"model.Class0.substitution1", (String)"client", (String)"model.Class0");
            addSupplierInSubstitutionDescription = EMFComparePredicates.addedToReference((String)"model.Class0.substitution1", (String)"supplier", (String)"model.Interface0");
        }
        DiffsOfInterest diffs = new DiffsOfInterest();
        diffs.addInterfaceRealization = (Diff)Iterators.find(differences.iterator(), (Predicate)addInterfaceRealizationDescription, null);
        diffs.addClientInInterfaceRealization = (Diff)Iterators.find(differences.iterator(), (Predicate)addClientInInterfaceRealizationDescription, null);
        diffs.addSupplierInInterfaceRealization = (Diff)Iterators.find(differences.iterator(), (Predicate)addSupplierInInterfaceRealizationDescription, null);
        diffs.addContractInInterfaceRealization = (Diff)Iterators.find(differences.iterator(), (Predicate)addContractInInterfaceRealizationDescription, null);
        diffs.addSubstitution = (Diff)Iterators.find(differences.iterator(), (Predicate)addSubstitutionDescription, null);
        diffs.addClientInSubstitution = (Diff)Iterators.find(differences.iterator(), (Predicate)addClientInSubstitutionDescription, null);
        diffs.addSupplierInSubstitution = (Diff)Iterators.find(differences.iterator(), (Predicate)addSupplierInSubstitutionDescription, null);
        diffs.addUMLInterfaceRealization = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(DirectedRelationshipChange.class), ImplicationsInterfaceRealizationTest.discriminantInstanceOf(UMLPackage.Literals.INTERFACE_REALIZATION)), null);
        diffs.addUMLSubstitution = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(DirectedRelationshipChange.class), ImplicationsInterfaceRealizationTest.discriminantInstanceOf(UMLPackage.Literals.SUBSTITUTION)), null);
        return diffs;
    }

    @Test
    public void testA10UseCase() throws IOException {
        Resource left = this.input.getA3Left();
        Resource right = this.input.getA3Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        this.testAB1(AbstractUMLTest.TestKind.ADD, comparison);
    }

    @Test
    public void testA10UseCase3way1() throws IOException {
        Resource left = this.input.getA3Left();
        Resource right = this.input.getA3Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        this.testAB1(AbstractUMLTest.TestKind.ADD, comparison);
    }

    @Test
    public void testA10UseCase3way2() throws IOException {
        Resource left = this.input.getA3Right();
        Resource right = this.input.getA3Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        this.testAB1(AbstractUMLTest.TestKind.ADD, comparison);
    }

    @Test
    public void testA10MergeLtR1UseCase() throws IOException {
        Resource left = this.input.getA3Left();
        Resource right = this.input.getA3Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addClientInInterfaceRealization), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        this.checkMergeInterfaceRealization(comparison, diffs);
    }

    private void checkMergeInterfaceRealization(Comparison comparison, DiffsOfInterest diffs) {
        Assert.assertEquals((long)4L, (long)comparison.getDifferences().size());
        Assert.assertNull((Object)diffs.addUMLInterfaceRealization);
        Assert.assertNull((Object)diffs.addInterfaceRealization);
        Assert.assertNull((Object)diffs.addClientInInterfaceRealization);
        Assert.assertNull((Object)diffs.addContractInInterfaceRealization);
        Assert.assertNull((Object)diffs.addSupplierInInterfaceRealization);
        Assert.assertNotNull((Object)diffs.addUMLSubstitution);
        Assert.assertNotNull((Object)diffs.addSubstitution);
        Assert.assertNotNull((Object)diffs.addClientInSubstitution);
        Assert.assertNotNull((Object)diffs.addSupplierInSubstitution);
    }

    @Test
    public void testA10MergeLtR1UseCase3way1() throws IOException {
        Resource left = this.input.getA3Left();
        Resource right = this.input.getA3Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addClientInInterfaceRealization), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        this.checkMergeInterfaceRealization(comparison, diffs);
    }

    @Test
    public void testA10MergeLtR1UseCase3way2() throws IOException {
        Resource left = this.input.getA3Right();
        Resource right = this.input.getA3Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addClientInInterfaceRealization), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        this.checkMergeInterfaceRealization(comparison, diffs);
    }

    @Test
    public void testA10MergeLtR3UseCase() throws IOException {
        Resource left = this.input.getA3Left();
        Resource right = this.input.getA3Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addInterfaceRealization), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        this.checkMergeInterfaceRealization(comparison, diffs);
    }

    @Test
    public void testA10MergeLtR3UseCase3way1() throws IOException {
        Resource left = this.input.getA3Left();
        Resource right = this.input.getA3Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addInterfaceRealization), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        this.checkMergeInterfaceRealization(comparison, diffs);
    }

    @Test
    public void testA10MergeLtR3UseCase3way2() throws IOException {
        Resource left = this.input.getA3Right();
        Resource right = this.input.getA3Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addInterfaceRealization), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        this.checkMergeInterfaceRealization(comparison, diffs);
    }

    @Test
    public void testA10MergeRtL1UseCase() throws IOException {
        Resource left = this.input.getA3Left();
        Resource right = this.input.getA3Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addClientInInterfaceRealization), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        this.checkMergeInterfaceRealization(comparison, diffs);
    }

    @Test
    public void testA10MergeRtL1UseCase3way1() throws IOException {
        Resource left = this.input.getA3Left();
        Resource right = this.input.getA3Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addClientInInterfaceRealization), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        this.checkMergeInterfaceRealization(comparison, diffs);
    }

    @Test
    public void testA10MergeRtL1UseCase3way2() throws IOException {
        Resource left = this.input.getA3Right();
        Resource right = this.input.getA3Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addClientInInterfaceRealization), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        this.checkMergeInterfaceRealization(comparison, diffs);
    }

    @Test
    public void testA10MergeRtL3UseCase() throws IOException {
        Resource left = this.input.getA3Left();
        Resource right = this.input.getA3Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addInterfaceRealization), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        this.checkMergeInterfaceRealization(comparison, diffs);
    }

    @Test
    public void testA10MergeRtL3UseCase3way1() throws IOException {
        Resource left = this.input.getA3Left();
        Resource right = this.input.getA3Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addInterfaceRealization), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        this.checkMergeInterfaceRealization(comparison, diffs);
    }

    @Test
    public void testA10MergeRtL3UseCase3way2() throws IOException {
        Resource left = this.input.getA3Right();
        Resource right = this.input.getA3Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addInterfaceRealization), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        this.checkMergeInterfaceRealization(comparison, diffs);
    }

    @Test
    public void testA11UseCase() throws IOException {
        Resource left = this.input.getA3Right();
        Resource right = this.input.getA3Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        this.testAB1(AbstractUMLTest.TestKind.DELETE, comparison);
    }

    @Test
    public void testA11UseCase3way1() throws IOException {
        Resource left = this.input.getA3Right();
        Resource right = this.input.getA3Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        this.testAB1(AbstractUMLTest.TestKind.DELETE, comparison);
    }

    @Test
    public void testA11UseCase3way2() throws IOException {
        Resource left = this.input.getA3Left();
        Resource right = this.input.getA3Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        this.testAB1(AbstractUMLTest.TestKind.DELETE, comparison);
    }

    @Test
    public void testA11MergeLtR1UseCase() throws IOException {
        Resource left = this.input.getA3Right();
        Resource right = this.input.getA3Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addClientInInterfaceRealization), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        this.checkMergeInterfaceRealization(comparison, diffs);
    }

    @Test
    public void testA11MergeLtR1UseCase3way1() throws IOException {
        Resource left = this.input.getA3Right();
        Resource right = this.input.getA3Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addClientInInterfaceRealization), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        this.checkMergeInterfaceRealization(comparison, diffs);
    }

    @Test
    public void testA11MergeLtR1UseCase3way2() throws IOException {
        Resource left = this.input.getA3Left();
        Resource right = this.input.getA3Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addClientInInterfaceRealization), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        this.checkMergeInterfaceRealization(comparison, diffs);
    }

    @Test
    public void testA11MergeLtR3UseCase() throws IOException {
        Resource left = this.input.getA3Right();
        Resource right = this.input.getA3Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addInterfaceRealization), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        this.checkMergeInterfaceRealization(comparison, diffs);
    }

    @Test
    public void testA11MergeLtR3UseCase3way1() throws IOException {
        Resource left = this.input.getA3Right();
        Resource right = this.input.getA3Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addInterfaceRealization), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        this.checkMergeInterfaceRealization(comparison, diffs);
    }

    @Test
    public void testA11MergeLtR3UseCase3way2() throws IOException {
        Resource left = this.input.getA3Left();
        Resource right = this.input.getA3Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addInterfaceRealization), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        this.checkMergeInterfaceRealization(comparison, diffs);
    }

    @Test
    public void testA11MergeRtL1UseCase() throws IOException {
        Resource left = this.input.getA3Right();
        Resource right = this.input.getA3Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addClientInInterfaceRealization), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        this.checkMergeInterfaceRealization(comparison, diffs);
    }

    @Test
    public void testA11MergeRtL1UseCase3way1() throws IOException {
        Resource left = this.input.getA3Right();
        Resource right = this.input.getA3Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addClientInInterfaceRealization), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        this.checkMergeInterfaceRealization(comparison, diffs);
    }

    @Test
    public void testA11MergeRtL1UseCase3way2() throws IOException {
        Resource left = this.input.getA3Left();
        Resource right = this.input.getA3Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addClientInInterfaceRealization), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        this.checkMergeInterfaceRealization(comparison, diffs);
    }

    @Test
    public void testA11MergeRtL3UseCase() throws IOException {
        Resource left = this.input.getA3Right();
        Resource right = this.input.getA3Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addInterfaceRealization), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        this.checkMergeInterfaceRealization(comparison, diffs);
    }

    @Test
    public void testA11MergeRtL3UseCase3way1() throws IOException {
        Resource left = this.input.getA3Right();
        Resource right = this.input.getA3Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addInterfaceRealization), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        this.checkMergeInterfaceRealization(comparison, diffs);
    }

    @Test
    public void testA11MergeRtL3UseCase3way2() throws IOException {
        Resource left = this.input.getA3Left();
        Resource right = this.input.getA3Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addInterfaceRealization), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        this.checkMergeInterfaceRealization(comparison, diffs);
    }

    private void testAB1(AbstractUMLTest.TestKind kind, Comparison comparison) {
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)9L, (long)differences.size());
        DiffsOfInterest diffs = this.getDiffs(comparison, kind);
        if (kind.equals((Object)AbstractUMLTest.TestKind.DELETE)) {
            Assert.assertEquals((long)1L, (long)diffs.addInterfaceRealization.getImpliedBy().size());
            Assert.assertTrue((boolean)diffs.addInterfaceRealization.getImpliedBy().contains((Object)diffs.addClientInInterfaceRealization));
            Assert.assertEquals((long)1L, (long)diffs.addSubstitution.getImpliedBy().size());
            Assert.assertTrue((boolean)diffs.addSubstitution.getImpliedBy().contains((Object)diffs.addClientInSubstitution));
        } else {
            Assert.assertEquals((long)1L, (long)diffs.addInterfaceRealization.getImplies().size());
            Assert.assertTrue((boolean)diffs.addInterfaceRealization.getImplies().contains((Object)diffs.addClientInInterfaceRealization));
            Assert.assertEquals((long)1L, (long)diffs.addSubstitution.getImplies().size());
            Assert.assertTrue((boolean)diffs.addSubstitution.getImplies().contains((Object)diffs.addClientInSubstitution));
        }
    }

    @Override
    protected AbstractUMLInputData getInput() {
        return this.input;
    }

    private class DiffsOfInterest {
        public Diff addInterfaceRealization;
        public Diff addClientInInterfaceRealization;
        public Diff addSupplierInInterfaceRealization;
        public Diff addContractInInterfaceRealization;
        public Diff addSubstitution;
        public Diff addClientInSubstitution;
        public Diff addSupplierInSubstitution;
        public Diff addUMLInterfaceRealization;
        public Diff addUMLSubstitution;

        private DiffsOfInterest() {
        }
    }
}

