/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.structuremergeviewer.actions;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.List;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.INavigatable;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.domain.ICompareEditingDomain;
import org.eclipse.emf.compare.domain.impl.EMFCompareEditingDomain;
import org.eclipse.emf.compare.ide.ui.internal.configuration.EMFCompareConfiguration;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions.MergeAction;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions.MergeAllNonConflictingAction;
import org.eclipse.emf.compare.ide.ui.tests.command.data.MergeAllCommandInputData;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.IEMFCompareConfiguration;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MirroredMergeActionTest {
    private Resource leftResource;
    private Resource rightResource;
    private Resource originResource;
    private IMerger.Registry mergerRegistry;
    private EMFCompareEditingDomain editingDomain;

    @Before
    public void getInputData() throws IOException {
        MergeAllCommandInputData input = new MergeAllCommandInputData();
        this.leftResource = input.getLeftScope();
        this.rightResource = input.getRightScope();
        this.originResource = input.getOriginScope();
        this.mergerRegistry = IMerger.RegistryImpl.createStandaloneInstance();
        this.editingDomain = (EMFCompareEditingDomain)EMFCompareEditingDomain.create((Notifier)this.leftResource, (Notifier)this.rightResource, (Notifier)this.originResource);
    }

    @After
    public void tearDown() {
        this.editingDomain.dispose();
    }

    private void testMirrorMergeAction(MergeMode actionMergeMode, DifferenceState expectedLeftDiffState, DifferenceState expectedRightDiffState) {
        IEMFCompareConfiguration emfCC = this.createConfiguration(true, true);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)this.leftResource, (Notifier)this.rightResource, (Notifier)this.originResource);
        Comparison comparision = EMFCompare.builder().build().compare((IComparisonScope)scope);
        MockMergeAction mergeAction = new MockMergeAction(emfCC, this.mergerRegistry, actionMergeMode, null);
        Diff leftDiff = (Diff)Iterables.get((Iterable)Iterables.filter((Iterable)comparision.getDifferences(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT)), (int)0);
        Assert.assertEquals((Object)DifferenceState.UNRESOLVED, (Object)leftDiff.getState());
        mergeAction.updateSelection((IStructuredSelection)new StructuredSelection((Object)leftDiff));
        mergeAction.run();
        leftDiff = (Diff)Iterables.get((Iterable)Iterables.filter((Iterable)comparision.getDifferences(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT)), (int)0);
        Assert.assertEquals((Object)expectedLeftDiffState, (Object)leftDiff.getState());
        Diff rightDiff = (Diff)Iterables.get((Iterable)Iterables.filter((Iterable)comparision.getDifferences(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT)), (int)0);
        Assert.assertEquals((Object)DifferenceState.UNRESOLVED, (Object)rightDiff.getState());
        mergeAction.updateSelection((IStructuredSelection)new StructuredSelection((Object)rightDiff));
        mergeAction.run();
        rightDiff = (Diff)Iterables.get((Iterable)Iterables.filter((Iterable)comparision.getDifferences(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT)), (int)0);
        Assert.assertEquals((Object)expectedRightDiffState, (Object)rightDiff.getState());
    }

    private void testMirrorMergeAction(MergeMode actionMergeMode, DifferenceState expectedDiffState) {
        IEMFCompareConfiguration emfCC = this.createConfiguration(true, false);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)this.leftResource, (Notifier)this.rightResource, (Notifier)this.originResource);
        Comparison comparision = EMFCompare.builder().build().compare((IComparisonScope)scope);
        MockMergeAction mergeAction = new MockMergeAction(emfCC, this.mergerRegistry, actionMergeMode, null);
        Diff leftDiff = (Diff)Iterables.get((Iterable)Iterables.filter((Iterable)comparision.getDifferences(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT)), (int)0);
        Assert.assertEquals((Object)DifferenceState.UNRESOLVED, (Object)leftDiff.getState());
        mergeAction.updateSelection((IStructuredSelection)new StructuredSelection((Object)leftDiff));
        mergeAction.run();
        leftDiff = (Diff)Iterables.get((Iterable)Iterables.filter((Iterable)comparision.getDifferences(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT)), (int)0);
        Assert.assertEquals((Object)expectedDiffState, (Object)leftDiff.getState());
    }

    private void testMirrorAllNonConflictingAction(MergeMode actionMergeMode, DifferenceState expectedLeftDiffsState, DifferenceState expectedRightDiffsState) {
        IEMFCompareConfiguration emfCC = this.createConfiguration(true, true);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)this.leftResource, (Notifier)this.originResource, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        MergeAllNonConflictingAction mergeAcion = new MergeAllNonConflictingAction(emfCC, comparison, this.mergerRegistry, actionMergeMode);
        int leftDiffAmount = Iterables.size((Iterable)Iterables.filter((Iterable)comparison.getDifferences(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED}))));
        int rightDiffAmount = Iterables.size((Iterable)Iterables.filter((Iterable)comparison.getDifferences(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED}))));
        mergeAcion.run();
        Assert.assertEquals((long)leftDiffAmount, (long)Iterables.size((Iterable)Iterables.filter((Iterable)comparison.getDifferences(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{expectedLeftDiffsState})))));
        Assert.assertEquals((long)rightDiffAmount, (long)Iterables.size((Iterable)Iterables.filter((Iterable)comparison.getDifferences(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{expectedRightDiffsState})))));
    }

    private void testMirrorAllNonConflictingAction(MergeMode actionMergeMode, DifferenceState expectedDiffState) {
        IEMFCompareConfiguration emfCC = this.createConfiguration(true, false);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)this.leftResource, (Notifier)this.originResource, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        MergeAllNonConflictingAction mergeAcion = new MergeAllNonConflictingAction(emfCC, comparison, this.mergerRegistry, actionMergeMode);
        int leftDiffAmount = Iterables.size((Iterable)Iterables.filter((Iterable)comparison.getDifferences(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED}))));
        mergeAcion.run();
        Assert.assertEquals((long)leftDiffAmount, (long)Iterables.size((Iterable)Iterables.filter((Iterable)comparison.getDifferences(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{expectedDiffState})))));
    }

    @Test
    public void mirrorCopyLeftToRightAction() {
        this.testMirrorMergeAction(MergeMode.LEFT_TO_RIGHT, DifferenceState.DISCARDED, DifferenceState.MERGED);
    }

    @Test
    public void testMirrorCopyRightToLeftAction() {
        this.testMirrorMergeAction(MergeMode.RIGHT_TO_LEFT, DifferenceState.MERGED, DifferenceState.DISCARDED);
    }

    @Test
    public void testMirrorCopyAllNonConflictingFromLeftToRightAction() {
        this.testMirrorAllNonConflictingAction(MergeMode.LEFT_TO_RIGHT, DifferenceState.DISCARDED, DifferenceState.MERGED);
    }

    @Test
    public void testMirrorCopyAllNonConflictingFromRightToLeftAction() {
        this.testMirrorAllNonConflictingAction(MergeMode.RIGHT_TO_LEFT, DifferenceState.MERGED, DifferenceState.DISCARDED);
    }

    @Test
    public void testMirrorAcceptChangeAction() {
        this.testMirrorMergeAction(MergeMode.ACCEPT, DifferenceState.MERGED);
    }

    @Test
    public void testMirrorRejectChangeAction() {
        this.testMirrorMergeAction(MergeMode.REJECT, DifferenceState.DISCARDED);
    }

    @Test
    public void testMirrorAcceptAllNonConflictingAction() {
        this.testMirrorAllNonConflictingAction(MergeMode.ACCEPT, DifferenceState.MERGED);
    }

    @Test
    public void testMirrorRejectAllNonConflictingAction() {
        this.testMirrorAllNonConflictingAction(MergeMode.REJECT, DifferenceState.DISCARDED);
    }

    private IEMFCompareConfiguration createConfiguration(boolean leftEditable, boolean rightEditable) {
        CompareConfiguration cc = new CompareConfiguration();
        cc.setProperty("MIRRORED", (Object)Boolean.TRUE);
        cc.setLeftEditable(leftEditable);
        cc.setRightEditable(rightEditable);
        EMFCompareConfiguration emfCC = new EMFCompareConfiguration(cc);
        emfCC.setEditingDomain((ICompareEditingDomain)this.editingDomain);
        return emfCC;
    }

    class MockMergeAction
    extends MergeAction {
        public MockMergeAction(IEMFCompareConfiguration compareConfiguration, IMerger.Registry mergerRegistry, MergeMode mode, INavigatable navigatable) {
            super(compareConfiguration, mergerRegistry, mode, navigatable);
        }

        public boolean updateSelection(IStructuredSelection selection) {
            return super.updateSelection(selection);
        }

        protected void clearCache() {
            super.clearCache();
        }

        protected Iterable<Diff> getSelectedDifferences(IStructuredSelection selection) {
            List selectedObjects = selection.toList();
            return Iterables.filter((Iterable)selectedObjects, Diff.class);
        }
    }
}

