/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.merge;

import com.google.common.collect.Iterables;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Equivalence;
import org.eclipse.emf.compare.FeatureMapChange;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.internal.utils.ComparisonUtil;
import org.eclipse.emf.compare.internal.utils.DiffUtil;
import org.eclipse.emf.compare.merge.AbstractMerger;
import org.eclipse.emf.compare.utils.IEqualityHelper;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.BasicFeatureMap;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;

public class FeatureMapChangeMerger
extends AbstractMerger {
    @Override
    public boolean isMergerFor(Diff target) {
        return target instanceof FeatureMapChange;
    }

    @Override
    protected void accept(Diff diff, boolean rightToLeft) {
        FeatureMapChange featureMapChange = (FeatureMapChange)diff;
        switch (diff.getKind()) {
            case ADD: {
                this.addInTarget(featureMapChange, rightToLeft);
                break;
            }
            case DELETE: {
                this.removeFromTarget(featureMapChange, rightToLeft);
                break;
            }
            case MOVE: {
                this.moveElement(featureMapChange, rightToLeft);
                break;
            }
            case CHANGE: {
                this.changeValue(featureMapChange, rightToLeft);
                break;
            }
        }
    }

    @Override
    protected void reject(Diff diff, boolean rightToLeft) {
        FeatureMapChange featureMapChange = (FeatureMapChange)diff;
        switch (diff.getKind()) {
            case ADD: {
                this.removeFromTarget(featureMapChange, rightToLeft);
                break;
            }
            case DELETE: {
                this.addInTarget(featureMapChange, rightToLeft);
                break;
            }
            case MOVE: {
                this.moveElement(featureMapChange, rightToLeft);
                break;
            }
            case CHANGE: {
                this.changeValue(featureMapChange, rightToLeft);
                break;
            }
        }
    }

    protected void addInTarget(FeatureMapChange diff, boolean rightToLeft) {
        Match match = diff.getMatch();
        EObject expectedContainer = rightToLeft ? match.getLeft() : match.getRight();
        if (expectedContainer == null) {
            throw new IllegalStateException("Couldn't add in target because its parent hasn't been merged yet: " + diff);
        }
        Comparison comparison = match.getComparison();
        EAttribute attribute = diff.getAttribute();
        FeatureMap.Entry expectedValue = (FeatureMap.Entry)diff.getValue();
        int insertionIndex = this.findInsertionIndex(comparison, diff, rightToLeft);
        List targetList = (List)ReferenceUtil.safeEGet(expectedContainer, (EStructuralFeature)attribute);
        this.addFeatureMapValueInTarget(comparison, rightToLeft, targetList, insertionIndex, expectedValue);
    }

    private void addFeatureMapValueInTarget(Comparison comparison, boolean rightToLeft, List<Object> list, int insertionIndex, FeatureMap.Entry entry) {
        Object value = entry.getValue();
        EStructuralFeature key = entry.getEStructuralFeature();
        if (value instanceof EObject) {
            Match match = comparison.getMatch((EObject)value);
            EObject left = match.getLeft();
            EObject right = match.getRight();
            EObject copy = rightToLeft && left != null ? left : (!rightToLeft && right != null ? right : this.createCopy((EObject)value));
            ((BasicFeatureMap)list).addUnique(insertionIndex, (Object)FeatureMapUtil.createEntry((EStructuralFeature)key, (Object)copy));
            if (DiffUtil.isContainmentReference(key)) {
                if (rightToLeft) {
                    match.setLeft(copy);
                } else {
                    match.setRight(copy);
                }
                Resource initialResource = ((EObject)value).eResource();
                Resource targetResource = copy.eResource();
                if (initialResource instanceof XMIResource && targetResource instanceof XMIResource) {
                    ((XMIResource)targetResource).setID(copy, ((XMIResource)initialResource).getID((EObject)value));
                }
            }
        } else {
            ((BasicFeatureMap)list).add(insertionIndex, FeatureMapUtil.createEntry((EStructuralFeature)key, (Object)value));
        }
    }

    protected void removeFromTarget(FeatureMapChange diff, boolean rightToLeft) {
        EObject currentContainer = rightToLeft ? diff.getMatch().getLeft() : diff.getMatch().getRight();
        if (currentContainer != null) {
            FeatureMap.Entry expectedValue = (FeatureMap.Entry)diff.getValue();
            if (!this.isDiffSourceIsMergeTarget(diff, rightToLeft)) {
                List targetList = (List)ReferenceUtil.safeEGet(currentContainer, (EStructuralFeature)diff.getAttribute());
                for (Object object : targetList) {
                    if (!diff.getMatch().getComparison().getEqualityHelper().matchingValues(expectedValue, object)) continue;
                    expectedValue = (FeatureMap.Entry)object;
                    break;
                }
            }
            EAttribute attribute = diff.getAttribute();
            List targetList = (List)ReferenceUtil.safeEGet(currentContainer, (EStructuralFeature)attribute);
            Comparison comparison = diff.getMatch().getComparison();
            this.removeFeatureMapValueFromTarget(comparison, rightToLeft, targetList, expectedValue);
        }
    }

    private void removeFeatureMapValueFromTarget(Comparison comparison, boolean rightToLeft, List<Object> list, FeatureMap.Entry entry) {
        Object value = entry.getValue();
        EStructuralFeature key = entry.getEStructuralFeature();
        if (((EReference)key).isContainment()) {
            Match expectedContainerMatch = comparison.getMatch((EObject)value);
            if (rightToLeft) {
                expectedContainerMatch.setLeft(null);
            } else {
                expectedContainerMatch.setRight(null);
            }
        }
        ((BasicFeatureMap)list).remove(key, value);
    }

    protected void moveElement(FeatureMapChange diff, boolean rightToLeft) {
        Match match = diff.getMatch();
        Comparison comparison = match.getComparison();
        EObject expectedContainer = ComparisonUtil.moveElementGetExpectedContainer(comparison, diff, rightToLeft);
        if (expectedContainer == null) {
            throw new IllegalStateException("Couldn't move element because its parent hasn't been merged yet: " + diff);
        }
        FeatureMap.Entry expectedEntry = this.moveElementGetExpectedEntry(comparison, diff, expectedContainer, rightToLeft);
        this.doMove(diff, comparison, expectedContainer, expectedEntry, rightToLeft);
    }

    private FeatureMap.Entry moveElementGetExpectedEntry(Comparison comparison, FeatureMapChange diff, EObject expectedContainer, boolean rightToLeft) {
        FeatureMap.Entry expectedEntry = this.isDiffSourceIsMergeTarget(diff, rightToLeft) ? this.getExpectedEntryWhenDiffSourceIsMergeTarget(comparison, diff) : this.getExpectedEntryWhenDiffSourceIsNotMergeTarget(comparison, diff, expectedContainer, rightToLeft);
        return expectedEntry;
    }

    private FeatureMap.Entry getExpectedEntryWhenDiffSourceIsNotMergeTarget(Comparison comparison, FeatureMapChange diff, EObject expectedContainer, boolean rightToLeft) {
        FeatureMap.Entry expectedEntry;
        block2: {
            FeatureMap.Entry diffEntry;
            IEqualityHelper equalityHelper;
            block1: {
                expectedEntry = null;
                equalityHelper = comparison.getEqualityHelper();
                diffEntry = (FeatureMap.Entry)diff.getValue();
                Equivalence equ = diff.getEquivalence();
                if (!ComparisonUtil.isFeatureMapContainment(diff) || equ == null) break block1;
                Iterator iterator = Iterables.filter(equ.getDifferences(), ReferenceChange.class).iterator();
                if (!iterator.hasNext()) break block2;
                ReferenceChange equivalence = (ReferenceChange)iterator.next();
                Match equivalenceMatchValue = comparison.getMatch(equivalence.getValue());
                EObject expectedEntryValue = rightToLeft ? equivalenceMatchValue.getLeft() : equivalenceMatchValue.getRight();
                expectedEntry = FeatureMapUtil.createEntry((EStructuralFeature)diffEntry.getEStructuralFeature(), (Object)expectedEntryValue);
                break block2;
            }
            List targetList = (List)ReferenceUtil.safeEGet(expectedContainer, (EStructuralFeature)diff.getAttribute());
            for (Object object : targetList) {
                if (!equalityHelper.matchingValues(diffEntry, object)) continue;
                expectedEntry = (FeatureMap.Entry)object;
                break;
            }
        }
        return expectedEntry;
    }

    private FeatureMap.Entry getExpectedEntryWhenDiffSourceIsMergeTarget(Comparison comparison, FeatureMapChange diff) {
        FeatureMap.Entry expectedEntry;
        IEqualityHelper equalityHelper = comparison.getEqualityHelper();
        FeatureMap.Entry diffEntry = (FeatureMap.Entry)diff.getValue();
        Match matchValue = comparison.getMatch((EObject)diffEntry.getValue());
        EObject value = diff.getSource() == DifferenceSource.RIGHT ? matchValue.getRight() : matchValue.getLeft();
        if (comparison.isThreeWay() && ComparisonUtil.isFeatureMapContainment(diff)) {
            EStructuralFeature originKey = null;
            List originList = (List)ReferenceUtil.safeEGet(matchValue.getOrigin().eContainer(), (EStructuralFeature)diff.getAttribute());
            for (Object object : originList) {
                if (!(object instanceof FeatureMap.Entry) || !equalityHelper.matchingValues(value, ((FeatureMap.Entry)object).getValue())) continue;
                originKey = ((FeatureMap.Entry)object).getEStructuralFeature();
                break;
            }
            expectedEntry = FeatureMapUtil.createEntry(originKey, (Object)value);
        } else if (((EReference)diffEntry.getEStructuralFeature()).isContainment()) {
            EStructuralFeature targetReference = this.getTargetReference(comparison, diff);
            expectedEntry = FeatureMapUtil.createEntry((EStructuralFeature)targetReference, (Object)value);
        } else {
            expectedEntry = FeatureMapUtil.createEntry((EStructuralFeature)diffEntry.getEStructuralFeature(), (Object)value);
        }
        return expectedEntry;
    }

    private EStructuralFeature getTargetReference(Comparison comparison, FeatureMapChange diff) {
        FeatureMap.Entry diffEntry = (FeatureMap.Entry)diff.getValue();
        Match equivalenceMatchValue = comparison.getMatch((EObject)diffEntry.getValue());
        EObject targetValue = diff.getSource() == DifferenceSource.LEFT ? equivalenceMatchValue.getRight() : equivalenceMatchValue.getLeft();
        return targetValue.eContainingFeature();
    }

    private boolean isDiffSourceIsMergeTarget(Diff diff, boolean rightToLeft) {
        DifferenceSource source = diff.getSource();
        return source == DifferenceSource.LEFT && rightToLeft || source == DifferenceSource.RIGHT && !rightToLeft;
    }

    protected void doMove(FeatureMapChange diff, Comparison comparison, EObject expectedContainer, FeatureMap.Entry expectedValue, boolean rightToLeft) {
        EAttribute attribute = diff.getAttribute();
        if (attribute.isMany()) {
            List targetList;
            int currentIndex;
            int insertionIndex = this.findInsertionIndex(comparison, diff, rightToLeft);
            if (insertionIndex > (currentIndex = (targetList = (List)ReferenceUtil.safeEGet(expectedContainer, (EStructuralFeature)attribute)).indexOf(expectedValue)) && currentIndex >= 0) {
                --insertionIndex;
            }
            if (currentIndex == -1) {
                if (insertionIndex < 0 || insertionIndex > targetList.size()) {
                    ((BasicFeatureMap)targetList).addUnique(expectedValue);
                } else {
                    ((BasicFeatureMap)targetList).addUnique(insertionIndex, (Object)expectedValue);
                }
            } else if (insertionIndex < 0 || insertionIndex > targetList.size()) {
                ((BasicFeatureMap)targetList).move(targetList.size() - 1, (Object)expectedValue);
            } else {
                ((BasicFeatureMap)targetList).move(insertionIndex, (Object)expectedValue);
            }
        } else {
            ReferenceUtil.safeESet(expectedContainer, (EStructuralFeature)attribute, expectedValue);
        }
    }

    protected void changeValue(FeatureMapChange diff, boolean rightToLeft) {
        boolean resetToOrigin;
        Resource initialResource;
        Match match = diff.getMatch();
        IEqualityHelper equalityHelper = match.getComparison().getEqualityHelper();
        EAttribute attribute = diff.getAttribute();
        FeatureMap.Entry entry = (FeatureMap.Entry)diff.getValue();
        Object entryValue = entry.getValue();
        String originValueId = entryValue instanceof EObject ? ((initialResource = ((EObject)entryValue).eResource()) instanceof XMIResource ? ((XMIResource)initialResource).getID((EObject)entryValue) : null) : null;
        EObject expectedContainer = rightToLeft ? match.getLeft() : match.getRight();
        boolean bl = resetToOrigin = diff.getSource() == DifferenceSource.LEFT && rightToLeft || diff.getSource() == DifferenceSource.RIGHT && !rightToLeft;
        EObject originContainer = resetToOrigin && match.getComparison().isThreeWay() ? match.getOrigin() : (rightToLeft ? match.getRight() : match.getLeft());
        EStructuralFeature originKey = null;
        List originList = (List)ReferenceUtil.safeEGet(originContainer, (EStructuralFeature)attribute);
        for (Object object : originList) {
            if (!(object instanceof FeatureMap.Entry) || !equalityHelper.matchingValues(entryValue, ((FeatureMap.Entry)object).getValue())) continue;
            originKey = ((FeatureMap.Entry)object).getEStructuralFeature();
            break;
        }
        if (originKey == null) {
            throw new RuntimeException("FeatureMapChangeMerger: Cannot find the key to change.");
        }
        List targetList = (List)ReferenceUtil.safeEGet(expectedContainer, (EStructuralFeature)attribute);
        int index = 0;
        for (Object object : targetList) {
            Object targetValue;
            if (object instanceof FeatureMap.Entry && equalityHelper.matchingValues(entryValue, targetValue = ((FeatureMap.Entry)object).getValue())) {
                ((BasicFeatureMap)targetList).setUnique(index, (Object)FeatureMapUtil.createEntry((EStructuralFeature)originKey, (Object)targetValue));
                Resource targetResource = DiffUtil.isContainmentReference(originKey) && targetValue instanceof EObject && originValueId != null ? ((EObject)targetValue).eResource() : null;
                if (!(targetResource instanceof XMIResource)) break;
                ((XMIResource)targetResource).setID((EObject)targetValue, originValueId);
                break;
            }
            ++index;
        }
    }

    protected int findInsertionIndex(Comparison comparison, Diff diff, boolean rightToLeft) {
        return DiffUtil.findInsertionIndex(comparison, diff, rightToLeft);
    }
}

