/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer;

import org.eclipse.emf.common.ui.DiagnosticComposite;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ProblemIndicationComposite
extends Composite {
    private Diagnostic diagnostic;
    private Composite detailsComposite;
    private Text messageText;
    private Label imageLabel;
    private TextProvider textProvider = new TextProvider();
    private DiagnosticComposite diagnosticComposite;

    public ProblemIndicationComposite(Composite parent, int style) {
        super(parent, style);
        this.createControl(this);
    }

    protected void createControl(Composite parent) {
        int margins;
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        int spacing = 8;
        layout.marginBottom = margins = 8;
        layout.marginTop = margins;
        layout.marginLeft = margins;
        layout.marginRight = margins;
        layout.horizontalSpacing = spacing;
        layout.verticalSpacing = spacing;
        parent.setLayout((Layout)layout);
        this.imageLabel = new Label(parent, 0);
        this.messageText = new Text(parent, 524362);
        this.messageText.setLayoutData((Object)new GridData(770));
        this.messageText.setBackground(this.messageText.getDisplay().getSystemColor(22));
        this.detailsComposite = new Composite(parent, 0);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        this.detailsComposite.setLayoutData((Object)data);
        GridLayout layout2 = new GridLayout();
        int margin = -5;
        int spacing2 = 3;
        layout2.marginTop = margin;
        layout2.marginLeft = margin;
        layout2.marginRight = margin;
        layout2.marginBottom = margin;
        layout2.horizontalSpacing = spacing2;
        layout2.verticalSpacing = spacing2;
        this.detailsComposite.setLayout((Layout)layout2);
        this.updateDetails();
        this.refresh();
        this.layout(true);
    }

    protected void refresh() {
        if (this.diagnostic != null && this.messageText != null) {
            Image image = this.getImage();
            if (image != null) {
                image.setBackground(this.imageLabel.getBackground());
                this.imageLabel.setImage(image);
                this.imageLabel.setLayoutData((Object)new GridData(66));
            }
            this.messageText.setText(this.getMessage());
            if (this.diagnosticComposite != null && this.diagnosticComposite.getDiagnostic() != this.diagnostic) {
                this.diagnosticComposite.setDiagnostic(this.diagnostic);
            }
        }
    }

    protected void updateDetails() {
        if (this.diagnosticComposite == null) {
            this.diagnosticComposite = new DiagnosticComposite(this.detailsComposite, 0);
            this.diagnosticComposite.setSeverityMask(DiagnosticComposite.ERROR_WARNING_MASK);
            this.diagnosticComposite.setLayoutData((Object)new GridData(1808));
            this.diagnosticComposite.setTextProvider((DiagnosticComposite.TextProvider)this.textProvider);
            this.diagnosticComposite.initialize(this.getDiagnostic());
            this.detailsComposite.layout(true);
        } else {
            this.diagnosticComposite.setVisible(true);
        }
    }

    protected Image getImage() {
        Display display = Display.getCurrent();
        switch (this.diagnostic.getSeverity()) {
            case 4: {
                return display.getSystemImage(1);
            }
            case 2: 
            case 8: {
                return display.getSystemImage(8);
            }
        }
        return display.getSystemImage(2);
    }

    protected String getMessage() {
        return this.textProvider.getMessage(this.getDiagnostic());
    }

    public Diagnostic getDiagnostic() {
        return this.diagnostic;
    }

    public void setDiagnostic(Diagnostic diagnostic) {
        this.diagnostic = diagnostic;
        this.refresh();
    }

    public static class TextProvider
    extends DiagnosticComposite.TextProvider {
        public String getMessage(Diagnostic rootDiagnostic) {
            switch (rootDiagnostic.getSeverity()) {
                case 0: {
                    return EMFCompareIDEUIMessages.getString("_UI_NoProblems_message");
                }
                case 8: {
                    return EMFCompareIDEUIMessages.getString("_UI_Cancel_message");
                }
                case 2: {
                    return EMFCompareIDEUIMessages.getString("_UI_Warning_message");
                }
                case 4: {
                    return EMFCompareIDEUIMessages.getString("_UI_Error_message");
                }
            }
            return EMFCompareIDEUIMessages.getString("_UI_DefaultProblem_message");
        }
    }
}

