/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.tests.edit.provider;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.postprocessor.IPostProcessor;
import org.eclipse.emf.compare.tests.postprocess.data.TestPostProcessor;
import org.eclipse.emf.compare.uml2.internal.postprocessor.StereotypedElementChangePostProcessor;
import org.eclipse.emf.compare.uml2.internal.provider.decorator.UMLProfileItemProviderAdapterFactoryDecorator;
import org.eclipse.emf.compare.uml2.profile.test.uml2comparetestprofile.provider.UML2CompareTestProfileItemProviderAdapterFactory;
import org.eclipse.emf.compare.uml2.tests.AbstractStaticProfileTest;
import org.eclipse.emf.compare.uml2.tests.AbstractUMLInputData;
import org.eclipse.emf.compare.uml2.tests.edit.provider.StereotypedElementItemProviderTestUtil;
import org.eclipse.emf.compare.uml2.tests.edit.provider.data.ModelInputData;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class StaticStereotypedElementItemProviderTest
extends AbstractStaticProfileTest {
    private ModelInputData inputData = new ModelInputData();

    @BeforeClass
    public static void setupClass() {
        StaticStereotypedElementItemProviderTest.fillRegistriesForStatic();
    }

    @AfterClass
    public static void teardownClass() {
        StaticStereotypedElementItemProviderTest.resetRegistriesForStatic();
    }

    @Override
    protected AbstractUMLInputData getInput() {
        return this.inputData;
    }

    @Override
    protected void registerPostProcessors(IPostProcessor.Descriptor.Registry<String> postProcessorRegistry) {
        super.registerPostProcessors(postProcessorRegistry);
        postProcessorRegistry.put((Object)StereotypedElementChangePostProcessor.class.getName(), (IPostProcessor.Descriptor)new TestPostProcessor.TestPostProcessorDescriptor(Pattern.compile("http://www.eclipse.org/uml2/\\d\\.0\\.0/UML"), null, (IPostProcessor)new StereotypedElementChangePostProcessor(), 25));
    }

    @Override
    @Before
    public void before() {
        super.before();
    }

    @Test
    public void testIconsAndLabelsStaticProfile() throws IOException {
        ComposedAdapterFactory stereotypedElementItemProviderDecorator = new ComposedAdapterFactory((Collection)Lists.newArrayList((Object[])new AdapterFactory[]{new UMLProfileItemProviderAdapterFactoryDecorator(), new UML2CompareTestProfileItemProviderAdapterFactory()}));
        HashMap<String, String> expectedStaticIcons = new HashMap<String, String>();
        expectedStaticIcons.put("ACliche", "eclipse_luna.gif");
        expectedStaticIcons.put("ACliche,ACliche2", "eclipse_luna.gif");
        expectedStaticIcons.put("ACliche2,ACliche", "eclipse_kepler.gif");
        expectedStaticIcons.put("ACliche2", "eclipse_kepler.gif");
        expectedStaticIcons.put("ACliche3", "ACliche3.gif");
        Resource resource = this.inputData.getStaticProfileModel();
        StereotypedElementItemProviderTestUtil.checkIconAndLabel((AdapterFactory)stereotypedElementItemProviderDecorator, expectedStaticIcons, resource);
    }
}

