/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.customization;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.adapterfactory.context.IContextTester;
import org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.customization.ContentMergeViewerCustomizationDescriptor;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.item.provider.IMergeViewerItemContentProvider;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.item.provider.IMergeViewerItemProvider;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.item.provider.IOptionalProvider;

public class ContentMergeViewerCustomizationRegistry {
    private final Map<String, ContentMergeViewerCustomizationDescriptor<IMergeViewerItemProvider>> registeredDescriptors = new LinkedHashMap<String, ContentMergeViewerCustomizationDescriptor<IMergeViewerItemProvider>>();
    private final Map<String, ContentMergeViewerCustomizationDescriptor<IMergeViewerItemContentProvider>> registeredTreeDescriptors = new LinkedHashMap<String, ContentMergeViewerCustomizationDescriptor<IMergeViewerItemContentProvider>>();

    public void addCustomization(String className, ContentMergeViewerCustomizationDescriptor<IMergeViewerItemProvider> descriptor) {
        this.registeredDescriptors.put(className, descriptor);
    }

    public void addTreeCustomization(String className, ContentMergeViewerCustomizationDescriptor<IMergeViewerItemContentProvider> descriptor) {
        this.registeredTreeDescriptors.put(className, descriptor);
    }

    public void removeDescriptor(String className) {
        this.registeredDescriptors.remove(className);
        this.registeredTreeDescriptors.remove(className);
    }

    public void clear() {
        this.registeredDescriptors.clear();
        this.registeredTreeDescriptors.clear();
    }

    private <T extends IOptionalProvider> T getBestFittingProvider(Collection<ContentMergeViewerCustomizationDescriptor<T>> descriptors, Comparison comparison, Object object) {
        ContentMergeViewerCustomizationDescriptor<T> bestDescriptor = null;
        Map<Object, Object> context = this.createContext(comparison);
        for (ContentMergeViewerCustomizationDescriptor<T> descriptor : descriptors) {
            IContextTester contextTester = descriptor.getContextTester();
            if (contextTester != null && !contextTester.apply(context) || bestDescriptor != null && bestDescriptor.getRanking() > descriptor.getRanking() || !((IOptionalProvider)descriptor.getProvider()).canHandle(object)) continue;
            bestDescriptor = descriptor;
        }
        if (bestDescriptor != null) {
            return (T)((IOptionalProvider)bestDescriptor.getProvider());
        }
        return null;
    }

    private Map<Object, Object> createContext(Comparison comparison) {
        HashMap<Object, Object> context = new HashMap<Object, Object>();
        context.put("comparison", comparison);
        return context;
    }

    public IMergeViewerItemProvider getBestFittingMergeViewerItemProvider(Comparison comparison, Object object) {
        return (IMergeViewerItemProvider)this.getBestFittingProvider(this.registeredDescriptors.values(), comparison, object);
    }

    public IMergeViewerItemContentProvider getBestFittingMergeViewerItemContentProvider(Comparison comparison, Object object) {
        return (IMergeViewerItemContentProvider)this.getBestFittingProvider(this.registeredTreeDescriptors.values(), comparison, object);
    }
}

