/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.tests.implications;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.merge.BatchMerger;
import org.eclipse.emf.compare.uml2.internal.AssociationChange;
import org.eclipse.emf.compare.uml2.internal.MultiplicityElementChange;
import org.eclipse.emf.compare.uml2.tests.AbstractUMLInputData;
import org.eclipse.emf.compare.uml2.tests.AbstractUMLTest;
import org.eclipse.emf.compare.uml2.tests.implications.data.ImplicationsInputData;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ImplicationsAssociationTest
extends AbstractUMLTest {
    private static final int NB_DIFFS = 20;
    private ImplicationsInputData input = new ImplicationsInputData();

    @BeforeClass
    public static void setupClass() {
        ImplicationsAssociationTest.fillRegistries();
    }

    @AfterClass
    public static void teardownClass() {
        ImplicationsAssociationTest.resetRegistries();
    }

    private DiffsOfInterest getDiffs(Comparison comparison, AbstractUMLTest.TestKind kind) {
        EList differences = comparison.getDifferences();
        Predicate addAssociationDescription = null;
        Predicate addNavigableOwnedEndClass1InAssociationDescription = null;
        Predicate addNavigableOwnedEndClass2InAssociationDescription = null;
        Predicate addRefAssociationInPropertyClass1Description = null;
        Predicate addRefTypeInPropertyClass1Description = null;
        Predicate addRefAssociationInPropertyClass2Description = null;
        Predicate addRefTypeInPropertyClass2Description = null;
        Predicate<? super Diff> addLiteralIntegerInClass1Description = null;
        Predicate<? super Diff> addUnlimitedNaturalInClass1Description = null;
        Predicate<? super Diff> addLiteralIntegerInClass2Description = null;
        Predicate<? super Diff> addUnlimitedNaturalInClass2Description = null;
        Predicate addMemberEndClass1InAssociationDescription = null;
        Predicate addMemberEndClass2InAssociationDescription = null;
        Predicate addOwnedEndClass1Description = null;
        Predicate addOwnedEndClass2Description = null;
        if (kind.equals((Object)AbstractUMLTest.TestKind.DELETE)) {
            addAssociationDescription = EMFComparePredicates.removed((String)"myModel.class1sToClass2s");
            addNavigableOwnedEndClass1InAssociationDescription = EMFComparePredicates.removedFromReference((String)"myModel.class1sToClass2s", (String)"navigableOwnedEnd", (String)"myModel.class1sToClass2s.class1s");
            addNavigableOwnedEndClass2InAssociationDescription = EMFComparePredicates.removedFromReference((String)"myModel.class1sToClass2s", (String)"navigableOwnedEnd", (String)"myModel.class1sToClass2s.class2s");
            addRefAssociationInPropertyClass1Description = EMFComparePredicates.changedReference((String)"myModel.class1sToClass2s.class1s", (String)"association", (String)"myModel.class1sToClass2s", null);
            addRefTypeInPropertyClass1Description = EMFComparePredicates.changedReference((String)"myModel.class1sToClass2s.class1s", (String)"type", (String)"myModel.Class1", null);
            addRefAssociationInPropertyClass2Description = EMFComparePredicates.changedReference((String)"myModel.class1sToClass2s.class2s", (String)"association", (String)"myModel.class1sToClass2s", null);
            addRefTypeInPropertyClass2Description = EMFComparePredicates.changedReference((String)"myModel.class1sToClass2s.class2s", (String)"type", (String)"myModel.Class2", null);
            addLiteralIntegerInClass1Description = ImplicationsAssociationTest.removedLowerValueIn("myModel.class1sToClass2s.class1s");
            addUnlimitedNaturalInClass1Description = ImplicationsAssociationTest.removedUpperValueIn("myModel.class1sToClass2s.class1s");
            addLiteralIntegerInClass2Description = ImplicationsAssociationTest.removedLowerValueIn("myModel.class1sToClass2s.class2s");
            addUnlimitedNaturalInClass2Description = ImplicationsAssociationTest.removedUpperValueIn("myModel.class1sToClass2s.class2s");
            addMemberEndClass1InAssociationDescription = EMFComparePredicates.removedFromReference((String)"myModel.class1sToClass2s", (String)"memberEnd", (String)"myModel.class1sToClass2s.class1s");
            addMemberEndClass2InAssociationDescription = EMFComparePredicates.removedFromReference((String)"myModel.class1sToClass2s", (String)"memberEnd", (String)"myModel.class1sToClass2s.class2s");
            addOwnedEndClass1Description = EMFComparePredicates.removedFromReference((String)"myModel.class1sToClass2s", (String)"ownedEnd", (String)"myModel.class1sToClass2s.class1s");
            addOwnedEndClass2Description = EMFComparePredicates.removedFromReference((String)"myModel.class1sToClass2s", (String)"ownedEnd", (String)"myModel.class1sToClass2s.class2s");
        } else {
            addAssociationDescription = EMFComparePredicates.added((String)"myModel.class1sToClass2s");
            addNavigableOwnedEndClass1InAssociationDescription = EMFComparePredicates.addedToReference((String)"myModel.class1sToClass2s", (String)"navigableOwnedEnd", (String)"myModel.class1sToClass2s.class1s");
            addNavigableOwnedEndClass2InAssociationDescription = EMFComparePredicates.addedToReference((String)"myModel.class1sToClass2s", (String)"navigableOwnedEnd", (String)"myModel.class1sToClass2s.class2s");
            addRefAssociationInPropertyClass1Description = EMFComparePredicates.changedReference((String)"myModel.class1sToClass2s.class1s", (String)"association", null, (String)"myModel.class1sToClass2s");
            addRefTypeInPropertyClass1Description = EMFComparePredicates.changedReference((String)"myModel.class1sToClass2s.class1s", (String)"type", null, (String)"myModel.Class1");
            addRefAssociationInPropertyClass2Description = EMFComparePredicates.changedReference((String)"myModel.class1sToClass2s.class2s", (String)"association", null, (String)"myModel.class1sToClass2s");
            addRefTypeInPropertyClass2Description = EMFComparePredicates.changedReference((String)"myModel.class1sToClass2s.class2s", (String)"type", null, (String)"myModel.Class2");
            addLiteralIntegerInClass1Description = ImplicationsAssociationTest.addedLowerValueIn("myModel.class1sToClass2s.class1s");
            addUnlimitedNaturalInClass1Description = ImplicationsAssociationTest.addedUpperValueIn("myModel.class1sToClass2s.class1s");
            addLiteralIntegerInClass2Description = ImplicationsAssociationTest.addedLowerValueIn("myModel.class1sToClass2s.class2s");
            addUnlimitedNaturalInClass2Description = ImplicationsAssociationTest.addedUpperValueIn("myModel.class1sToClass2s.class2s");
            addMemberEndClass1InAssociationDescription = EMFComparePredicates.addedToReference((String)"myModel.class1sToClass2s", (String)"memberEnd", (String)"myModel.class1sToClass2s.class1s");
            addMemberEndClass2InAssociationDescription = EMFComparePredicates.addedToReference((String)"myModel.class1sToClass2s", (String)"memberEnd", (String)"myModel.class1sToClass2s.class2s");
            addOwnedEndClass1Description = EMFComparePredicates.addedToReference((String)"myModel.class1sToClass2s", (String)"ownedEnd", (String)"myModel.class1sToClass2s.class1s");
            addOwnedEndClass2Description = EMFComparePredicates.addedToReference((String)"myModel.class1sToClass2s", (String)"ownedEnd", (String)"myModel.class1sToClass2s.class2s");
        }
        DiffsOfInterest diffs = new DiffsOfInterest();
        diffs.addAssociation = (Diff)Iterators.find(differences.iterator(), (Predicate)addAssociationDescription, null);
        diffs.addNavigableOwnedEndClass1InAssociation = (Diff)Iterators.find(differences.iterator(), (Predicate)addNavigableOwnedEndClass1InAssociationDescription, null);
        diffs.addNavigableOwnedEndClass2InAssociation = (Diff)Iterators.find(differences.iterator(), (Predicate)addNavigableOwnedEndClass2InAssociationDescription, null);
        diffs.addMemberEndClass1InAssociation = (Diff)Iterators.find(differences.iterator(), (Predicate)addMemberEndClass1InAssociationDescription, null);
        diffs.addMemberEndClass2InAssociation = (Diff)Iterators.find(differences.iterator(), (Predicate)addMemberEndClass2InAssociationDescription, null);
        diffs.addOwnedEndClass1InAssociation = (Diff)Iterators.find(differences.iterator(), (Predicate)addOwnedEndClass1Description, null);
        diffs.addOwnedEndClass2InAssociation = (Diff)Iterators.find(differences.iterator(), (Predicate)addOwnedEndClass2Description, null);
        diffs.addUMLAssociation = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.instanceOf(AssociationChange.class), null);
        diffs.addRefAssociationInPropertyClass1 = (Diff)Iterators.find(differences.iterator(), (Predicate)addRefAssociationInPropertyClass1Description, null);
        diffs.addRefTypeInPropertyClass1 = (Diff)Iterators.find(differences.iterator(), (Predicate)addRefTypeInPropertyClass1Description, null);
        diffs.addRefAssociationInPropertyClass2 = (Diff)Iterators.find(differences.iterator(), (Predicate)addRefAssociationInPropertyClass2Description, null);
        diffs.addRefTypeInPropertyClass2 = (Diff)Iterators.find(differences.iterator(), (Predicate)addRefTypeInPropertyClass2Description, null);
        diffs.addLiteralIntegerInClass1 = (Diff)Iterators.find(differences.iterator(), addLiteralIntegerInClass1Description, null);
        diffs.addUnlimitedNaturalInClass1 = (Diff)Iterators.find(differences.iterator(), addUnlimitedNaturalInClass1Description, null);
        diffs.addLiteralIntegerInClass2 = (Diff)Iterators.find(differences.iterator(), addLiteralIntegerInClass2Description, null);
        diffs.addUnlimitedNaturalInClass2 = (Diff)Iterators.find(differences.iterator(), addUnlimitedNaturalInClass2Description, null);
        return diffs;
    }

    private void assertNoDifferences(Comparison comparison) {
        Assert.assertTrue((boolean)comparison.getDifferences().isEmpty());
    }

    @Test
    public void testA10UseCase() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        this.testAB1(AbstractUMLTest.TestKind.ADD, comparison);
    }

    @Test
    public void testA10UseCase3way1() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        this.testAB1(AbstractUMLTest.TestKind.ADD, comparison);
    }

    @Test
    public void testA10UseCase3way2() throws IOException {
        Resource left = this.input.getA1Right();
        Resource right = this.input.getA1Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        this.testAB1(AbstractUMLTest.TestKind.ADD, comparison);
    }

    @Test
    public void testA10MergeLtR1UseCase() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addNavigableOwnedEndClass1InAssociation), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        this.assertNoDifferences(comparison);
    }

    @Test
    public void testA10MergeLtR1UseCase3way1() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addNavigableOwnedEndClass1InAssociation), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        this.assertNoDifferences(comparison);
    }

    @Test
    public void testA10MergeLtR1UseCase3way2() throws IOException {
        Resource left = this.input.getA1Right();
        Resource right = this.input.getA1Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addNavigableOwnedEndClass1InAssociation), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        this.assertNoDifferences(comparison);
    }

    @Test
    public void testA10MergeLtR2UseCase() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addOwnedEndClass1InAssociation), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        this.assertNoDifferences(comparison);
    }

    @Test
    public void testA10MergeLtR2UseCase3way1() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addOwnedEndClass1InAssociation), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        this.assertNoDifferences(comparison);
    }

    @Test
    public void testA10MergeLtR2UseCase3way2() throws IOException {
        Resource left = this.input.getA1Right();
        Resource right = this.input.getA1Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addOwnedEndClass1InAssociation), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        this.assertNoDifferences(comparison);
    }

    @Test
    public void testA10MergeLtR3UseCase() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addMemberEndClass1InAssociation), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        this.assertNoDifferences(comparison);
    }

    @Test
    public void testA10MergeLtR3UseCase3way1() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addMemberEndClass1InAssociation), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        this.assertNoDifferences(comparison);
    }

    @Test
    public void testA10MergeLtR3UseCase3way2() throws IOException {
        Resource left = this.input.getA1Right();
        Resource right = this.input.getA1Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addMemberEndClass1InAssociation), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        this.assertNoDifferences(comparison);
    }

    @Test
    public void testA10MergeRtL1UseCase() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addNavigableOwnedEndClass1InAssociation), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        this.assertNoDifferences(comparison);
    }

    @Test
    public void testA10MergeRtL1UseCase3way1() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addNavigableOwnedEndClass1InAssociation), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        this.assertNoDifferences(comparison);
    }

    @Test
    public void testA10MergeRtL1UseCase3way2() throws IOException {
        Resource left = this.input.getA1Right();
        Resource right = this.input.getA1Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addNavigableOwnedEndClass1InAssociation), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        this.assertNoDifferences(comparison);
    }

    @Test
    public void testA10MergeRtL2UseCase() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addOwnedEndClass1InAssociation), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        this.assertNoDifferences(comparison);
    }

    @Test
    public void testA10MergeRtL2UseCase3way1() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addOwnedEndClass1InAssociation), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        this.assertNoDifferences(comparison);
    }

    @Test
    public void testA10MergeRtL2UseCase3way2() throws IOException {
        Resource left = this.input.getA1Right();
        Resource right = this.input.getA1Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addOwnedEndClass1InAssociation), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        this.assertNoDifferences(comparison);
    }

    @Test
    public void testA10MergeRtL3UseCase() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addMemberEndClass1InAssociation), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        this.assertNoDifferences(comparison);
    }

    @Test
    public void testA10MergeRtL3UseCase3way1() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addMemberEndClass1InAssociation), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        this.assertNoDifferences(comparison);
    }

    @Test
    public void testA10MergeRtL3UseCase3way2() throws IOException {
        Resource left = this.input.getA1Right();
        Resource right = this.input.getA1Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addMemberEndClass1InAssociation), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        this.assertNoDifferences(comparison);
    }

    @Test
    public void testA11UseCase() throws IOException {
        Resource left = this.input.getA1Right();
        Resource right = this.input.getA1Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        this.testAB1(AbstractUMLTest.TestKind.DELETE, comparison);
    }

    @Test
    public void testA11UseCase3way1() throws IOException {
        Resource left = this.input.getA1Right();
        Resource right = this.input.getA1Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        this.testAB1(AbstractUMLTest.TestKind.DELETE, comparison);
    }

    @Test
    public void testA11UseCase3way2() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        this.testAB1(AbstractUMLTest.TestKind.DELETE, comparison);
    }

    @Test
    public void testA11MergeLtR1UseCase() throws IOException {
        Resource left = this.input.getA1Right();
        Resource right = this.input.getA1Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addNavigableOwnedEndClass1InAssociation), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        this.assertNoDifferences(comparison);
    }

    @Test
    public void testA11MergeLtR1UseCase3way1() throws IOException {
        Resource left = this.input.getA1Right();
        Resource right = this.input.getA1Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addNavigableOwnedEndClass1InAssociation), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        this.assertNoDifferences(comparison);
    }

    @Test
    public void testA11MergeLtR1UseCase3way2() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addNavigableOwnedEndClass1InAssociation), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        this.assertNoDifferences(comparison);
    }

    @Test
    public void testA11MergeLtR2UseCase() throws IOException {
        Resource left = this.input.getA1Right();
        Resource right = this.input.getA1Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addOwnedEndClass1InAssociation), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        this.assertNoDifferences(comparison);
    }

    @Test
    public void testA11MergeLtR2UseCase3way1() throws IOException {
        Resource left = this.input.getA1Right();
        Resource right = this.input.getA1Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addOwnedEndClass1InAssociation), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        this.assertNoDifferences(comparison);
    }

    @Test
    public void testA11MergeLtR2UseCase3way2() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addOwnedEndClass1InAssociation), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        this.assertNoDifferences(comparison);
    }

    @Test
    public void testA11MergeLtR3UseCase() throws IOException {
        Resource left = this.input.getA1Right();
        Resource right = this.input.getA1Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addMemberEndClass1InAssociation), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        this.assertNoDifferences(comparison);
    }

    @Test
    public void testA11MergeLtR3UseCase3way1() throws IOException {
        Resource left = this.input.getA1Right();
        Resource right = this.input.getA1Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addMemberEndClass1InAssociation), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        this.assertNoDifferences(comparison);
    }

    @Test
    public void testA11MergeLtR3UseCase3way2() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addMemberEndClass1InAssociation), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        this.assertNoDifferences(comparison);
    }

    @Test
    public void testA11MergeRtL1UseCase() throws IOException {
        Resource left = this.input.getA1Right();
        Resource right = this.input.getA1Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addNavigableOwnedEndClass1InAssociation), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        this.assertNoDifferences(comparison);
    }

    @Test
    public void testA11MergeRtL1UseCase3way1() throws IOException {
        Resource left = this.input.getA1Right();
        Resource right = this.input.getA1Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addNavigableOwnedEndClass1InAssociation), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        this.assertNoDifferences(comparison);
    }

    @Test
    public void testA11MergeRtL1UseCase3way2() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addNavigableOwnedEndClass1InAssociation), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        this.assertNoDifferences(comparison);
    }

    @Test
    public void testA11MergeRtL2UseCase() throws IOException {
        Resource left = this.input.getA1Right();
        Resource right = this.input.getA1Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addOwnedEndClass1InAssociation), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        this.assertNoDifferences(comparison);
    }

    @Test
    public void testA11MergeRtL2UseCase3way1() throws IOException {
        Resource left = this.input.getA1Right();
        Resource right = this.input.getA1Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addOwnedEndClass1InAssociation), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        this.assertNoDifferences(comparison);
    }

    @Test
    public void testA11MergeRtL2UseCase3way2() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addOwnedEndClass1InAssociation), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        this.assertNoDifferences(comparison);
    }

    @Test
    public void testA11MergeRtL3UseCase() throws IOException {
        Resource left = this.input.getA1Right();
        Resource right = this.input.getA1Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addMemberEndClass1InAssociation), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        this.assertNoDifferences(comparison);
    }

    @Test
    public void testA11MergeRtL3UseCase3way1() throws IOException {
        Resource left = this.input.getA1Right();
        Resource right = this.input.getA1Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addMemberEndClass1InAssociation), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        this.assertNoDifferences(comparison);
    }

    @Test
    public void testA11MergeRtL3UseCase3way2() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        BatchMerger bm = new BatchMerger(this.getMergerRegistry());
        bm.copyAllLeftToRight(Arrays.asList(diffs.addMemberEndClass1InAssociation), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        this.assertNoDifferences(comparison);
    }

    private void testAB1(AbstractUMLTest.TestKind kind, Comparison comparison) {
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)20L, (long)differences.size());
        DiffsOfInterest diffs = this.getDiffs(comparison, kind);
        if (kind.equals((Object)AbstractUMLTest.TestKind.DELETE)) {
            Assert.assertEquals((long)0L, (long)diffs.addNavigableOwnedEndClass1InAssociation.getImplies().size());
            Assert.assertEquals((long)1L, (long)diffs.addNavigableOwnedEndClass1InAssociation.getImpliedBy().size());
            Assert.assertTrue((boolean)diffs.addNavigableOwnedEndClass1InAssociation.getImpliedBy().contains((Object)diffs.addOwnedEndClass1InAssociation));
            Assert.assertEquals((long)1L, (long)diffs.addOwnedEndClass1InAssociation.getImplies().size());
            Assert.assertTrue((boolean)diffs.addOwnedEndClass1InAssociation.getImplies().contains((Object)diffs.addNavigableOwnedEndClass1InAssociation));
            Assert.assertEquals((long)2L, (long)diffs.addOwnedEndClass1InAssociation.getImpliedBy().size());
            Assert.assertTrue((boolean)diffs.addOwnedEndClass1InAssociation.getImpliedBy().contains((Object)diffs.addMemberEndClass1InAssociation));
            Assert.assertTrue((boolean)diffs.addOwnedEndClass1InAssociation.getImpliedBy().contains((Object)diffs.addRefAssociationInPropertyClass1));
            Assert.assertEquals((long)1L, (long)diffs.addMemberEndClass1InAssociation.getImplies().size());
            Assert.assertTrue((boolean)diffs.addMemberEndClass1InAssociation.getImplies().contains((Object)diffs.addOwnedEndClass1InAssociation));
            Assert.assertEquals((long)0L, (long)diffs.addMemberEndClass1InAssociation.getImpliedBy().size());
        } else {
            Assert.assertEquals((long)1L, (long)diffs.addNavigableOwnedEndClass1InAssociation.getImplies().size());
            Assert.assertTrue((boolean)diffs.addNavigableOwnedEndClass1InAssociation.getImplies().contains((Object)diffs.addOwnedEndClass1InAssociation));
            Assert.assertEquals((long)0L, (long)diffs.addNavigableOwnedEndClass1InAssociation.getImpliedBy().size());
            Assert.assertEquals((long)2L, (long)diffs.addOwnedEndClass1InAssociation.getImplies().size());
            Assert.assertTrue((boolean)diffs.addOwnedEndClass1InAssociation.getImplies().contains((Object)diffs.addMemberEndClass1InAssociation));
            Assert.assertTrue((boolean)diffs.addOwnedEndClass1InAssociation.getImplies().contains((Object)diffs.addRefAssociationInPropertyClass1));
            Assert.assertEquals((long)1L, (long)diffs.addOwnedEndClass1InAssociation.getImpliedBy().size());
            Assert.assertTrue((boolean)diffs.addOwnedEndClass1InAssociation.getImpliedBy().contains((Object)diffs.addNavigableOwnedEndClass1InAssociation));
            Assert.assertEquals((long)0L, (long)diffs.addMemberEndClass1InAssociation.getImplies().size());
            Assert.assertEquals((long)1L, (long)diffs.addMemberEndClass1InAssociation.getImpliedBy().size());
            Assert.assertTrue((boolean)diffs.addMemberEndClass1InAssociation.getImpliedBy().contains((Object)diffs.addOwnedEndClass1InAssociation));
        }
    }

    @Override
    protected AbstractUMLInputData getInput() {
        return this.input;
    }

    private static Predicate<? super Diff> addedLowerValueIn(String qualifiedName) {
        return Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.onEObject((String)qualifiedName), EMFComparePredicates.onFeature((String)"lowerValue"), ImplicationsAssociationTest.refinesMultiplicityElementChange()});
    }

    private static Predicate<? super Diff> addedUpperValueIn(String qualifiedName) {
        return Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.onEObject((String)qualifiedName), EMFComparePredicates.onFeature((String)"upperValue"), ImplicationsAssociationTest.refinesMultiplicityElementChange()});
    }

    private static Predicate<? super Diff> removedLowerValueIn(String qualifiedName) {
        return Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), EMFComparePredicates.onEObject((String)qualifiedName), EMFComparePredicates.onFeature((String)"lowerValue"), ImplicationsAssociationTest.refinesMultiplicityElementChange()});
    }

    private static Predicate<? super Diff> removedUpperValueIn(String qualifiedName) {
        return Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), EMFComparePredicates.onEObject((String)qualifiedName), EMFComparePredicates.onFeature((String)"upperValue"), ImplicationsAssociationTest.refinesMultiplicityElementChange()});
    }

    private static Predicate<? super Diff> refinesMultiplicityElementChange() {
        return new Predicate<Diff>(){

            public boolean apply(Diff input) {
                return Iterators.any((Iterator)input.getRefines().iterator(), (Predicate)Predicates.instanceOf(MultiplicityElementChange.class));
            }
        };
    }

    private class DiffsOfInterest {
        public Diff addAssociation;
        public Diff addNavigableOwnedEndClass1InAssociation;
        public Diff addNavigableOwnedEndClass2InAssociation;
        public Diff addMemberEndClass1InAssociation;
        public Diff addMemberEndClass2InAssociation;
        public Diff addOwnedEndClass1InAssociation;
        public Diff addOwnedEndClass2InAssociation;
        public Diff addRefAssociationInPropertyClass1;
        public Diff addRefTypeInPropertyClass1;
        public Diff addRefAssociationInPropertyClass2;
        public Diff addRefTypeInPropertyClass2;
        public Diff addLiteralIntegerInClass1;
        public Diff addUnlimitedNaturalInClass1;
        public Diff addLiteralIntegerInClass2;
        public Diff addUnlimitedNaturalInClass2;
        public Diff addUMLAssociation;

        private DiffsOfInterest() {
        }
    }
}

