/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.internal.factories.extensions;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.Collection;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.diagram.internal.extensions.DiagramDiff;
import org.eclipse.emf.compare.diagram.internal.extensions.ExtensionsFactory;
import org.eclipse.emf.compare.diagram.internal.extensions.SizeChange;
import org.eclipse.emf.compare.diagram.internal.factories.extensions.NodeChangeFactory;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.gmf.runtime.notation.NotationPackage;

public class SizeChangeFactory
extends NodeChangeFactory {
    @Override
    public Class<? extends Diff> getExtensionKind() {
        return SizeChange.class;
    }

    @Override
    public DiagramDiff createExtension() {
        return ExtensionsFactory.eINSTANCE.createSizeChange();
    }

    @Override
    public void setRefiningChanges(Diff extension, DifferenceKind extensionKind, Diff refiningDiff) {
        if (extensionKind == DifferenceKind.CHANGE) {
            extension.getRefinedBy().addAll(Collections2.filter(this.getAllDifferencesForChange(refiningDiff), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)extension.getSource())));
        }
    }

    @Override
    protected Collection<Diff> getAllDifferencesForChange(final Diff input) {
        Collection<Diff> diffs = super.getAllDifferencesForChange(input);
        return Collections2.filter(diffs, (Predicate)new Predicate<Diff>(){

            public boolean apply(Diff diff) {
                return diff instanceof AttributeChange && SizeChangeFactory.isSizeChange((AttributeChange)diff) && EMFComparePredicates.fromSide((DifferenceSource)input.getSource()).apply((Object)diff);
            }
        });
    }

    protected boolean isRelatedToAnExtensionChange(AttributeChange input) {
        return SizeChangeFactory.isSizeChange(input) && Collections2.filter((Collection)input.getRefines(), this.isExtensionKind(DifferenceKind.CHANGE)).isEmpty();
    }

    private static boolean isSizeChange(AttributeChange input) {
        return input.getAttribute() == NotationPackage.Literals.SIZE__HEIGHT || input.getAttribute() == NotationPackage.Literals.SIZE__WIDTH;
    }
}

