/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.git.framework.internal.statements;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.compare.ide.ui.tests.framework.EMFCompareTestConfiguration;
import org.eclipse.emf.compare.ide.ui.tests.framework.ResolutionStrategyID;
import org.eclipse.emf.compare.ide.ui.tests.git.framework.GitMergeStrategyID;
import org.eclipse.emf.compare.ide.ui.tests.git.framework.GitTestSupport;
import org.eclipse.emf.compare.ide.ui.tests.git.framework.internal.statements.AbstractGitStatement;
import org.eclipse.emf.compare.ide.ui.tests.git.framework.internal.statements.InternalGitTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.model.FrameworkMethod;

public abstract class AbstractGitOperationStatement
extends AbstractGitStatement {
    protected final String path;
    private final GitMergeStrategyID mergeStrategy;
    private final IEclipsePreferences eGitPreferences;
    private String defaultMergeStrategy = GitMergeStrategyID.MODEL_RECURSIVE.getValue();

    public AbstractGitOperationStatement(Object testObject, FrameworkMethod test, ResolutionStrategyID resolutionStrategy, EMFCompareTestConfiguration configuration, GitMergeStrategyID mergeStrategy, String path) {
        super(testObject, test, resolutionStrategy, configuration);
        this.mergeStrategy = mergeStrategy;
        this.eGitPreferences = InstanceScope.INSTANCE.getNode("org.eclipse.egit.core");
        this.path = this.normalizePath(path);
    }

    public void evaluate() throws Throwable {
        this.setEMFComparePreferences();
        String from = InternalGitTestSupport.normalizeBranch(this.getCheckoutedBranch());
        String to = InternalGitTestSupport.normalizeBranch(this.getOtherBranch());
        Class<? extends Throwable> expected = this.getExpectedException();
        GitTestSupport gitTestsSupport = new GitTestSupport();
        try {
            try {
                gitTestsSupport.setup();
                gitTestsSupport.createRepositoryFromPath(this.test.getMethod().getDeclaringClass(), this.path);
                this.callGitOperation(gitTestsSupport, from, to);
                Object[] parameters = this.createParameters(this.test.getMethod(), gitTestsSupport);
                this.test.invokeExplosively(this.testObject, parameters);
                if (expected != Test.None.class) {
                    Assert.fail((String)("Expected exception : " + expected.getName()));
                }
            }
            catch (Throwable e) {
                if (!expected.isAssignableFrom(e.getClass())) {
                    throw e;
                }
                this.restoreEMFComparePreferences();
                gitTestsSupport.tearDown();
            }
        }
        finally {
            this.restoreEMFComparePreferences();
            gitTestsSupport.tearDown();
        }
    }

    protected abstract String getCheckoutedBranch();

    protected abstract String getOtherBranch();

    protected Class<? extends Throwable> getExpectedException() {
        return Test.None.class;
    }

    protected abstract void callGitOperation(GitTestSupport var1, String var2, String var3) throws Exception;

    protected void setEMFComparePreferences() {
        super.setEMFComparePreferences();
        this.setMergeStrategyPreference();
    }

    protected void restoreEMFComparePreferences() {
        super.restoreEMFComparePreferences();
        this.eGitPreferences.put("core_preferredMergeStrategy", this.defaultMergeStrategy);
    }

    private void setMergeStrategyPreference() {
        this.defaultMergeStrategy = this.eGitPreferences.get("core_preferredMergeStrategy", this.defaultMergeStrategy);
        this.eGitPreferences.put("core_preferredMergeStrategy", this.mergeStrategy.getValue());
    }
}

