/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.ide.ui.internal.contentmergeviewer.diagram;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.diagram.ide.ui.internal.contentmergeviewer.diagram.AbstractDecoratorManager;
import org.eclipse.emf.compare.diagram.ide.ui.internal.contentmergeviewer.diagram.DiagramMergeViewer;
import org.eclipse.emf.compare.diagram.ide.ui.internal.contentmergeviewer.diagram.figures.DecoratorFigure;
import org.eclipse.emf.compare.diagram.ide.ui.internal.contentmergeviewer.diagram.figures.EdgeFigure;
import org.eclipse.emf.compare.diagram.ide.ui.internal.contentmergeviewer.diagram.figures.NodeFigure;
import org.eclipse.emf.compare.diagram.ide.ui.internal.contentmergeviewer.diagram.figures.NodeListFigure;
import org.eclipse.emf.compare.diagram.internal.extensions.CoordinatesChange;
import org.eclipse.emf.compare.diagram.internal.extensions.DiagramDiff;
import org.eclipse.emf.compare.diagram.internal.extensions.Hide;
import org.eclipse.emf.compare.diagram.internal.extensions.Show;
import org.eclipse.emf.compare.ide.ui.internal.configuration.EMFCompareConfiguration;
import org.eclipse.emf.compare.internal.utils.DiffUtil;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.ICompareColor;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;

public class PhantomManager
extends AbstractDecoratorManager {
    private final Map<Diff, Phantom> fPhantomRegistry = new HashMap<Diff, Phantom>();
    private Predicate<Diff> isAddOrDelete = Predicates.and((Predicate)Predicates.instanceOf(DiagramDiff.class), (Predicate)Predicates.or((Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE)));
    private Predicate<Diff> isHideOrReveal = Predicates.or((Predicate)Predicates.instanceOf(Show.class), (Predicate)Predicates.instanceOf(Hide.class));

    public PhantomManager(EMFCompareConfiguration compareConfiguration, DiagramMergeViewer left, DiagramMergeViewer right, DiagramMergeViewer ancestor, ICompareColor color) {
        super(compareConfiguration, left, right, ancestor, color);
    }

    @Override
    protected Predicate<Diff> goodCandidate() {
        return new Predicate<Diff>(){

            public boolean apply(Diff difference) {
                return Predicates.or((Predicate)PhantomManager.this.isAddOrDelete, (Predicate)PhantomManager.this.isHideOrReveal).apply((Object)difference) && difference.getState() == DifferenceState.UNRESOLVED;
            }
        };
    }

    private List<Phantom> getOrCreateRelatedPhantoms(EObject referenceView, IMergeViewer.MergeViewerSide side) {
        ArrayList<Phantom> result = new ArrayList<Phantom>();
        Collection changes = Collections2.filter((Collection)this.getCompareConfiguration().getComparison().getDifferences(referenceView), this.goodCandidate());
        for (Diff change : changes) {
            IFigure referenceFigure;
            Phantom phantom = this.fPhantomRegistry.get(change);
            if (phantom == null && (referenceFigure = this.getFigure((View)referenceView)) != null) {
                phantom = this.createAndRegisterDecorator(change, (View)referenceView, referenceFigure, side);
            }
            if (phantom == null) continue;
            result.add(phantom);
        }
        return result;
    }

    @Override
    protected List<View> getReferenceViews(DiagramDiff difference) {
        View referenceView;
        ArrayList<View> result = new ArrayList<View>();
        Match match = this.getCompareConfiguration().getComparison().getMatch(difference.getView());
        EObject originObj = match.getOrigin();
        EObject leftObj = match.getLeft();
        EObject rightObj = match.getRight();
        if ((leftObj instanceof View || rightObj instanceof View) && (referenceView = this.getReferenceView((View)originObj, (View)leftObj, (View)rightObj)) != null) {
            result.add(referenceView);
        }
        return result;
    }

    @Override
    public IMergeViewer.MergeViewerSide getTargetSide(Match match, View referenceView) {
        IMergeViewer.MergeViewerSide targetSide = null;
        EObject leftMatch = match.getLeft();
        targetSide = leftMatch == null || leftMatch instanceof View && !this.isFigureExist((View)leftMatch) ? IMergeViewer.MergeViewerSide.LEFT : IMergeViewer.MergeViewerSide.RIGHT;
        return this.getEffectiveSide(targetSide);
    }

    @Override
    protected Phantom createAndRegisterDecorator(Diff diff, View referenceView, IFigure referenceFigure, IMergeViewer.MergeViewerSide targetSide) {
        Phantom phantom = this.createPhantom(diff, referenceView, referenceFigure, targetSide);
        if (phantom != null) {
            this.fPhantomRegistry.put(diff, phantom);
        }
        return phantom;
    }

    @Override
    public void removeDecorators(Diff difference) {
        this.fPhantomRegistry.remove(difference);
    }

    @Override
    public void removeAll() {
        this.fPhantomRegistry.clear();
    }

    protected List<Phantom> getDecorators(Diff difference) {
        ArrayList<Phantom> result = new ArrayList<Phantom>();
        Phantom phantom = this.fPhantomRegistry.get(difference);
        if (phantom != null) {
            result.add(phantom);
        }
        return result;
    }

    @Override
    protected void handleDecorator(AbstractDecoratorManager.AbstractDecorator decorator, boolean isAdd, boolean isMain) {
        super.handleDecorator(decorator, isAdd, isMain);
        for (AbstractDecoratorManager.AbstractDecorator abstractDecorator : ((Phantom)decorator).getDependencies()) {
            super.handleDecorator(abstractDecorator, isAdd, false);
        }
    }

    @Override
    protected void handleAddDecorator(AbstractDecoratorManager.AbstractDecorator decorator, IFigure parent, IFigure toAdd, boolean isMain) {
        super.handleAddDecorator(decorator, parent, toAdd, isMain);
        if (isMain) {
            decorator.getDecoratorFigure().highlight();
            this.getViewer(decorator.getSide()).getGraphicalViewer().reveal(toAdd);
        } else {
            decorator.getDecoratorFigure().unhighlight();
        }
    }

    private boolean isFigureExist(View view) {
        return view != null && view.isVisible();
    }

    private View getReferenceView(View originObj, View leftView, View rightView) {
        View referenceView = this.isFigureExist(originObj) ? originObj : (this.isFigureExist(leftView) ? leftView : rightView);
        return referenceView;
    }

    private Phantom createPhantom(Diff diff, View referenceView, IFigure referenceFigure, IMergeViewer.MergeViewerSide side) {
        IFigure targetLayer = this.getLayer(referenceView, side);
        if (targetLayer != null) {
            IMergeViewer.MergeViewerSide referenceSide = this.getSide(referenceView);
            Rectangle rect = referenceFigure.getBounds().getCopy();
            IFigure referenceLayer = this.getLayer(referenceView, referenceSide);
            this.translateCoordinates(referenceFigure, referenceLayer, rect);
            DecoratorFigure ghost = null;
            Phantom phantom = new Phantom(targetLayer, side, referenceView, referenceFigure, diff);
            if (this.isNodeList(referenceView)) {
                int nbElements;
                int index = this.getIndex(diff, referenceView, side);
                IFigure referenceParentFigure = referenceFigure.getParent();
                Rectangle referenceParentBounds = referenceParentFigure.getBounds().getCopy();
                this.translateCoordinates(referenceParentFigure, referenceLayer, referenceParentBounds);
                View parentView = (View)this.getMatchView(referenceView.eContainer(), side);
                if (parentView != null && index > (nbElements = this.getVisibleViews(parentView).size())) {
                    index = nbElements;
                }
                int pos = rect.height * index + referenceParentBounds.y + 1;
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("yPos", pos);
                ghost = new NodeListFigure(diff, this.isThreeWay(), this.getCompareColor(), referenceFigure, rect, true, parameters);
            } else if (referenceView instanceof Edge) {
                if (this.hasAnExtremityChange((Edge)referenceView, side)) {
                    EditPart edgeEditPart = this.createEdgeEditPart((Edge)referenceView, referenceSide, side);
                    if (edgeEditPart instanceof GraphicalEditPart) {
                        phantom.setEditPart(edgeEditPart);
                        IFigure fig = ((GraphicalEditPart)edgeEditPart).getFigure();
                        fig.getChildren().clear();
                        ghost = new DecoratorFigure(diff, this.isThreeWay(), this.getCompareColor(), referenceFigure, fig, true);
                    }
                } else if (referenceFigure instanceof PolylineConnection) {
                    ghost = new EdgeFigure(diff, this.isThreeWay(), this.getCompareColor(), referenceFigure, rect, true);
                }
            }
            if (ghost == null) {
                ghost = new NodeFigure(diff, this.isThreeWay(), this.getCompareColor(), referenceFigure, rect, true);
            }
            phantom.setDecoratorFigure(ghost);
            this.translateWhenInsideContainerChange(phantom);
            return phantom;
        }
        return null;
    }

    private int getIndex(Diff diff, View referenceView, IMergeViewer.MergeViewerSide side) {
        if (diff instanceof Hide || diff instanceof Show) {
            List source = null;
            List target = null;
            EObject newElement = null;
            Match match = diff.getMatch();
            List leftList = ReferenceUtil.getAsList((EObject)match.getLeft().eContainer(), (EStructuralFeature)NotationPackage.Literals.VIEW__PERSISTED_CHILDREN);
            List rightList = ReferenceUtil.getAsList((EObject)match.getRight().eContainer(), (EStructuralFeature)NotationPackage.Literals.VIEW__PERSISTED_CHILDREN);
            if (diff instanceof Hide) {
                source = rightList;
                target = leftList;
                newElement = diff.getMatch().getRight();
            } else {
                source = leftList;
                target = rightList;
                newElement = diff.getMatch().getLeft();
            }
            Iterable ignoredElements = Iterables.filter((Iterable)target, (Predicate)new Predicate(){

                public boolean apply(Object input) {
                    return input instanceof View && !((View)input).isVisible();
                }
            });
            return DiffUtil.findInsertionIndex((Comparison)this.getCompareConfiguration().getComparison(), (Iterable)ignoredElements, (List)source, (List)target, (Object)newElement);
        }
        Diff refiningDiff = (Diff)Iterators.find((Iterator)diff.getRefinedBy().iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.valueIs((Object)referenceView), (Predicate)EMFComparePredicates.onFeature((String)NotationPackage.Literals.VIEW__PERSISTED_CHILDREN.getName())));
        return DiffUtil.findInsertionIndex((Comparison)this.getCompareConfiguration().getComparison(), (Diff)refiningDiff, (side == IMergeViewer.MergeViewerSide.LEFT ? 1 : 0) != 0);
    }

    private List<View> getVisibleViews(View parent) {
        return Lists.newArrayList((Iterator)Iterators.filter((Iterator)parent.getChildren().iterator(), (Predicate)new Predicate<Object>(){

            public boolean apply(Object input) {
                return input instanceof View && ((View)input).isVisible();
            }
        }));
    }

    private void translateWhenInsideContainerChange(Phantom phantom) {
        View parentView;
        IFigure parentFigure;
        View referenceView;
        View parentReferenceView;
        boolean isCandidate = false;
        Diff diff = phantom.getDifference();
        if (diff instanceof DiagramDiff) {
            EObject parent = ((DiagramDiff)diff).getView().eContainer();
            while (parent instanceof View && !isCandidate) {
                isCandidate = Iterables.any((Iterable)this.getCompareConfiguration().getComparison().getDifferences(parent), (Predicate)Predicates.instanceOf(CoordinatesChange.class));
                parent = parent.eContainer();
            }
        }
        if (isCandidate && (parentReferenceView = (View)(referenceView = phantom.getOriginView()).eContainer()) != null && (parentFigure = this.getFigure(parentView = (View)this.getMatchView((EObject)parentReferenceView, phantom.getSide()))) != null) {
            Rectangle parentRect = parentFigure.getBounds().getCopy();
            this.translateCoordinates(parentFigure, this.getLayer(parentReferenceView, this.getSide(parentView)), parentRect);
            IFigure parentReferenceFigure = this.getFigure(parentReferenceView);
            if (parentReferenceFigure != null) {
                Rectangle parentReferenceRect = parentReferenceFigure.getBounds().getCopy();
                this.translateCoordinates(parentReferenceFigure, this.getLayer(parentReferenceView, this.getSide(parentReferenceView)), parentReferenceRect);
                int deltaX = parentRect.x - parentReferenceRect.x;
                int deltaY = parentRect.y - parentReferenceRect.y;
                int deltaWidth = parentRect.width - parentReferenceRect.width;
                int deltaHeight = parentRect.height - parentReferenceRect.height;
                IFigure figure = phantom.getFigure();
                Rectangle rect = figure.getBounds().getCopy();
                rect.x += deltaX;
                rect.y += deltaY;
                rect.width += deltaWidth;
                if (!(figure instanceof Polyline)) {
                    rect.height += deltaHeight;
                }
                figure.setBounds(rect);
                if (figure instanceof Polyline) {
                    Point firstPoint = ((Polyline)figure).getPoints().getFirstPoint().getCopy();
                    Point lastPoint = ((Polyline)figure).getPoints().getLastPoint().getCopy();
                    firstPoint.x += deltaX;
                    firstPoint.y += deltaY;
                    lastPoint.x += deltaX + deltaWidth;
                    lastPoint.y += deltaY;
                    ((Polyline)figure).setEndpoints(firstPoint, lastPoint);
                }
            }
        }
    }

    private boolean hasAnExtremityChange(Edge edge, IMergeViewer.MergeViewerSide targetSide) {
        View referenceSource = edge.getSource();
        View referenceTarget = edge.getTarget();
        return this.hasChange(referenceSource, targetSide) || this.hasChange(referenceTarget, targetSide);
    }

    private boolean hasChange(View referenceView, IMergeViewer.MergeViewerSide targetSide) {
        View extremity = (View)this.getMatchView((EObject)referenceView, targetSide);
        Collection diffs = Collections2.filter((Collection)this.getCompareConfiguration().getComparison().getDifferences((EObject)referenceView), (Predicate)Predicates.instanceOf(CoordinatesChange.class));
        if (diffs.isEmpty()) {
            diffs = Collections2.filter((Collection)this.getCompareConfiguration().getComparison().getDifferences((EObject)extremity), (Predicate)Predicates.instanceOf(CoordinatesChange.class));
        }
        return !diffs.isEmpty();
    }

    private EditPart createEdgeEditPart(Edge referenceEdge, IMergeViewer.MergeViewerSide referenceSide, IMergeViewer.MergeViewerSide targetSide) {
        EditPart edgeEditPartReference = this.getViewer(referenceSide).getEditPart((EObject)referenceEdge);
        EditPart edgeEditPart = null;
        if (edgeEditPartReference instanceof ConnectionEditPart && (edgeEditPart = this.getOrCreatePhantomEditPart((EObject)referenceEdge, referenceSide, targetSide)) instanceof ConnectionEditPart) {
            EditPart edgeSourceEp = this.getOrCreateExtremityPhantomEditPart(((ConnectionEditPart)edgeEditPartReference).getSource(), referenceSide, targetSide);
            ((ConnectionEditPart)edgeEditPart).setSource(edgeSourceEp);
            EditPart edgeTargetEp = this.getOrCreateExtremityPhantomEditPart(((ConnectionEditPart)edgeEditPartReference).getTarget(), referenceSide, targetSide);
            ((ConnectionEditPart)edgeEditPart).setTarget(edgeTargetEp);
        }
        return edgeEditPart;
    }

    private EditPart getOrCreateExtremityPhantomEditPart(EditPart referenceEdgeExtremityEp, IMergeViewer.MergeViewerSide referenceSide, IMergeViewer.MergeViewerSide targetSide) {
        View referenceExtremityView = (View)referenceEdgeExtremityEp.getModel();
        Object edgeExtremityEp = this.getOrCreatePhantomEditPart((EObject)referenceExtremityView, referenceSide, targetSide);
        if (this.isPhantomEditPart((AbstractGraphicalEditPart)edgeExtremityEp)) {
            final AbstractGraphicalEditPart edgeExtremityEpParent = (AbstractGraphicalEditPart)edgeExtremityEp.getParent();
            List<Phantom> phantoms = this.getOrCreateRelatedPhantoms((EObject)referenceExtremityView, targetSide);
            if (!phantoms.isEmpty()) {
                Phantom phantomToTarget = phantoms.get(0);
                final IFigure figureToTarget = phantomToTarget.getFigure();
                edgeExtremityEp = new org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart((EObject)referenceExtremityView){

                    protected void createDefaultEditPolicies() {
                    }

                    protected IFigure createFigure() {
                        RectangleFigure fig = new RectangleFigure();
                        fig.setBounds(figureToTarget.getBounds());
                        fig.setParent(edgeExtremityEpParent.getFigure());
                        return fig;
                    }
                };
                edgeExtremityEp.setParent((EditPart)edgeExtremityEpParent);
            }
            ((AbstractGraphicalEditPart)edgeExtremityEp).activate();
            ((AbstractGraphicalEditPart)edgeExtremityEp).getFigure();
        }
        return edgeExtremityEp;
    }

    private boolean isPhantomEditPart(AbstractGraphicalEditPart editPart) {
        Rectangle targetBounds = editPart.getFigure().getBounds();
        return targetBounds.x == 0 && targetBounds.y == 0 && targetBounds.width == 0 && targetBounds.height == 0;
    }

    private EditPart getOrCreatePhantomEditPart(EObject referenceView, IMergeViewer.MergeViewerSide referenceSide, IMergeViewer.MergeViewerSide targetSide) {
        View viewParent;
        EditPart editPartParent = null;
        EditPart editPart = null;
        EditPart editPartReference = this.getViewer(referenceSide).getEditPart(referenceView);
        EditPart editPartReferenceParent = editPartReference.getParent();
        Object referenceViewParent = editPartReferenceParent.getModel();
        if (!(referenceViewParent instanceof EObject)) {
            referenceViewParent = referenceView.eContainer();
        }
        if ((viewParent = (View)this.getMatchView((EObject)referenceViewParent, targetSide)) != null) {
            editPartParent = this.getViewer(targetSide).getEditPart((EObject)viewParent);
        }
        if (editPartParent == null) {
            editPartParent = this.getOrCreatePhantomEditPart((EObject)referenceViewParent, referenceSide, targetSide);
        }
        if (editPartParent != null) {
            View view = (View)this.getMatchView(referenceView, targetSide);
            if (view != null) {
                editPart = this.getViewer(targetSide).getEditPart((EObject)view);
            }
            if (editPart == null) {
                editPart = this.getViewer(targetSide).getGraphicalViewer().getEditPartFactory().createEditPart(editPartParent, (Object)referenceView);
                editPart.setParent(editPartParent);
                this.getViewer(targetSide).getGraphicalViewer().getEditPartRegistry().put(referenceView, editPart);
            }
        }
        return editPart;
    }

    @Override
    public void hideAll() {
        for (Phantom phantom : this.fPhantomRegistry.values()) {
            this.handleDeleteDecorator(phantom, phantom.getLayer(), phantom.getFigure());
        }
    }

    @Override
    public Collection<AbstractDecoratorManager.AbstractDecorator> getAllDecorators() {
        ArrayList<AbstractDecoratorManager.AbstractDecorator> phantoms = new ArrayList<AbstractDecoratorManager.AbstractDecorator>();
        for (AbstractDecoratorManager.AbstractDecorator abstractDecorator : this.fPhantomRegistry.values()) {
            phantoms.add(abstractDecorator);
        }
        return phantoms;
    }

    private class Phantom
    extends AbstractDecoratorManager.AbstractDecorator {
        Phantom(IFigure layer, IMergeViewer.MergeViewerSide side, View originView, IFigure originFigure, Diff diff) {
            super(PhantomManager.this);
            this.setLayer(layer);
            this.setSide(side);
            this.setOriginView(originView);
            this.setOriginFigure(originFigure);
            this.setDifference(diff);
        }

        public List<? extends AbstractDecoratorManager.AbstractDecorator> getDependencies() {
            ArrayList<? extends AbstractDecoratorManager.AbstractDecorator> result = new ArrayList<AbstractDecoratorManager.AbstractDecorator>();
            result.addAll(this.getAncestors());
            if (this.fOriginView instanceof Edge) {
                View source = ((Edge)this.fOriginView).getSource();
                View target = ((Edge)this.fOriginView).getTarget();
                result.addAll(PhantomManager.this.getOrCreateRelatedPhantoms((EObject)source, this.fSide));
                result.addAll(PhantomManager.this.getOrCreateRelatedPhantoms((EObject)target, this.fSide));
            }
            return result;
        }

        private List<? extends AbstractDecoratorManager.AbstractDecorator> getAncestors() {
            ArrayList result = new ArrayList();
            EObject parentOriginView = this.fOriginView.eContainer();
            while (parentOriginView != null) {
                result.addAll(PhantomManager.this.getOrCreateRelatedPhantoms(parentOriginView, this.fSide));
                parentOriginView = parentOriginView.eContainer();
            }
            return result;
        }
    }
}

