/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.framework;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.compare.conflict.DefaultConflictDetector;
import org.eclipse.emf.compare.conflict.MatchBasedConflictDetector;
import org.eclipse.emf.compare.diff.DefaultDiffEngine;
import org.eclipse.emf.compare.equi.DefaultEquiEngine;
import org.eclipse.emf.compare.ide.ui.tests.framework.EMFCompareTestConfiguration;
import org.eclipse.emf.compare.ide.ui.tests.framework.ResolutionStrategyID;
import org.eclipse.emf.compare.ide.ui.tests.framework.annotations.ConflictDetectors;
import org.eclipse.emf.compare.ide.ui.tests.framework.annotations.DiffEngines;
import org.eclipse.emf.compare.ide.ui.tests.framework.annotations.DisabledMatchEngines;
import org.eclipse.emf.compare.ide.ui.tests.framework.annotations.DisabledPostProcessors;
import org.eclipse.emf.compare.ide.ui.tests.framework.annotations.EqEngines;
import org.eclipse.emf.compare.ide.ui.tests.framework.annotations.ReqEngines;
import org.eclipse.emf.compare.ide.ui.tests.framework.annotations.ResolutionStrategies;
import org.eclipse.emf.compare.req.DefaultReqEngine;
import org.junit.Assert;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;

public abstract class AbstractCompareTestRunner
extends ParentRunner<Runner> {
    protected final List<Runner> runners;
    private final ResolutionStrategyID[] defaultResolutionStrategies = new ResolutionStrategyID[]{ResolutionStrategyID.WORKSPACE};
    private final Class<?>[] defaultDisabledMatchEngines = new Class[0];
    private final Class<?>[] defaultDiffEngines = new Class[]{DefaultDiffEngine.class};
    private final Class<?>[] defaultEqEngines = new Class[]{DefaultEquiEngine.class};
    private final Class<?>[] defaultReqEngines = new Class[]{DefaultReqEngine.class};
    private final Class<?>[] defaultConflictDetectors = new Class[]{DefaultConflictDetector.class, MatchBasedConflictDetector.class};
    private final Class<?>[] defaultDisabledPostProcessors = new Class[0];

    public AbstractCompareTestRunner(Class<?> testClass) throws InitializationError {
        super(testClass);
        this.runners = new ArrayList<Runner>();
        this.prepareRunnersForTests();
    }

    private void prepareRunnersForTests() {
        ResolutionStrategies rStrategies = (ResolutionStrategies)this.getTestClass().getAnnotation(ResolutionStrategies.class);
        ResolutionStrategyID[] resolutionStrategies = rStrategies == null ? this.defaultResolutionStrategies : rStrategies.value();
        DisabledMatchEngines mEngines = (DisabledMatchEngines)this.getTestClass().getAnnotation(DisabledMatchEngines.class);
        Class<?>[] disabledMatchEngines = mEngines == null ? this.defaultDisabledMatchEngines : mEngines.value();
        DiffEngines dEngines = (DiffEngines)this.getTestClass().getAnnotation(DiffEngines.class);
        Class<?>[] diffEngines = dEngines == null ? this.defaultDiffEngines : dEngines.value();
        EqEngines eEngines = (EqEngines)this.getTestClass().getAnnotation(EqEngines.class);
        Class<?>[] eqEngines = eEngines == null ? this.defaultEqEngines : eEngines.value();
        ReqEngines rEngines = (ReqEngines)this.getTestClass().getAnnotation(ReqEngines.class);
        Class<?>[] reqEngines = rEngines == null ? this.defaultReqEngines : rEngines.value();
        ConflictDetectors cEngines = (ConflictDetectors)this.getTestClass().getAnnotation(ConflictDetectors.class);
        Class<?>[] conflictDetectors = cEngines == null ? this.defaultConflictDetectors : cEngines.value();
        DisabledPostProcessors pProcessors = (DisabledPostProcessors)this.getTestClass().getAnnotation(DisabledPostProcessors.class);
        Class<?>[] disabledPostProcessors = pProcessors == null ? this.defaultDisabledPostProcessors : pProcessors.value();
        ResolutionStrategyID[] resolutionStrategyIDArray = resolutionStrategies;
        int n = resolutionStrategies.length;
        int n2 = 0;
        while (n2 < n) {
            ResolutionStrategyID resolutionStrategy = resolutionStrategyIDArray[n2];
            Class<?>[] classArray = diffEngines;
            int n3 = diffEngines.length;
            int n4 = 0;
            while (n4 < n3) {
                Class<?> diffEngine = classArray[n4];
                Class<?>[] classArray2 = eqEngines;
                int n5 = eqEngines.length;
                int n6 = 0;
                while (n6 < n5) {
                    Class<?> eqEngine = classArray2[n6];
                    Class<?>[] classArray3 = reqEngines;
                    int n7 = reqEngines.length;
                    int n8 = 0;
                    while (n8 < n7) {
                        Class<?> reqEngine = classArray3[n8];
                        Class<?>[] classArray4 = conflictDetectors;
                        int n9 = conflictDetectors.length;
                        int n10 = 0;
                        while (n10 < n9) {
                            Class<?> conflictDetector = classArray4[n10];
                            try {
                                EMFCompareTestConfiguration configuration = new EMFCompareTestConfiguration(disabledMatchEngines, diffEngine, eqEngine, reqEngine, conflictDetector, disabledPostProcessors);
                                this.createRunner(this.getTestClass().getJavaClass(), resolutionStrategy, configuration);
                            }
                            catch (InitializationError e) {
                                e.printStackTrace();
                                Assert.fail((String)e.getMessage());
                            }
                            ++n10;
                        }
                        ++n8;
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
    }

    public abstract void createRunner(Class<?> var1, ResolutionStrategyID var2, EMFCompareTestConfiguration var3) throws InitializationError;

    protected List<Runner> getChildren() {
        return this.runners;
    }

    protected Description describeChild(Runner child) {
        return child.getDescription();
    }

    protected void runChild(Runner child, RunNotifier notifier) {
        child.run(notifier);
    }
}

