/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.logical.modelprovider;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.internal.resources.mapping.ModelProviderManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.IModelProviderDescriptor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.EMFCompareIDEPlugin;
import org.eclipse.emf.compare.ide.logical.IModelInclusionTester;
import org.eclipse.emf.compare.ide.logical.ModelInclusionTesterRegistry;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.DefaultImplicitDependencies;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EMFModelProviderRegistrationTest {
    protected static final IWorkspace WORKSPACE = ResourcesPlugin.getWorkspace();
    protected static final IWorkspaceRoot WORKSPACE_ROOT = WORKSPACE.getRoot();
    protected static final IModelProviderDescriptor EMF_MODEL_PROVIDER = ModelProviderManager.getDefault().getDescriptor("org.eclipse.emf.compare.model.provider");
    protected static final DefaultImplicitDependencies IMPLICIT_DEPENDENCIES = new DefaultImplicitDependencies();
    protected static final URIConverter EXISTENCE_URI_CONVERTER = new ExtensibleURIConverterImpl(){

        public boolean exists(URI uri, Map<?, ?> options) {
            return true;
        }
    };

    @Before
    public void prepareModelInclusionTesterRegistry() {
        ModelInclusionTesterRegistry registry = EMFCompareIDEPlugin.getDefault().getModelInclusionTesterRegistry();
        registry.clear();
        registry.add("mock", new IModelInclusionTester(){

            public boolean shouldInclude(IFile file) {
                return file != null && ("ecore".equals(file.getFileExtension()) || "xmi".equals(file.getFileExtension()) || "uml".equals(file.getFileExtension()) || "notation".equals(file.getFileExtension()) || "di".equals(file.getFileExtension()) || "sash".equals(file.getFileExtension()) || "internationalization".equals(file.getFileExtension()) || "properties".equals(file.getFileExtension()));
            }
        });
    }

    @Test
    public void testFileExtensions() {
        Assert.assertNotNull((Object)EMF_MODEL_PROVIDER);
        this.assertMatches(this.getDependencies(this.createResourceWithFileExtension("uml")));
        this.assertMatches(this.getDependencies(this.createResourceWithFileExtension("notation")));
        this.assertMatches(this.getDependencies(this.createResourceWithFileExtension("di")));
        this.assertMatches(this.getDependencies(this.createResourceWithFileExtension("sash")));
        this.assertMatches(this.getDependencies(this.createResourceWithFileExtension("ecore")));
        this.assertMatches(this.getDependencies(this.createResourceWithFileExtension("xmi")));
        this.assertMatches(this.getDependencies(this.createResourceWithFileExtension("properties")));
        this.assertMatches(this.getDependencies(this.createResourceWithFileExtension("internationalization")));
        this.assertMatchesNot(this.createResourceWithFileExtension("unsupported"));
    }

    protected IResource createResourceWithFileExtension(String fileExtension) {
        return this.createResourceWithName("resource." + fileExtension);
    }

    protected IResource createResourceWithName(String name) {
        IFile resource = WORKSPACE_ROOT.getFile((IPath)new Path("NoProject/" + name));
        Assert.assertEquals((Object)name, (Object)resource.getName());
        return resource;
    }

    protected Set<IResource> getDependencies(IResource resource) {
        Set implicitDependencies = IMPLICIT_DEPENDENCIES.of(URI.createURI((String)resource.getName()), EXISTENCE_URI_CONVERTER);
        HashSet dependencies = Sets.newHashSet();
        for (URI implicitDependency : implicitDependencies) {
            dependencies.add(this.createResourceWithName(implicitDependency.toString()));
        }
        Assert.assertTrue((boolean)dependencies.contains(resource));
        return dependencies;
    }

    protected void assertMatches(Set<IResource> resources) {
        for (IResource resource : resources) {
            this.assertMatches(resource);
        }
    }

    protected void assertMatches(IResource resource) {
        Assert.assertNotNull((Object)resource);
        IResource[] matchingResources = new IResource[]{};
        try {
            matchingResources = EMF_MODEL_PROVIDER.getMatchingResources(new IResource[]{resource});
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        Assert.assertEquals((String)("EMF Model Provider does not support " + resource.getName()), (long)1L, (long)matchingResources.length);
        Assert.assertEquals((String)("EMF Model Provider does not support " + resource.getName()), (Object)resource, (Object)matchingResources[0]);
    }

    protected void assertMatchesNot(Set<IResource> resources) {
        for (IResource resource : resources) {
            this.assertMatchesNot(resource);
        }
    }

    protected void assertMatchesNot(IResource resource) {
        Assert.assertNotNull((Object)resource);
        IResource[] matchingResources = new IResource[]{};
        try {
            matchingResources = EMF_MODEL_PROVIDER.getMatchingResources(new IResource[]{resource});
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        Assert.assertEquals((String)("EMF Model Provider does support " + resource.getName()), (long)0L, (long)matchingResources.length);
    }
}

