/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.dependency;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ILog;
import org.eclipse.emf.compare.ide.ui.dependency.DependencyProviderDescriptor;
import org.eclipse.emf.compare.ide.ui.dependency.ModelDependencyProviderRegistry;
import org.eclipse.emf.compare.rcp.extension.AbstractRegistryEventListener;

public class ModelDependencyProviderRegistryListener
extends AbstractRegistryEventListener {
    private static final String DEPENDENCY_ELEMENT_NAME = "dependency";
    private static final String ATTRIBUTE_CLASS = "class";
    private final ModelDependencyProviderRegistry registry;

    public ModelDependencyProviderRegistryListener(String pluginID, String extensionPointID, ILog log, ModelDependencyProviderRegistry registry) {
        super(pluginID, extensionPointID, log);
        this.registry = registry;
    }

    protected boolean validateExtensionElement(IConfigurationElement element) {
        if (DEPENDENCY_ELEMENT_NAME.equals(element.getName())) {
            String className = element.getAttribute(ATTRIBUTE_CLASS);
            return className != null && className.trim().length() > 0;
        }
        return false;
    }

    protected boolean addedValid(IConfigurationElement element) {
        String className = element.getAttribute(ATTRIBUTE_CLASS);
        DependencyProviderDescriptor descriptor = new DependencyProviderDescriptor(ATTRIBUTE_CLASS, element);
        this.registry.addProvider(className, descriptor);
        return true;
    }

    protected boolean removedValid(IConfigurationElement element) {
        String className = element.getAttribute(ATTRIBUTE_CLASS);
        this.registry.removeProvider(className);
        return true;
    }
}

