/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.internal.conflict;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.diff.FeatureFilter;
import org.eclipse.emf.compare.internal.conflict.AbstractConflictSearch;
import org.eclipse.emf.compare.internal.conflict.ComparisonIndex;
import org.eclipse.emf.compare.utils.EMFCompareJavaPredicates;
import org.eclipse.emf.compare.utils.MatchUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class NonContainmentRefChangeConflictSearch {

    public static class Add
    extends AbstractConflictSearch<ReferenceChange> {
        public Add(ReferenceChange diff, ComparisonIndex index, Monitor monitor) {
            super(diff, index, monitor);
        }

        @Override
        public void detectConflicts() {
            EReference feature = ((ReferenceChange)this.diff).getReference();
            if (feature.isUnique()) {
                EObject value = ((ReferenceChange)this.diff).getValue();
                EList<Diff> diffsInSameMatch = ((ReferenceChange)this.diff).getMatch().getDifferences();
                Iterable candidates = diffsInSameMatch.stream().filter(EMFCompareJavaPredicates.possiblyConflictingWith(this.diff).and(ReferenceChange.class::isInstance).and(EMFCompareJavaPredicates.onFeature((EStructuralFeature)feature)).and(EMFCompareJavaPredicates.ofKind(DifferenceKind.ADD)))::iterator;
                for (Diff candidate : candidates) {
                    EObject candidateValue = ((ReferenceChange)candidate).getValue();
                    if (!this.comparison.getEqualityHelper().matchingValues(value, candidateValue)) continue;
                    FeatureFilter featureFilter = this.getFeatureFilter(this.comparison);
                    if (featureFilter == null || featureFilter.checkForOrderingChanges((EStructuralFeature)feature)) {
                        if (MatchUtil.matchingIndices(((ReferenceChange)this.diff).getMatch(), (EStructuralFeature)feature, value, candidateValue)) {
                            this.conflict(candidate, ConflictKind.PSEUDO);
                            continue;
                        }
                        this.conflict(candidate, ConflictKind.REAL);
                        continue;
                    }
                    this.conflict(candidate, ConflictKind.PSEUDO);
                }
            }
        }
    }

    public static class Change
    extends AbstractConflictSearch<ReferenceChange> {
        public Change(ReferenceChange diff, ComparisonIndex index, Monitor monitor) {
            super(diff, index, monitor);
        }

        @Override
        public void detectConflicts() {
            EObject value = ((ReferenceChange)this.diff).getValue();
            EReference feature = ((ReferenceChange)this.diff).getReference();
            EList<Diff> diffsInSameMatch = ((ReferenceChange)this.diff).getMatch().getDifferences();
            Iterable candidates = diffsInSameMatch.stream().filter(EMFCompareJavaPredicates.possiblyConflictingWith(this.diff).and(ReferenceChange.class::isInstance).and(EMFCompareJavaPredicates.onFeature((EStructuralFeature)feature)).and(EMFCompareJavaPredicates.ofKind(DifferenceKind.CHANGE)))::iterator;
            for (Diff candidate : candidates) {
                EObject candidateValue = ((ReferenceChange)candidate).getValue();
                if (this.comparison.getEqualityHelper().matchingValues(value, candidateValue)) {
                    this.conflict(candidate, ConflictKind.PSEUDO);
                    continue;
                }
                if (this.isFeatureMapChangeOrMergeableStringAttributeChange(this.diff, candidate)) continue;
                this.conflict(candidate, ConflictKind.REAL);
            }
        }
    }

    public static class Delete
    extends AbstractConflictSearch<ReferenceChange> {
        public Delete(ReferenceChange diff, ComparisonIndex index, Monitor monitor) {
            super(diff, index, monitor);
        }

        @Override
        public void detectConflicts() {
            EObject value = ((ReferenceChange)this.diff).getValue();
            EReference feature = ((ReferenceChange)this.diff).getReference();
            EList<Diff> diffsInSameMatch = ((ReferenceChange)this.diff).getMatch().getDifferences();
            Iterable candidates = diffsInSameMatch.stream().filter(EMFCompareJavaPredicates.possiblyConflictingWith(this.diff).and(ReferenceChange.class::isInstance).and(EMFCompareJavaPredicates.onFeature((EStructuralFeature)feature)).and(EMFCompareJavaPredicates.ofKind(DifferenceKind.MOVE, DifferenceKind.DELETE)))::iterator;
            for (Diff candidate : candidates) {
                EObject candidateValue = ((ReferenceChange)candidate).getValue();
                if (!this.comparison.getEqualityHelper().matchingValues(value, candidateValue)) continue;
                if (candidate.getKind() == DifferenceKind.MOVE) {
                    this.conflict(candidate, ConflictKind.REAL);
                    continue;
                }
                if (((ReferenceChange)this.diff).getMatch() != candidate.getMatch()) continue;
                this.conflict(candidate, ConflictKind.PSEUDO);
            }
        }
    }

    public static class Move
    extends AbstractConflictSearch<ReferenceChange> {
        public Move(ReferenceChange diff, ComparisonIndex index, Monitor monitor) {
            super(diff, index, monitor);
        }

        @Override
        public void detectConflicts() {
            EObject value = ((ReferenceChange)this.diff).getValue();
            EReference feature = ((ReferenceChange)this.diff).getReference();
            EList<Diff> diffsInSameMatch = ((ReferenceChange)this.diff).getMatch().getDifferences();
            Iterable candidates = diffsInSameMatch.stream().filter(EMFCompareJavaPredicates.possiblyConflictingWith(this.diff).and(ReferenceChange.class::isInstance).and(EMFCompareJavaPredicates.onFeature((EStructuralFeature)feature)).and(EMFCompareJavaPredicates.ofKind(DifferenceKind.MOVE)))::iterator;
            for (Diff candidate : candidates) {
                EObject candidateValue = ((ReferenceChange)candidate).getValue();
                if (!this.comparison.getEqualityHelper().matchingValues(value, candidateValue)) continue;
                if (MatchUtil.matchingIndices(((ReferenceChange)this.diff).getMatch(), (EStructuralFeature)feature, value, candidateValue)) {
                    this.conflict(candidate, ConflictKind.PSEUDO);
                    continue;
                }
                this.conflict(candidate, ConflictKind.REAL);
            }
        }
    }
}

