/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.ide.tests.profile;

import com.google.common.collect.Sets;
import java.util.HashSet;
import org.eclipse.emf.compare.ide.internal.utils.NotLoadingResourceSet;
import org.eclipse.emf.compare.uml2.ide.tests.util.ProfileTestUtil;
import org.eclipse.emf.compare.uml2.profile.test.uml2comparetestprofile.ACliche;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class ProfileLoadingTest {
    public static final String PROFILE_PATHMAP_URI = "pathmap://ProfileLoadingTest/model.profile.uml";
    private static final String ST1_PROFILE_QUALIFIED_NAME = "profile::St1";
    private static final String PROFILE_URI = "platform:/plugin/org.eclipse.emf.compare.uml2.ide.tests/src/org/eclipse/emf/compare/uml2/ide/tests/profile/data/loading/model.profile.uml";
    private static final String METAMODEL_PATHMAP_URI = "pathmap://UML_METAMODELS/UML.metamodel.uml";
    private static final String ECORE_PROFILE_PATHMAP_URI = "pathmap://UML_PROFILES/Ecore.profile.uml";
    private static final String STANDARD_PROFILE_PATHMAP_URI = "pathmap://UML_PROFILES/Standard.profile.uml";
    private NotLoadingResourceSet resourceSet;

    @After
    public void after() {
        if (this.resourceSet != null) {
            for (Resource resource : this.resourceSet.getResources()) {
                resource.unload();
            }
        }
    }

    @Test
    public void loadDynamicRelativeProfile() {
        String umlResourceURI = "platform:/plugin/org.eclipse.emf.compare.uml2.ide.tests/src/org/eclipse/emf/compare/uml2/ide/tests/profile/data/loading/relative/model.uml";
        this.resourceSet = ProfileTestUtil.createNotLoadingResourceSet(umlResourceURI);
        HashSet expectedLoadedResource = Sets.newHashSet((Object[])new String[]{PROFILE_URI, umlResourceURI, METAMODEL_PATHMAP_URI, ECORE_PROFILE_PATHMAP_URI, STANDARD_PROFILE_PATHMAP_URI});
        ProfileTestUtil.assertLoadedResources((ResourceSet)this.resourceSet, expectedLoadedResource);
        EObject stereotypeApplication = ProfileTestUtil.getStereotype((ResourceSet)this.resourceSet, String.valueOf(umlResourceURI) + "#_XzoewEIyEeSXpd1NJW5urA", ST1_PROFILE_QUALIFIED_NAME);
        Assert.assertTrue((boolean)(stereotypeApplication instanceof DynamicEObjectImpl));
    }

    @Test
    public void loadDynamicRelativeProfile2() {
        String umlResourceURI = "platform:/plugin/org.eclipse.emf.compare.uml2.ide.tests/src/org/eclipse/emf/compare/uml2/ide/tests/profile/data/loading/relative/model.uml";
        this.resourceSet = ProfileTestUtil.createNotLoadingResourceSet(umlResourceURI, PROFILE_URI);
        HashSet expectedLoadedResource = Sets.newHashSet((Object[])new String[]{PROFILE_URI, umlResourceURI, METAMODEL_PATHMAP_URI, ECORE_PROFILE_PATHMAP_URI, STANDARD_PROFILE_PATHMAP_URI});
        ProfileTestUtil.assertLoadedResources((ResourceSet)this.resourceSet, expectedLoadedResource);
        EObject stereotypeApplication = ProfileTestUtil.getStereotype((ResourceSet)this.resourceSet, String.valueOf(umlResourceURI) + "#_XzoewEIyEeSXpd1NJW5urA", ST1_PROFILE_QUALIFIED_NAME);
        Assert.assertTrue((boolean)(stereotypeApplication instanceof DynamicEObjectImpl));
    }

    @Test
    public void loadDynamicRelativeProfile3() {
        String umlResourceURI = "platform:/plugin/org.eclipse.emf.compare.uml2.ide.tests/src/org/eclipse/emf/compare/uml2/ide/tests/profile/data/loading/relative/model.uml";
        this.resourceSet = ProfileTestUtil.createNotLoadingResourceSet(PROFILE_URI, umlResourceURI);
        HashSet expectedLoadedResource = Sets.newHashSet((Object[])new String[]{PROFILE_URI, umlResourceURI, METAMODEL_PATHMAP_URI, ECORE_PROFILE_PATHMAP_URI, STANDARD_PROFILE_PATHMAP_URI});
        ProfileTestUtil.assertLoadedResources((ResourceSet)this.resourceSet, expectedLoadedResource);
        EObject stereotypeApplication = ProfileTestUtil.getStereotype((ResourceSet)this.resourceSet, String.valueOf(umlResourceURI) + "#_XzoewEIyEeSXpd1NJW5urA", ST1_PROFILE_QUALIFIED_NAME);
        Assert.assertTrue((boolean)(stereotypeApplication instanceof DynamicEObjectImpl));
    }

    @Test
    public void loadDynamicPlatformProfile() {
        String umlResourceURI = "platform:/plugin/org.eclipse.emf.compare.uml2.ide.tests/src/org/eclipse/emf/compare/uml2/ide/tests/profile/data/loading/platform/model.uml";
        this.resourceSet = ProfileTestUtil.createNotLoadingResourceSet(umlResourceURI);
        HashSet expectedLoadedResource = Sets.newHashSet((Object[])new String[]{PROFILE_URI, umlResourceURI, METAMODEL_PATHMAP_URI, ECORE_PROFILE_PATHMAP_URI, STANDARD_PROFILE_PATHMAP_URI});
        ProfileTestUtil.assertLoadedResources((ResourceSet)this.resourceSet, expectedLoadedResource);
        EObject stereotypeApplication = ProfileTestUtil.getStereotype((ResourceSet)this.resourceSet, String.valueOf(umlResourceURI) + "#_XzoewEIyEeSXpd1NJW5urA", ST1_PROFILE_QUALIFIED_NAME);
        Assert.assertTrue((boolean)(stereotypeApplication instanceof DynamicEObjectImpl));
    }

    @Test
    public void loadDynamicRegisteredProfile() {
        String umlResourceURI = "platform:/plugin/org.eclipse.emf.compare.uml2.ide.tests/src/org/eclipse/emf/compare/uml2/ide/tests/profile/data/loading/registered/model.uml";
        this.resourceSet = ProfileTestUtil.createNotLoadingResourceSet(umlResourceURI);
        HashSet expectedLoadedResource = Sets.newHashSet((Object[])new String[]{"platform:/plugin/org.eclipse.emf.compare.uml2.ide.tests/src/org/eclipse/emf/compare/uml2/ide/tests/profile/data/loading/registered/model_profile.uml", umlResourceURI, METAMODEL_PATHMAP_URI, ECORE_PROFILE_PATHMAP_URI, STANDARD_PROFILE_PATHMAP_URI, STANDARD_PROFILE_PATHMAP_URI});
        ProfileTestUtil.assertLoadedResources((ResourceSet)this.resourceSet, expectedLoadedResource);
        EObject stereotypeApplication = ProfileTestUtil.getStereotype((ResourceSet)this.resourceSet, String.valueOf(umlResourceURI) + "#_XzoewEIyEeSXpd1NJW5urA", ST1_PROFILE_QUALIFIED_NAME);
        Assert.assertTrue((boolean)(stereotypeApplication instanceof DynamicEObjectImpl));
    }

    @Test
    public void loadDynamicPathmapProfile() {
        String umlResourceURI = "platform:/plugin/org.eclipse.emf.compare.uml2.ide.tests/src/org/eclipse/emf/compare/uml2/ide/tests/profile/data/loading/pathmap/model.uml";
        this.resourceSet = ProfileTestUtil.createNotLoadingResourceSet(umlResourceURI);
        HashSet expectedLoadedResource = Sets.newHashSet((Object[])new String[]{PROFILE_PATHMAP_URI, umlResourceURI, METAMODEL_PATHMAP_URI, ECORE_PROFILE_PATHMAP_URI, STANDARD_PROFILE_PATHMAP_URI});
        ProfileTestUtil.assertLoadedResources((ResourceSet)this.resourceSet, expectedLoadedResource);
        EObject stereotypeApplication = ProfileTestUtil.getStereotype((ResourceSet)this.resourceSet, String.valueOf(umlResourceURI) + "#_XzoewEIyEeSXpd1NJW5urA", ST1_PROFILE_QUALIFIED_NAME);
        Assert.assertTrue((boolean)(stereotypeApplication instanceof DynamicEObjectImpl));
    }

    @Test
    public void loadStaticProfile() {
        String umlResourceURI = "platform:/plugin/org.eclipse.emf.compare.uml2.ide.tests/src/org/eclipse/emf/compare/uml2/ide/tests/profile/data/loading/static_/model.uml";
        this.resourceSet = ProfileTestUtil.createNotLoadingResourceSet(umlResourceURI);
        HashSet expectedLoadedResource = Sets.newHashSet((Object[])new String[]{ECORE_PROFILE_PATHMAP_URI, umlResourceURI, "pathmap://UML_COMPARE_TESTS_PROFILE/uml2.compare.testprofile.profile.uml", ECORE_PROFILE_PATHMAP_URI, METAMODEL_PATHMAP_URI, STANDARD_PROFILE_PATHMAP_URI});
        ProfileTestUtil.assertLoadedResources((ResourceSet)this.resourceSet, expectedLoadedResource);
        EObject stereotypeApplication = ProfileTestUtil.getStereotype((ResourceSet)this.resourceSet, String.valueOf(umlResourceURI) + "#_mg1YkEJqEeSsE-f8QjqLJA", "UML2CompareTestProfile::ACliche");
        Assert.assertTrue((boolean)(stereotypeApplication instanceof ACliche));
    }
}

