/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.internal.logical;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.compare.ide.internal.logical.AbstractModelInclusionTester;
import org.eclipse.emf.compare.ide.internal.logical.ContentTypeModelInclusionTester;
import org.eclipse.emf.compare.ide.internal.logical.DynamicModelInclusionTester;
import org.eclipse.emf.compare.ide.internal.logical.FileExtensionModelInclusionTester;

public class ModelInclusionTesterFactory {
    protected static final String FILE_EXTENSION = "fileExtension";
    protected static final String CONTENT_TYPE = "contentType";
    protected static final String DYNAMIC_TESTER = "dynamicTester";

    public boolean canCreateModelInclusionTester(IConfigurationElement element) {
        return this.getModelInclusionTesterType(element) != null;
    }

    public AbstractModelInclusionTester createModelInclusionTester(IConfigurationElement element) {
        switch (this.getModelInclusionTesterType(element)) {
            case "fileExtension": {
                return new FileExtensionModelInclusionTester(element.getAttribute(FILE_EXTENSION), element.getAttribute(this.getModelInclusionTesterType(element)));
            }
            case "contentType": {
                return new ContentTypeModelInclusionTester(element.getAttribute(CONTENT_TYPE), element.getAttribute(this.getModelInclusionTesterType(element)));
            }
            case "dynamicTester": {
                return new DynamicModelInclusionTester(element, element.getAttribute(this.getModelInclusionTesterType(element)));
            }
        }
        throw new IllegalArgumentException("Unknown extension type");
    }

    public String getKey(IConfigurationElement element) {
        return element.getAttribute(this.getModelInclusionTesterType(element));
    }

    private String getModelInclusionTesterType(IConfigurationElement element) {
        if (element.getAttribute(FILE_EXTENSION) != null) {
            return FILE_EXTENSION;
        }
        if (element.getAttribute(CONTENT_TYPE) != null) {
            return CONTENT_TYPE;
        }
        if (element.getAttribute(DYNAMIC_TESTER) != null) {
            return DYNAMIC_TESTER;
        }
        return null;
    }
}

