/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.domain.IMergeRunnable;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions.AbstractMergeRunnable;
import org.eclipse.emf.compare.internal.domain.IMergeAllNonConflictingRunnable;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.internal.merge.MergeOperation;
import org.eclipse.emf.compare.internal.utils.ComparisonUtil;
import org.eclipse.emf.compare.merge.AbstractMerger;
import org.eclipse.emf.compare.merge.BatchMerger;
import org.eclipse.emf.compare.merge.ComputeDiffsToMerge;
import org.eclipse.emf.compare.merge.IBatchMerger;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.merge.MergeBlockedByConflictException;
import org.eclipse.emf.compare.utils.EMFComparePredicates;

public class MergeNonConflictingRunnable
extends AbstractMergeRunnable
implements IMergeAllNonConflictingRunnable,
IMergeRunnable {
    private static final Logger LOGGER = Logger.getLogger(MergeNonConflictingRunnable.class);

    public MergeNonConflictingRunnable(boolean isLeftEditable, boolean isRightEditable, MergeMode mergeMode) {
        super(isLeftEditable, isRightEditable, mergeMode);
    }

    public Iterable<Diff> merge(Comparison comparison, boolean leftToRight, IMerger.Registry mergerRegistry) {
        Preconditions.checkState((this.getMergeMode().isLeftToRight(this.isLeftEditable(), this.isRightEditable()) == leftToRight ? 1 : 0) != 0);
        return this.doMergeNonConflicting((Collection<Diff>)comparison.getDifferences(), comparison, leftToRight, mergerRegistry);
    }

    public void merge(List<? extends Diff> differences, boolean leftToRight, IMerger.Registry mergerRegistry) {
        Preconditions.checkState((this.getMergeMode().isLeftToRight(this.isLeftEditable(), this.isRightEditable()) == leftToRight ? 1 : 0) != 0);
        Preconditions.checkState((!differences.isEmpty() && ComparisonUtil.getComparison((Diff)differences.get(0)) != null ? 1 : 0) != 0);
        Comparison comparison = ComparisonUtil.getComparison((Diff)differences.get(0));
        this.doMergeNonConflicting(differences, comparison, leftToRight, mergerRegistry);
    }

    private Iterable<Diff> doMergeNonConflicting(Collection<Diff> differences, Comparison comparison, boolean leftToRight, IMerger.Registry mergerRegistry) {
        Iterable<Diff> affectedChanges = this.hasRealConflict(comparison) ? this.mergeWithConflicts(differences, leftToRight, mergerRegistry) : (comparison.isThreeWay() ? this.mergeThreeWayWithoutConflicts(differences, leftToRight, mergerRegistry) : this.mergeTwoWay(differences, leftToRight, mergerRegistry));
        return affectedChanges;
    }

    private Iterable<Diff> mergeThreeWayWithoutConflicts(Collection<Diff> differences, boolean leftToRight, IMerger.Registry mergerRegistry) {
        List<Object> affectedDiffs;
        BatchMerger merger = new BatchMerger(mergerRegistry);
        if (this.getMergeMode() == MergeMode.LEFT_TO_RIGHT) {
            affectedDiffs = Lists.newArrayList((Iterable)Iterables.filter(differences, (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT)));
            merger.copyAllLeftToRight((Iterable)affectedDiffs, (Monitor)new BasicMonitor());
        } else if (this.getMergeMode() == MergeMode.RIGHT_TO_LEFT) {
            affectedDiffs = Lists.newArrayList((Iterable)Iterables.filter(differences, (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT)));
            merger.copyAllRightToLeft((Iterable)affectedDiffs, (Monitor)new BasicMonitor());
        } else if (this.getMergeMode() == MergeMode.ACCEPT || this.getMergeMode() == MergeMode.REJECT) {
            affectedDiffs = this.acceptOrRejectWithoutConflicts(differences, leftToRight, mergerRegistry, (IBatchMerger)merger);
        } else {
            throw new IllegalStateException();
        }
        return affectedDiffs;
    }

    private MergeOperation getMergeOperation(Diff diff) {
        return this.getMergeMode().getMergeAction(diff, this.isLeftEditable(), this.isRightEditable());
    }

    private Iterable<Diff> mergeTwoWay(Collection<Diff> differences, boolean leftToRight, IMerger.Registry mergerRegistry) {
        List<Object> affectedDiffs;
        BatchMerger merger = new BatchMerger(mergerRegistry);
        if (this.getMergeMode() == MergeMode.LEFT_TO_RIGHT) {
            affectedDiffs = Lists.newArrayList((Iterable)Iterables.filter(differences, (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT)));
            merger.copyAllLeftToRight((Iterable)affectedDiffs, (Monitor)new BasicMonitor());
        } else if (this.getMergeMode() == MergeMode.RIGHT_TO_LEFT) {
            affectedDiffs = Lists.newArrayList((Iterable)Iterables.filter(differences, (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT)));
            merger.copyAllRightToLeft((Iterable)affectedDiffs, (Monitor)new BasicMonitor());
        } else if (this.getMergeMode() == MergeMode.ACCEPT || this.getMergeMode() == MergeMode.REJECT) {
            affectedDiffs = this.acceptOrRejectWithoutConflicts(differences, leftToRight, mergerRegistry, (IBatchMerger)merger);
        } else {
            throw new IllegalStateException();
        }
        return affectedDiffs;
    }

    private Iterable<Diff> mergeWithConflicts(Collection<Diff> differences, boolean leftToRight, IMerger.Registry mergerRegistry) {
        ArrayList<Diff> affectedDiffs = new ArrayList<Diff>();
        BasicMonitor emfMonitor = new BasicMonitor();
        ComputeDiffsToMerge computer = new ComputeDiffsToMerge(!leftToRight, (IMerger.Registry2)mergerRegistry).failOnRealConflictUnless(Predicates.alwaysFalse());
        Predicate filter = this.getMergeMode() == MergeMode.RIGHT_TO_LEFT ? EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT) : (this.getMergeMode() == MergeMode.LEFT_TO_RIGHT ? EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT) : Predicates.alwaysTrue());
        HashSet conflictingDiffs = Sets.newHashSet();
        for (Diff diff : Iterables.filter(differences, (Predicate)filter)) {
            if (conflictingDiffs.contains(diff)) continue;
            try {
                Set diffsToMerge = computer.getAllDiffsToMerge(diff);
                for (Diff toMerge : diffsToMerge) {
                    this.doMergeDiffWithConflicts(leftToRight, mergerRegistry, affectedDiffs, (Monitor)emfMonitor, toMerge);
                }
            }
            catch (MergeBlockedByConflictException e) {
                conflictingDiffs.addAll(e.getConflictingDiffs());
            }
        }
        return affectedDiffs;
    }

    protected void doMergeDiffWithConflicts(boolean leftToRight, IMerger.Registry mergerRegistry, List<Diff> affectedDiffs, Monitor emfMonitor, Diff diff) {
        if (!AbstractMerger.isInTerminalState((Diff)diff)) {
            affectedDiffs.add(diff);
            IMerger merger = mergerRegistry.getHighestRankingMerger(diff);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("mergeWithConflicts(Collection<Diff>, boolean, Registry) - Selected merger for diff " + diff.hashCode() + ": " + merger.getClass().getSimpleName()));
            }
            if (this.getMergeMode() == MergeMode.LEFT_TO_RIGHT) {
                merger.copyLeftToRight(diff, emfMonitor);
            } else if (this.getMergeMode() == MergeMode.RIGHT_TO_LEFT) {
                merger.copyRightToLeft(diff, emfMonitor);
            } else if (this.getMergeMode() == MergeMode.ACCEPT || this.getMergeMode() == MergeMode.REJECT) {
                MergeOperation mergeAction = this.getMergeOperation(diff);
                if (mergeAction == MergeOperation.MARK_AS_MERGE) {
                    this.markAsMerged(diff, this.getMergeMode(), leftToRight, mergerRegistry);
                } else if (this.isLeftEditable() && !leftToRight) {
                    merger.copyRightToLeft(diff, emfMonitor);
                } else if (this.isRightEditable() && leftToRight) {
                    merger.copyLeftToRight(diff, emfMonitor);
                }
            } else {
                throw new IllegalStateException();
            }
        }
    }

    private List<Diff> acceptOrRejectWithoutConflicts(Collection<Diff> differences, boolean leftToRight, IMerger.Registry mergerRegistry, IBatchMerger merger) {
        ArrayList diffsToMarkAsMerged = Lists.newArrayList();
        ArrayList diffsToAccept = Lists.newArrayList();
        ArrayList diffsToReject = Lists.newArrayList();
        for (Diff diff : differences) {
            MergeOperation mergeAction = this.getMergeOperation(diff);
            if (mergeAction == MergeOperation.MARK_AS_MERGE) {
                diffsToMarkAsMerged.add(diff);
                continue;
            }
            if (this.isLeftEditable() && leftToRight) {
                diffsToReject.add(diff);
                continue;
            }
            diffsToAccept.add(diff);
        }
        BasicMonitor emfMonitor = new BasicMonitor();
        this.mergeAll(diffsToAccept, leftToRight, merger, mergerRegistry, (Monitor)emfMonitor);
        this.mergeAll(diffsToReject, !leftToRight, merger, mergerRegistry, (Monitor)emfMonitor);
        this.markAllAsMerged(diffsToMarkAsMerged, this.getMergeMode(), mergerRegistry);
        ArrayList affectedDiffs = Lists.newArrayList((Iterable)diffsToAccept);
        affectedDiffs.addAll(diffsToReject);
        affectedDiffs.addAll(diffsToMarkAsMerged);
        return affectedDiffs;
    }

    private boolean hasRealConflict(Comparison comparison) {
        return Iterables.any((Iterable)comparison.getConflicts(), (Predicate)EMFComparePredicates.containsConflictOfTypes((ConflictKind[])new ConflictKind[]{ConflictKind.REAL}));
    }

    private void mergeAll(Collection<? extends Diff> differences, boolean leftToRight, IBatchMerger merger, IMerger.Registry mergerRegistry, Monitor emfMonitor) {
        if (leftToRight) {
            merger.copyAllLeftToRight(differences, emfMonitor);
        } else {
            merger.copyAllRightToLeft(differences, emfMonitor);
        }
    }
}

