/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.compare.ide.ui.internal.logical.SimilarityComputer;
import org.eclipse.emf.compare.ide.ui.logical.IStorageProviderAccessor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.subscribers.Subscriber;

public class RenameDetector {
    private static final NullProgressMonitor NPM = new NullProgressMonitor();
    private final Subscriber subscriber;
    private final IStorageProviderAccessor accessor;
    private Iterable<IFile> affectedFiles;
    private Map<IFile, Optional<IFile>> sourceRenameBeforeCache = new HashMap<IFile, Optional<IFile>>();
    private Map<IFile, Optional<IFile>> sourceRenameAfterCache = new HashMap<IFile, Optional<IFile>>();
    private Map<IFile, Optional<IFile>> remoteRenameBeforeCache = new HashMap<IFile, Optional<IFile>>();
    private Map<IFile, Optional<IFile>> remoteRenameAfterCache = new HashMap<IFile, Optional<IFile>>();

    public RenameDetector(Subscriber subscriber, IStorageProviderAccessor accessor) {
        this.accessor = (IStorageProviderAccessor)Preconditions.checkNotNull((Object)accessor);
        this.subscriber = subscriber;
    }

    public Optional<IFile> getFileBeforeRename(IFile sourceOrRemoteFile, IStorageProviderAccessor.DiffSide side) {
        Preconditions.checkArgument((boolean)this.isSourceOrRemoteSide(side));
        if (!this.isFileBeforeRenameCached(sourceOrRemoteFile, side)) {
            this.cacheFileBeforeRename(this.computeFileBeforeRename(sourceOrRemoteFile, side), sourceOrRemoteFile, side);
        }
        return (Optional)this.getCachedFileBeforeRename(sourceOrRemoteFile, side).get();
    }

    public Optional<IFile> getFileAfterRename(IFile originFile, IStorageProviderAccessor.DiffSide side) {
        Preconditions.checkArgument((boolean)this.isSourceOrRemoteSide(side));
        if (!this.isFileAfterRenameCached(originFile, side)) {
            this.cacheFileAfterRename(this.computeFileAfterRename(originFile, side), originFile, side);
        }
        return (Optional)this.getCachedFileAfterRename(originFile, side).get();
    }

    private boolean isFileBeforeRenameCached(IFile sourceOrRemoteFile, IStorageProviderAccessor.DiffSide side) {
        return this.getCachedFileBeforeRename(sourceOrRemoteFile, side).isPresent();
    }

    private void cacheFileBeforeRename(Optional<IFile> fileBeforeRename, IFile sourceOrRemoteFile, IStorageProviderAccessor.DiffSide side) {
        if (IStorageProviderAccessor.DiffSide.SOURCE.equals((Object)side)) {
            this.sourceRenameBeforeCache.put(sourceOrRemoteFile, fileBeforeRename);
        } else if (IStorageProviderAccessor.DiffSide.REMOTE.equals((Object)side)) {
            this.remoteRenameBeforeCache.put(sourceOrRemoteFile, fileBeforeRename);
        }
    }

    private Optional<Optional<IFile>> getCachedFileBeforeRename(IFile sourceOrRemoteFile, IStorageProviderAccessor.DiffSide side) {
        Optional cachedFile = IStorageProviderAccessor.DiffSide.SOURCE.equals((Object)side) ? Optional.fromNullable(this.sourceRenameBeforeCache.get(sourceOrRemoteFile)) : (IStorageProviderAccessor.DiffSide.REMOTE.equals((Object)side) ? Optional.fromNullable(this.remoteRenameBeforeCache.get(sourceOrRemoteFile)) : Optional.absent());
        return cachedFile;
    }

    private boolean isFileAfterRenameCached(IFile originFile, IStorageProviderAccessor.DiffSide side) {
        return this.getCachedFileAfterRename(originFile, side).isPresent();
    }

    private void cacheFileAfterRename(Optional<IFile> fileAfterRename, IFile originFile, IStorageProviderAccessor.DiffSide side) {
        if (IStorageProviderAccessor.DiffSide.SOURCE.equals((Object)side)) {
            this.sourceRenameAfterCache.put(originFile, fileAfterRename);
        } else if (IStorageProviderAccessor.DiffSide.REMOTE.equals((Object)side)) {
            this.remoteRenameAfterCache.put(originFile, fileAfterRename);
        }
    }

    private Optional<Optional<IFile>> getCachedFileAfterRename(IFile originFile, IStorageProviderAccessor.DiffSide side) {
        Optional cachedFile = IStorageProviderAccessor.DiffSide.SOURCE.equals((Object)side) ? Optional.fromNullable(this.sourceRenameAfterCache.get(originFile)) : (IStorageProviderAccessor.DiffSide.REMOTE.equals((Object)side) ? Optional.fromNullable(this.remoteRenameAfterCache.get(originFile)) : Optional.absent());
        return cachedFile;
    }

    private boolean isSourceOrRemoteSide(IStorageProviderAccessor.DiffSide side) {
        return IStorageProviderAccessor.DiffSide.SOURCE.equals((Object)side) || IStorageProviderAccessor.DiffSide.REMOTE.equals((Object)side);
    }

    private Optional<IFile> computeFileBeforeRename(IFile sourceOrRemoteFile, IStorageProviderAccessor.DiffSide side) {
        if (this.isAddedFile(sourceOrRemoteFile, side)) {
            for (IFile removedOriginFile : this.getRemovedFiles(side)) {
                if (!this.isRename(removedOriginFile, sourceOrRemoteFile, side)) continue;
                return Optional.of((Object)removedOriginFile);
            }
        }
        return Optional.absent();
    }

    private Optional<IFile> computeFileAfterRename(IFile originFile, IStorageProviderAccessor.DiffSide side) {
        if (this.isRemovedFile(originFile, side)) {
            for (IFile addedSourceOrRemoteFile : this.getAddedFiles(side)) {
                if (!this.isRename(originFile, addedSourceOrRemoteFile, side)) continue;
                return Optional.of((Object)addedSourceOrRemoteFile);
            }
        }
        return Optional.absent();
    }

    private boolean isRemovedFile(IFile originFile, IStorageProviderAccessor.DiffSide side) {
        return this.isChangedWithDiffKind(2, side).apply((Object)originFile);
    }

    private boolean isAddedFile(IFile originFile, IStorageProviderAccessor.DiffSide side) {
        return this.isChangedWithDiffKind(1, side).apply((Object)originFile);
    }

    private Iterable<IFile> getAddedFiles(IStorageProviderAccessor.DiffSide side) {
        return Iterables.filter(this.getAffectedFiles(), this.isChangedWithDiffKind(1, side));
    }

    private Iterable<IFile> getRemovedFiles(IStorageProviderAccessor.DiffSide side) {
        return Iterables.filter(this.getAffectedFiles(), this.isChangedWithDiffKind(2, side));
    }

    private Iterable<IFile> getAffectedFiles() {
        if (this.affectedFiles == null) {
            if (this.subscriber != null) {
                List<IResource> roots = Arrays.asList(this.subscriber.roots());
                Iterable resources = Iterables.concat((Iterable)Iterables.transform(roots, this.toAllChildren()));
                this.affectedFiles = Iterables.filter((Iterable)resources, IFile.class);
            } else {
                this.affectedFiles = Collections.emptySet();
            }
        }
        return this.affectedFiles;
    }

    private boolean isRename(IFile originFile, IFile addedSourceOrRemoteFile, IStorageProviderAccessor.DiffSide side) {
        try {
            IStorage origin = this.accessor.getStorageProvider((IResource)originFile, IStorageProviderAccessor.DiffSide.ORIGIN).getStorage((IProgressMonitor)NPM);
            IStorage added = this.accessor.getStorageProvider((IResource)addedSourceOrRemoteFile, side).getStorage((IProgressMonitor)NPM);
            if (origin != null && added != null) {
                return SimilarityComputer.isSimilar(origin.getContents(), added.getContents());
            }
        }
        catch (IOException | CoreException throwable) {}
        return false;
    }

    private Function<IResource, Iterable<IResource>> toAllChildren() {
        return new Function<IResource, Iterable<IResource>>(){

            public Iterable<IResource> apply(IResource input) {
                ImmutableList.Builder allChildren = ImmutableList.builder();
                try {
                    if (input != null) {
                        IResource[] iResourceArray = RenameDetector.this.subscriber.members(input);
                        int n = iResourceArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IResource child = iResourceArray[n2];
                            allChildren.add((Object)child).addAll((Iterable)RenameDetector.this.toAllChildren().apply((Object)child));
                            ++n2;
                        }
                    }
                }
                catch (NullPointerException | TeamException throwable) {}
                return allChildren.build();
            }
        };
    }

    private Predicate<IFile> isChangedWithDiffKind(final int diffKind, final IStorageProviderAccessor.DiffSide side) {
        return new Predicate<IFile>(){

            public boolean apply(IFile input) {
                try {
                    IDiff diff;
                    if (input != null && RenameDetector.this.subscriber != null && (diff = RenameDetector.this.subscriber.getDiff((IResource)input)) != null) {
                        return RenameDetector.this.isDiffKind(diffKind, diff, side);
                    }
                }
                catch (CoreException coreException) {}
                return false;
            }
        };
    }

    private boolean isDiffKind(int diffKind, IDiff diff, IStorageProviderAccessor.DiffSide side) {
        boolean isDiffKind = false;
        if (diff instanceof IThreeWayDiff) {
            IThreeWayDiff threeWayDiff = (IThreeWayDiff)diff;
            if (IStorageProviderAccessor.DiffSide.REMOTE.equals((Object)side) && threeWayDiff.getRemoteChange() != null) {
                isDiffKind = threeWayDiff.getRemoteChange().getKind() == diffKind;
            } else if (IStorageProviderAccessor.DiffSide.SOURCE.equals((Object)side) && threeWayDiff.getLocalChange() != null) {
                isDiffKind = threeWayDiff.getLocalChange().getKind() == diffKind;
            }
        }
        return isDiffKind;
    }
}

