/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer;

import com.google.common.base.Predicate;
import com.google.common.eventbus.Subscribe;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.contentmergeviewer.ContentMergeViewer;
import org.eclipse.compare.internal.CompareHandlerService;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.command.ICompareCommandStack;
import org.eclipse.emf.compare.command.ICompareCopyCommand;
import org.eclipse.emf.compare.domain.ICompareEditingDomain;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.configuration.EMFCompareConfiguration;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.EMFCompareContentMergeViewerResourceBundle;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.DynamicObject;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.EMFCompareColor;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.RedoAction;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.UndoAction;
import org.eclipse.emf.compare.ide.ui.mergeresolution.MergeResolutionManager;
import org.eclipse.emf.compare.rcp.ui.contentmergeviewer.accessor.ICompareAccessor;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.IAdapterFactoryChange;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.ICompareEditingDomainChange;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.IColorChangeEvent;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.item.impl.MergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.internal.util.SWTUtil;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.ICompareColor;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.item.IMergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.filters.IDifferenceFilterChange;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.IDifferenceGroupProvider;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.IDifferenceGroupProviderChange;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.view.ExtendedPropertySheetPage;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemeManager;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheet;

public abstract class EMFCompareContentMergeViewer
extends ContentMergeViewer
implements ISelectionChangedListener,
ICompareColor.Provider,
IAdaptable,
CommandStackListener {
    private static final String HANDLER_SERVICE = "fHandlerService";
    protected static final int CENTER_WIDTH = 34;
    private IMergeViewer fAncestor;
    private IMergeViewer fLeft;
    private IMergeViewer fRight;
    private final AtomicBoolean fSyncingSelections = new AtomicBoolean(false);
    private EMFCompareColor fColors;
    private final DynamicObject fDynamicObject = new DynamicObject((Object)this);
    private UndoAction undoAction;
    private RedoAction redoAction;
    private AdapterFactoryContentProvider fAdapterFactoryContentProvider;
    private Predicate<? super EObject> differenceFilterPredicate;
    private IDifferenceGroupProvider differenceGroupProvider;
    private MergeResolutionManager mergeResolutionManager;

    protected EMFCompareContentMergeViewer(int style, ResourceBundle bundle, EMFCompareConfiguration cc) {
        super(style, (ResourceBundle)new EMFCompareContentMergeViewerResourceBundle(bundle), (CompareConfiguration)cc);
        if (this.getCompareConfiguration().getAdapterFactory() != null) {
            this.fAdapterFactoryContentProvider = new AdapterFactoryContentProvider(this.getCompareConfiguration().getAdapterFactory());
        }
        this.redoAction = new RedoAction(this.getCompareConfiguration().getEditingDomain());
        this.undoAction = new UndoAction(this.getCompareConfiguration().getEditingDomain());
        this.editingDomainChange(null, this.getCompareConfiguration().getEditingDomain());
        this.getCompareConfiguration().getEventBus().register((Object)this);
        this.mergeResolutionManager = new MergeResolutionManager(EMFCompareIDEUIPlugin.getDefault().getMergeResolutionListenerRegistry());
    }

    @Subscribe
    public void handleAdapterFactoryChange(IAdapterFactoryChange event) {
        AdapterFactory oldValue = event.getOldValue();
        AdapterFactory newValue = event.getNewValue();
        if (oldValue != null) {
            this.fAdapterFactoryContentProvider.dispose();
        }
        if (newValue != oldValue) {
            this.fAdapterFactoryContentProvider = new AdapterFactoryContentProvider(newValue);
        }
    }

    @Subscribe
    public void colorChanged(IColorChangeEvent changeColorEvent) {
        this.getControl().redraw();
    }

    @Subscribe
    public void handleEditingDomainChange(ICompareEditingDomainChange event) {
        ICompareEditingDomain oldValue = event.getOldValue();
        ICompareEditingDomain newValue = event.getNewValue();
        this.editingDomainChange(oldValue, newValue);
    }

    protected void editingDomainChange(ICompareEditingDomain oldValue, ICompareEditingDomain newValue) {
        ICompareCommandStack commandStack;
        if (oldValue != null) {
            commandStack = oldValue.getCommandStack();
            commandStack.removeCommandStackListener((CommandStackListener)this);
        }
        if (newValue != oldValue) {
            if (newValue != null) {
                commandStack = newValue.getCommandStack();
                commandStack.addCommandStackListener((CommandStackListener)this);
                this.setLeftDirty(commandStack.isLeftSaveNeeded());
                this.setRightDirty(commandStack.isRightSaveNeeded());
            }
            this.undoAction.setEditingDomain(newValue);
            this.redoAction.setEditingDomain(newValue);
        }
    }

    @Subscribe
    public void handleDifferenceFiltersChange(IDifferenceFilterChange event) {
        this.differenceFilterPredicate = event.getPredicate();
        this.redrawCenterControl();
    }

    protected final Predicate<? super EObject> getDifferenceFilterPredicate() {
        if (this.differenceFilterPredicate == null) {
            this.differenceFilterPredicate = this.getCompareConfiguration().getStructureMergeViewerFilter().getAggregatedPredicate();
        }
        return this.differenceFilterPredicate;
    }

    @Subscribe
    public void handleDifferenceGroupProviderChange(IDifferenceGroupProviderChange event) {
        this.differenceGroupProvider = event.getDifferenceGroupProvider();
        this.redrawCenterControl();
    }

    protected final IDifferenceGroupProvider getDifferenceGroupProvider() {
        if (this.differenceGroupProvider == null) {
            this.differenceGroupProvider = this.getCompareConfiguration().getStructureMergeViewerGrouper().getProvider();
        }
        return this.differenceGroupProvider;
    }

    public ICompareColor getCompareColor() {
        return this.fColors;
    }

    protected void updateContent(Object ancestor, Object left, Object right) {
        this.fAncestor.setInput(ancestor);
        this.fLeft.setInput(left);
        this.fRight.setInput(right);
        IMergeViewerItem leftInitialItem = null;
        if (left instanceof ICompareAccessor) {
            leftInitialItem = ((ICompareAccessor)left).getInitialItem();
        }
        if (leftInitialItem == null) {
            if (right instanceof ICompareAccessor) {
                IMergeViewerItem rightInitialItem = ((ICompareAccessor)right).getInitialItem();
                if (rightInitialItem == null) {
                    this.fLeft.setSelection((ISelection)StructuredSelection.EMPTY, true);
                } else {
                    this.fRight.setSelection((ISelection)new StructuredSelection((Object)rightInitialItem), true);
                }
            } else {
                this.fLeft.setSelection((ISelection)StructuredSelection.EMPTY, true);
            }
        } else {
            this.fLeft.setSelection((ISelection)new StructuredSelection((Object)leftInitialItem), true);
        }
        this.redrawCenterControl();
    }

    protected boolean doSave(Object newInput, Object oldInput) {
        return false;
    }

    protected void createControls(Composite composite) {
        this.fAncestor = this.createMergeViewer(composite, IMergeViewer.MergeViewerSide.ANCESTOR);
        this.fAncestor.addSelectionChangedListener((ISelectionChangedListener)this);
        this.fLeft = this.createMergeViewer(composite, IMergeViewer.MergeViewerSide.LEFT);
        this.fLeft.addSelectionChangedListener((ISelectionChangedListener)this);
        this.fRight = this.createMergeViewer(composite, IMergeViewer.MergeViewerSide.RIGHT);
        this.fRight.addSelectionChangedListener((ISelectionChangedListener)this);
        ITheme currentTheme = this.getCurrentTheme();
        boolean leftIsLocal = this.getCompareConfiguration().getBooleanProperty("LEFT_IS_LOCAL", false);
        this.fColors = new EMFCompareColor(composite.getDisplay(), leftIsLocal, currentTheme, this.getCompareConfiguration().getEventBus());
        composite.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                EMFCompareContentMergeViewer.this.redrawCenterControl();
            }

            public void controlMoved(ControlEvent e) {
            }
        });
    }

    private ITheme getCurrentTheme() {
        IThemeManager themeManager;
        if (PlatformUI.isWorkbenchRunning() && (themeManager = PlatformUI.getWorkbench().getThemeManager()) != null) {
            return themeManager.getCurrentTheme();
        }
        return null;
    }

    protected void createToolItems(final ToolBarManager toolBarManager) {
        IWorkbench workbench;
        IMenuService menuService;
        IContributionItem[] items;
        this.getHandlerService().setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
        this.getHandlerService().setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
        IContributionItem[] iContributionItemArray = items = toolBarManager.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem iContributionItem = iContributionItemArray[n2];
            if (iContributionItem instanceof ActionContributionItem) {
                IAction action = ((ActionContributionItem)iContributionItem).getAction();
                String id = action.getActionDefinitionId();
                if ("org.eclipse.compare.copyAllLeftToRight".equals(id)) {
                    toolBarManager.remove(iContributionItem);
                } else if ("org.eclipse.compare.copyAllRightToLeft".equals(id)) {
                    toolBarManager.remove(iContributionItem);
                }
            }
            ++n2;
        }
        if (PlatformUI.isWorkbenchRunning() && (menuService = (IMenuService)(workbench = PlatformUI.getWorkbench()).getService(IMenuService.class)) != null) {
            menuService.populateContributionManager((ContributionManager)toolBarManager, "toolbar:org.eclipse.emf.compare.contentmergeviewer.toolbar");
            toolBarManager.getControl().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    menuService.releaseContributions((ContributionManager)toolBarManager);
                }
            });
        }
    }

    public void commandStackChanged(EventObject event) {
        IMergeViewer affectedMergeViewer;
        Command mostRecentCommand;
        this.undoAction.update();
        this.redoAction.update();
        if (this.getCompareConfiguration().getEditingDomain() != null) {
            ICompareCommandStack commandStack = this.getCompareConfiguration().getEditingDomain().getCommandStack();
            this.setLeftDirty(commandStack.isLeftSaveNeeded());
            this.setRightDirty(commandStack.isRightSaveNeeded());
        }
        if ((mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand()) instanceof ICompareCopyCommand) {
            SWTUtil.safeRefresh((Viewer)this, (boolean)true, (boolean)false);
        } else if (mostRecentCommand != null && (affectedMergeViewer = this.getAffectedMergeViewer(mostRecentCommand)) instanceof Viewer) {
            SWTUtil.safeRefresh((Viewer)((Viewer)affectedMergeViewer), (boolean)true, (boolean)false);
        }
    }

    private IMergeViewer getAffectedMergeViewer(Command command) {
        Object firstAffectedObject;
        IMergeViewer leftMergeViewer = this.getLeftMergeViewer();
        ISelection leftSelection = leftMergeViewer.getSelection();
        Collection affectedObjects = command.getAffectedObjects();
        Object viewer = affectedObjects != null && !affectedObjects.isEmpty() ? ((firstAffectedObject = affectedObjects.iterator().next()).equals(this.getElement(leftSelection, IMergeViewer.MergeViewerSide.LEFT)) ? leftMergeViewer : (firstAffectedObject.equals(this.getElement(leftSelection, IMergeViewer.MergeViewerSide.RIGHT)) ? this.getRightMergeViewer() : (firstAffectedObject.equals(this.getElement(leftSelection, IMergeViewer.MergeViewerSide.ANCESTOR)) ? this.getAncestorMergeViewer() : null))) : null;
        return viewer;
    }

    private Object getElement(ISelection selection, IMergeViewer.MergeViewerSide side) {
        Object firstElement;
        Object element = selection instanceof TreeSelection ? ((firstElement = ((TreeSelection)selection).getFirstElement()) instanceof IMergeViewerItem ? (IMergeViewer.MergeViewerSide.LEFT == side ? ((IMergeViewerItem)firstElement).getLeft() : (IMergeViewer.MergeViewerSide.RIGHT == side ? ((IMergeViewerItem)firstElement).getRight() : (IMergeViewer.MergeViewerSide.ANCESTOR == side ? ((IMergeViewerItem)firstElement).getAncestor() : null))) : null) : null;
        return element;
    }

    protected void copy(boolean leftToRight) {
    }

    protected void handleResizeAncestor(int x, int y, int width, int height) {
        if (width > 0) {
            this.getAncestorMergeViewer().getControl().setVisible(true);
            this.getAncestorMergeViewer().getControl().setBounds(x, y, width, height);
        } else {
            this.getAncestorMergeViewer().getControl().setVisible(false);
        }
    }

    protected void handleResizeLeftRight(int x, int y, int width1, int centerWidth, int width2, int height) {
        this.fLeft.getControl().setBounds(x, y, width1, height);
        this.fRight.getControl().setBounds(x + width1 + centerWidth, y, width2, height);
    }

    protected abstract IMergeViewer createMergeViewer(Composite var1, IMergeViewer.MergeViewerSide var2);

    protected final int getCenterWidth() {
        return 34;
    }

    protected final CompareHandlerService getHandlerService() {
        return (CompareHandlerService)this.fDynamicObject.get(HANDLER_SERVICE);
    }

    public Composite getControl() {
        return (Composite)super.getControl();
    }

    protected Control createCenterControl(final Composite parent) {
        final Sash ret = (Sash)super.createCenterControl(parent);
        final SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SWTUtil.safeAsyncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        parent.layout();
                    }
                });
            }
        };
        ret.addSelectionListener((SelectionListener)selectionListener);
        final PaintListener paintListener = new PaintListener(){

            public void paintControl(PaintEvent e) {
                EMFCompareContentMergeViewer.this.paintCenter(e.gc);
            }
        };
        ret.addPaintListener(paintListener);
        ret.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ret.removePaintListener(paintListener);
                ret.removeSelectionListener((SelectionListener)selectionListener);
            }
        });
        return ret;
    }

    protected abstract void paintCenter(GC var1);

    public Object getAdapter(Class adapter) {
        if (adapter == CompareHandlerService.class) {
            return this.getHandlerService();
        }
        if (adapter == CompareHandlerService[].class) {
            return new CompareHandlerService[]{this.getHandlerService()};
        }
        return null;
    }

    protected IMergeViewer getAncestorMergeViewer() {
        return this.fAncestor;
    }

    protected IMergeViewer getLeftMergeViewer() {
        return this.fLeft;
    }

    protected IMergeViewer getRightMergeViewer() {
        return this.fRight;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.synchronizeSelection(event);
        this.updateToolItems();
    }

    private void synchronizeSelection(SelectionChangedEvent event) {
        if (this.fSyncingSelections.compareAndSet(false, true)) {
            try {
                ISelection selection = event.getSelection();
                this.updatePropertiesView(selection);
                this.fLeft.setSelection(selection, true);
                this.fRight.setSelection(selection, true);
                this.fAncestor.setSelection(selection, true);
            }
            finally {
                this.fSyncingSelections.set(false);
            }
        }
    }

    private void updatePropertiesView(ISelection selection) {
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        if (selection instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)selection;
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            final ExtendedPropertySheetPage propertySheetPage = this.getExtendedPropertySheetPage(page);
            if (propertySheetPage != null) {
                StructuredSelection selectionForPropertySheet = null;
                final IWorkbenchPart activePart = page.getActivePart();
                Object firstElement = structuredSelection.getFirstElement();
                if (firstElement instanceof MergeViewerItem) {
                    MergeViewerItem mergeViewerItem = (MergeViewerItem)firstElement;
                    IMergeViewer.MergeViewerSide side = mergeViewerItem.getSide();
                    Object newSelectedObject = mergeViewerItem.getSideValue(side);
                    propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)this.fAdapterFactoryContentProvider);
                    this.getControl().addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent e) {
                            propertySheetPage.selectionChanged(activePart, null);
                            propertySheetPage.setPropertySourceProvider(null);
                        }
                    });
                    if (newSelectedObject != null) {
                        if (newSelectedObject instanceof EObject) {
                            this.manageReadOnly((EObject)newSelectedObject, side);
                        }
                        selectionForPropertySheet = new StructuredSelection(newSelectedObject);
                        propertySheetPage.selectionChanged(activePart, (ISelection)selectionForPropertySheet);
                    }
                }
                if (selectionForPropertySheet == null) {
                    selectionForPropertySheet = new StructuredSelection(new Object());
                    propertySheetPage.selectionChanged(activePart, (ISelection)selectionForPropertySheet);
                }
            }
        }
    }

    private ExtendedPropertySheetPage getExtendedPropertySheetPage(IWorkbenchPage activePage) {
        IViewPart view;
        ExtendedPropertySheetPage propertyPage = null;
        if (activePage != null && (view = activePage.findView("org.eclipse.ui.views.PropertySheet")) != null && view instanceof PropertySheet) {
            PropertySheet propertySheet = (PropertySheet)view;
            IPage currentPage = propertySheet.getCurrentPage();
            if (currentPage instanceof ExtendedPropertySheetPage) {
                propertyPage = (ExtendedPropertySheetPage)currentPage;
            } else {
                IEditorPart activeEditor = activePage.getActiveEditor();
                if (activeEditor != null && Platform.getAdapterManager().hasAdapter((Object)activeEditor, "org.eclipse.ui.views.properties.IPropertySheetPage")) {
                    propertySheet.partActivated(activePage.getActivePart());
                }
            }
        }
        return propertyPage;
    }

    private void manageReadOnly(EObject selectedObject, IMergeViewer.MergeViewerSide side) {
        if (IMergeViewer.MergeViewerSide.LEFT == side) {
            if (!this.getCompareConfiguration().isLeftEditable()) {
                this.setToReadOnly(selectedObject);
            }
        } else if (IMergeViewer.MergeViewerSide.RIGHT == side) {
            if (!this.getCompareConfiguration().isRightEditable()) {
                this.setToReadOnly(selectedObject);
            }
        } else if (IMergeViewer.MergeViewerSide.ANCESTOR == side) {
            this.setToReadOnly(selectedObject);
        }
    }

    private void setToReadOnly(EObject selectedObject) {
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)selectedObject);
        if (editingDomain instanceof AdapterFactoryEditingDomain) {
            Resource r = selectedObject.eResource();
            Map resourceToReadOnlyMap = ((AdapterFactoryEditingDomain)editingDomain).getResourceToReadOnlyMap();
            if (!resourceToReadOnlyMap.containsKey(r)) {
                resourceToReadOnlyMap.put(r, Boolean.TRUE);
            }
        }
    }

    protected Diff getDiffFrom(IMergeViewer viewer) {
        Diff diff = null;
        ISelection selection = viewer.getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            Iterator selectedElements = ((IStructuredSelection)selection).iterator();
            while (diff == null && selectedElements.hasNext()) {
                Object element = selectedElements.next();
                if (!(element instanceof IMergeViewerItem)) continue;
                diff = ((IMergeViewerItem)element).getDiff();
            }
        }
        return diff;
    }

    protected void handleDispose(DisposeEvent event) {
        this.editingDomainChange(this.getCompareConfiguration().getEditingDomain(), null);
        this.getCompareConfiguration().getEventBus().unregister((Object)this);
        this.differenceGroupProvider = null;
        this.undoAction = null;
        this.redoAction = null;
        if (this.fAdapterFactoryContentProvider != null) {
            this.fAdapterFactoryContentProvider.setAdapterFactory(null);
        }
        super.handleDispose(event);
    }

    protected final void redrawCenterControl() {
        if (this.getCenterControl() != null) {
            SWTUtil.safeRedraw((Control)this.getCenterControl(), (boolean)false);
        }
    }

    protected EMFCompareConfiguration getCompareConfiguration() {
        return (EMFCompareConfiguration)super.getCompareConfiguration();
    }

    protected void flushContent(Object input, IProgressMonitor monitor) {
        super.flushContent(input, monitor);
        this.mergeResolutionManager.handleFlush(input);
    }
}

