/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.egit.internal.merge;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IModelProviderDescriptor;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.RemoteResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.egit.core.Activator;

public final class LogicalModels {
    private static final Set<String> ignoredModelDescriptors = new HashSet<String>(Arrays.asList("org.eclipse.core.resources.modelProvider", "org.eclipse.jdt.ui.modelProvider", "org.eclipse.egit.ui.changeSetModel"));
    private Map<IResource, Set<IResource>> models = new HashMap<IResource, Set<IResource>>();

    public void build(Set<IResource> resources, RemoteResourceMappingContext remoteMappingContext) {
        for (IResource supervisedResource : resources) {
            if (!(supervisedResource instanceof IFile) || this.models.containsKey(supervisedResource)) continue;
            Set<IResource> model = LogicalModels.discoverModel(supervisedResource, (ResourceMappingContext)remoteMappingContext);
            for (IResource resourceInModel : model) {
                this.models.put(resourceInModel, model);
            }
        }
    }

    public Set<IResource> getModel(IResource resource) {
        return this.models.get(resource);
    }

    public static Set<IResource> discoverModel(IResource resource, ResourceMappingContext mappingContext) {
        LinkedHashSet<IResource> model = new LinkedHashSet<IResource>();
        LinkedHashSet<IResource> newResources = new LinkedHashSet<IResource>();
        newResources.add(resource);
        do {
            LinkedHashSet<IResource> temp = newResources;
            newResources = new LinkedHashSet();
            for (IResource res : temp) {
                Set<ResourceMapping> mappings = LogicalModels.getResourceMappings(Collections.singleton(res), mappingContext);
                newResources.addAll(LogicalModels.collectResources(mappings, mappingContext));
            }
        } while (model.addAll(newResources));
        return model;
    }

    public static <T> T findAdapter(Set<IResource> model, Class<T> adapterClass) throws CoreException {
        if (model.isEmpty()) {
            return null;
        }
        IResource[] modelArray = model.toArray(new IResource[model.size()]);
        IModelProviderDescriptor[] descriptors = ModelProvider.getModelProviderDescriptors();
        int i = 0;
        while (i < descriptors.length) {
            ModelProvider provider;
            Object adapter;
            IResource[] matchingResources;
            IModelProviderDescriptor descriptor = descriptors[i];
            if (!ignoredModelDescriptors.contains(descriptor.getId()) && (matchingResources = descriptor.getMatchingResources(modelArray)).length == modelArray.length && (adapter = (provider = descriptor.getModelProvider()).getAdapter(adapterClass)) != null) {
                return (T)adapter;
            }
            ++i;
        }
        return null;
    }

    public static Set<ResourceMapping> getResourceMappings(Set<IResource> model, ResourceMappingContext mappingContext) {
        IModelProviderDescriptor[] descriptors;
        LinkedHashSet<ResourceMapping> allMappings = new LinkedHashSet<ResourceMapping>();
        IResource[] modelArray = model.toArray(new IResource[model.size()]);
        IModelProviderDescriptor[] iModelProviderDescriptorArray = descriptors = ModelProvider.getModelProviderDescriptors();
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IModelProviderDescriptor descriptor = iModelProviderDescriptorArray[n2];
            if (!ignoredModelDescriptors.contains(descriptor.getId())) {
                try {
                    IResource[] matchingResources = descriptor.getMatchingResources(modelArray);
                    if (matchingResources.length > 0) {
                        ModelProvider modelProvider = descriptor.getModelProvider();
                        ResourceMapping[] modelMappings = modelProvider.getMappings(modelArray, mappingContext, (IProgressMonitor)new NullProgressMonitor());
                        allMappings.addAll(Arrays.asList(modelMappings));
                    }
                }
                catch (CoreException e) {
                    Activator.logError((String)e.getMessage(), (Throwable)e);
                }
            }
            ++n2;
        }
        return allMappings;
    }

    private static Set<IResource> collectResources(Set<ResourceMapping> mappings, ResourceMappingContext mappingContext) {
        LinkedHashSet<IResource> resources = new LinkedHashSet<IResource>();
        for (ResourceMapping mapping : mappings) {
            try {
                ResourceTraversal[] traversals;
                ResourceTraversal[] resourceTraversalArray = traversals = mapping.getTraversals(mappingContext, (IProgressMonitor)new NullProgressMonitor());
                int n = traversals.length;
                int n2 = 0;
                while (n2 < n) {
                    ResourceTraversal traversal = resourceTraversalArray[n2];
                    resources.addAll(Arrays.asList(traversal.getResources()));
                    ++n2;
                }
            }
            catch (CoreException e) {
                Activator.logError((String)e.getMessage(), (Throwable)e);
            }
        }
        return resources;
    }
}

