/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.internal.factories.extensions;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.diagram.internal.extensions.DiagramDiff;
import org.eclipse.emf.compare.diagram.internal.extensions.ExtensionsFactory;
import org.eclipse.emf.compare.diagram.internal.extensions.NodeChange;
import org.eclipse.emf.compare.diagram.internal.factories.AbstractDiagramChangeFactory;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeChangeFactory
extends AbstractDiagramChangeFactory {
    public Class<? extends Diff> getExtensionKind() {
        return NodeChange.class;
    }

    public DiagramDiff createExtension() {
        return ExtensionsFactory.eINSTANCE.createNodeChange();
    }

    public void setRefiningChanges(Diff extension, DifferenceKind extensionKind, Diff refiningDiff) {
        extension.getRefinedBy().add((Object)refiningDiff);
        extension.getRefinedBy().addAll((Collection)this.getAllContainedDifferences(refiningDiff));
    }

    public void fillRequiredDifferences(Comparison comparison, Diff extension) {
        super.fillRequiredDifferences(comparison, extension);
        this.fillRequiredDifferencesForMove(comparison, extension);
    }

    private void fillRequiredDifferencesForMove(Comparison comparison, Diff extension) {
        HashSet requiredExtensions = new HashSet();
        HashSet requiringExtensions = new HashSet();
        Predicate moveReference = Predicates.and((Predicate)Predicates.instanceOf(ReferenceChange.class), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE));
        Collection refiningMoves = Collections2.filter((Collection)extension.getRefinedBy(), (Predicate)moveReference);
        for (Diff diff : refiningMoves) {
            EObject target = ((ReferenceChange)diff).getValue();
            if (!(target instanceof View)) continue;
            EObject semanticTarget = ((View)target).getElement();
            Collection requiredDiffs = Collections2.filter((Collection)comparison.getDifferences(semanticTarget), (Predicate)moveReference);
            requiredExtensions.addAll(requiredDiffs);
            requiringExtensions.addAll(requiredDiffs);
        }
        extension.getRequires().addAll(requiredExtensions);
        extension.getRequiredBy().addAll(requiringExtensions);
    }

    public static Predicate<Diff> isMainDiffForAddOrDeleteNode() {
        return new Predicate<Diff>(){

            public boolean apply(Diff difference) {
                return difference instanceof ReferenceChange && (NodeChangeFactory.isRelatedToAnAddNode((ReferenceChange)difference) || NodeChangeFactory.isRelatedToADeleteNode((ReferenceChange)difference));
            }
        };
    }

    public static Predicate<Diff> isMainDiffForMoveNode() {
        return new Predicate<Diff>(){

            public boolean apply(Diff difference) {
                return difference instanceof ReferenceChange && NodeChangeFactory.isRelatedToAMoveNode((ReferenceChange)difference);
            }
        };
    }

    protected Collection<Diff> getAllDifferencesForChange(Diff input) {
        return input.getMatch().getDifferences();
    }

    protected boolean isRelatedToAnExtensionAdd(ReferenceChange input) {
        return this.isExclusive() && NodeChangeFactory.isRelatedToAnAddNode(input);
    }

    protected static boolean isRelatedToAnAddNode(ReferenceChange input) {
        return NodeChangeFactory.isContainmentOnSemanticNode(input) && input.getKind() == DifferenceKind.ADD;
    }

    protected boolean isRelatedToAnExtensionDelete(ReferenceChange input) {
        return this.isExclusive() && NodeChangeFactory.isRelatedToADeleteNode(input);
    }

    protected static boolean isRelatedToADeleteNode(ReferenceChange input) {
        return NodeChangeFactory.isContainmentOnSemanticNode(input) && input.getKind() == DifferenceKind.DELETE;
    }

    protected boolean isRelatedToAnExtensionMove(ReferenceChange input) {
        return this.isExclusive() && NodeChangeFactory.isRelatedToAMoveNode(input);
    }

    protected static boolean isRelatedToAMoveNode(ReferenceChange input) {
        return NodeChangeFactory.isContainmentOnSemanticNode(input) && input.getKind() == DifferenceKind.MOVE;
    }

    protected boolean isExclusive() {
        return this.getExtensionKind() == NodeChange.class;
    }

    private static boolean isContainmentOnSemanticNode(ReferenceChange input) {
        return input.getReference().isContainment() && input.getValue() instanceof Node && ReferenceUtil.safeEGet((EObject)input.getValue(), (EStructuralFeature)NotationPackage.Literals.VIEW__ELEMENT) != null;
    }
}

