/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.provider;

import org.eclipse.compare.ICompareInputLabelProvider;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.ide.internal.utils.StoragePathAdapter;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.provider.TreeNodeCompareInput;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;

public class TreeNodeCompareInputLabelProvider
implements ICompareInputLabelProvider {
    public Image getImage(Object element) {
        return null;
    }

    public String getText(Object element) {
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public String getAncestorLabel(Object input) {
        Match match = this.getMatch((EObject)this.getTreeNode(input));
        if (match != null) {
            if (match.getOrigin() != null) {
                EObject origin = match.getOrigin();
                Resource originResource = origin.eResource();
                StoragePathAdapter adapter = this.getStoragePathAdapter(originResource);
                if (adapter != null) {
                    return this.computeLabel(adapter);
                }
            } else {
                return this.computeFallbackLabel(match, Side.ORIGIN);
            }
        }
        return null;
    }

    public Image getAncestorImage(Object input) {
        return null;
    }

    public String getLeftLabel(Object input) {
        Match match = this.getMatch((EObject)this.getTreeNode(input));
        if (match != null) {
            if (match.getLeft() != null) {
                EObject left = match.getLeft();
                Resource leftResource = left.eResource();
                StoragePathAdapter adapter = this.getStoragePathAdapter(leftResource);
                if (adapter != null) {
                    return this.computeLabel(adapter);
                }
            } else {
                return this.computeFallbackLabel(match, Side.LEFT);
            }
        }
        return null;
    }

    public Image getLeftImage(Object input) {
        return null;
    }

    public String getRightLabel(Object input) {
        Match match = this.getMatch((EObject)this.getTreeNode(input));
        if (match != null) {
            if (match.getRight() != null) {
                EObject right = match.getRight();
                Resource rightResource = right.eResource();
                StoragePathAdapter adapter = this.getStoragePathAdapter(rightResource);
                if (adapter != null) {
                    return this.computeLabel(adapter);
                }
            } else {
                return this.computeFallbackLabel(match, Side.RIGHT);
            }
        }
        return null;
    }

    public Image getRightImage(Object input) {
        return null;
    }

    private TreeNode getTreeNode(Object input) {
        if (input instanceof TreeNodeCompareInput && ((TreeNodeCompareInput)((Object)input)).getTarget() instanceof TreeNode) {
            return (TreeNode)((TreeNodeCompareInput)((Object)input)).getTarget();
        }
        return null;
    }

    private Match getMatch(EObject object) {
        Object match = object instanceof Match ? (Match)object : (object instanceof Diff ? (object.eContainer() instanceof MatchResource ? null : ((Diff)object).getMatch()) : (object instanceof TreeNode ? this.getMatch(((TreeNode)object).getData()) : null));
        return match;
    }

    private StoragePathAdapter getStoragePathAdapter(Resource resource) {
        for (Adapter adapter : resource.eAdapters()) {
            if (!(adapter instanceof StoragePathAdapter)) continue;
            return (StoragePathAdapter)adapter;
        }
        return null;
    }

    private String computeLabel(StoragePathAdapter adapter) {
        if (adapter.isLocal()) {
            return "Local: " + adapter.getStoragePath();
        }
        return "Remote: " + adapter.getStoragePath();
    }

    private String computeFallbackLabel(Match match, Side side) {
        EObject parent = match.eContainer();
        while (parent instanceof Match) {
            Resource resource = this.getResourceOnSide((Match)parent, side);
            if (resource != null) {
                StoragePathAdapter adapter = this.getStoragePathAdapter(resource);
                return this.computeLabel(adapter);
            }
            parent = parent.eContainer();
        }
        return null;
    }

    private Resource getResourceOnSide(Match match, Side side) {
        Resource resource = null;
        switch (side) {
            case LEFT: {
                if (match.getLeft() == null) break;
                resource = match.getLeft().eResource();
                break;
            }
            case RIGHT: {
                if (match.getRight() == null) break;
                resource = match.getRight().eResource();
                break;
            }
            case ORIGIN: {
                if (match.getOrigin() == null) break;
                resource = match.getOrigin().eResource();
                break;
            }
        }
        return resource;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Side {
        LEFT,
        RIGHT,
        ORIGIN;

    }
}

