/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.eobject;

import com.google.common.base.Function;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.BasicEObjectImpl;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.InternalEList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EUriFragmentFunction
implements Function<EObject, String> {
    private final String[] ESCAPE;

    public EUriFragmentFunction() {
        String[] stringArray = new String[64];
        stringArray[0] = "%00";
        stringArray[1] = "%01";
        stringArray[2] = "%02";
        stringArray[3] = "%03";
        stringArray[4] = "%04";
        stringArray[5] = "%05";
        stringArray[6] = "%06";
        stringArray[7] = "%07";
        stringArray[8] = "%08";
        stringArray[9] = "%09";
        stringArray[10] = "%0A";
        stringArray[11] = "%0B";
        stringArray[12] = "%0C";
        stringArray[13] = "%0D";
        stringArray[14] = "%0E";
        stringArray[15] = "%0F";
        stringArray[16] = "%10";
        stringArray[17] = "%11";
        stringArray[18] = "%12";
        stringArray[19] = "%13";
        stringArray[20] = "%14";
        stringArray[21] = "%15";
        stringArray[22] = "%16";
        stringArray[23] = "%17";
        stringArray[24] = "%18";
        stringArray[25] = "%19";
        stringArray[26] = "%1A";
        stringArray[27] = "%1B";
        stringArray[28] = "%1C";
        stringArray[29] = "%1D";
        stringArray[30] = "%1E";
        stringArray[31] = "%1F";
        stringArray[32] = "%20";
        stringArray[34] = "%22";
        stringArray[35] = "%23";
        stringArray[37] = "%25";
        stringArray[38] = "%26";
        stringArray[39] = "%27";
        stringArray[44] = "%2C";
        stringArray[47] = "%2F";
        stringArray[58] = "%3A";
        stringArray[60] = "%3C";
        stringArray[62] = "%3E";
        this.ESCAPE = stringArray;
    }

    public String apply(EObject input) {
        EObject container = input.eContainer();
        EStructuralFeature feat = input.eContainingFeature();
        if (container instanceof BasicEObjectImpl) {
            return this.eURIFragmentSegment(container, feat, input);
        }
        return null;
    }

    public String eURIFragmentSegment(EObject container, EStructuralFeature eStructuralFeature, EObject eObject) {
        EStructuralFeature actualFeature = eStructuralFeature;
        if (actualFeature == null) {
            EContentsEList.FeatureIterator crossReferences = (EContentsEList.FeatureIterator)((InternalEList)container.eCrossReferences()).basicIterator();
            while (crossReferences.hasNext()) {
                EObject crossReference = (EObject)crossReferences.next();
                if (crossReference != eObject) continue;
                actualFeature = crossReferences.feature();
            }
        }
        assert (actualFeature != null);
        StringBuilder result = new StringBuilder();
        result.append('@');
        result.append(actualFeature.getName());
        if (actualFeature instanceof EAttribute) {
            FeatureMap featureMap = (FeatureMap)container.eGet(actualFeature, false);
            int i = 0;
            int size = featureMap.size();
            while (i < size) {
                EStructuralFeature entryFeature;
                if (featureMap.getValue(i) == eObject && (entryFeature = featureMap.getEStructuralFeature(i)) instanceof EReference && ((EReference)entryFeature).isContainment()) {
                    result.append('.');
                    result.append(i);
                    return result.toString();
                }
                ++i;
            }
            result.append(".-1");
        } else if (actualFeature.isMany()) {
            EList eKeys = ((EReference)actualFeature).getEKeys();
            if (eKeys.isEmpty()) {
                EList eList = (EList)container.eGet(actualFeature, false);
                int index = eList.indexOf((Object)eObject);
                result.append('.');
                result.append(index);
            } else {
                EAttribute[] eAttributes = (EAttribute[])((BasicEList)eKeys).data();
                result.append('[');
                int i = 0;
                int size = eAttributes.length;
                while (i < size) {
                    EAttribute eAttribute = eAttributes[i];
                    if (eAttribute == null) break;
                    if (i != 0) {
                        result.append(',');
                    }
                    result.append(eAttribute.getName());
                    result.append('=');
                    EDataType eDataType = eAttribute.getEAttributeType();
                    EFactory eFactory = eDataType.getEPackage().getEFactoryInstance();
                    if (eAttribute.isMany()) {
                        List values = (List)eObject.eGet((EStructuralFeature)eAttribute);
                        result.append('[');
                        if (!values.isEmpty()) {
                            Iterator j = values.iterator();
                            this.eEncodeValue(result, eFactory, eDataType, j.next());
                            while (j.hasNext()) {
                                result.append(',');
                                this.eEncodeValue(result, eFactory, eDataType, j.next());
                            }
                        }
                        result.append(']');
                    } else {
                        this.eEncodeValue(result, eFactory, eDataType, eObject.eGet((EStructuralFeature)eAttribute));
                    }
                    ++i;
                }
                result.append(']');
            }
        }
        return result.toString();
    }

    private void eEncodeValue(StringBuilder result, EFactory eFactory, EDataType eDataType, Object value) {
        String stringValue = eFactory.convertToString(eDataType, value);
        if (stringValue == null) {
            result.append("null");
        } else {
            int length = stringValue.length();
            result.ensureCapacity(result.length() + length + 2);
            result.append('\'');
            int i = 0;
            while (i < length) {
                String escape;
                char character = stringValue.charAt(i);
                if (character < this.ESCAPE.length && (escape = this.ESCAPE[character]) != null) {
                    result.append(escape);
                } else {
                    result.append(character);
                }
                ++i;
            }
            result.append('\'');
        }
    }
}

