/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.EMFCompareStructureMergeViewer;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.WrappableTreeViewer;
import org.eclipse.emf.compare.internal.AbstractCompareECrossReferencerAdapter;
import org.eclipse.emf.compare.internal.merge.MergeDependenciesUtil;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.IEMFCompareConfiguration;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.emf.edit.tree.TreePackage;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyData {
    private final IEMFCompareConfiguration compareConfiguration;
    private Set<Diff> requires;
    private Set<Diff> rejectedDiffs;
    private final WrappableTreeViewer treeViewer;
    private TreeNodeCrossReferencer treeNodeToDiffCrossReferencer;
    private static final Function<Object, EObject> ADAPTER__TARGET__DATA = new Function<Object, EObject>(){

        public EObject apply(Object object) {
            return EMFCompareStructureMergeViewer.getDataOfTreeNodeOfAdapter(object);
        }
    };

    public DependencyData(IEMFCompareConfiguration compareConfiguration, WrappableTreeViewer treeViewer) {
        this.compareConfiguration = compareConfiguration;
        this.treeViewer = treeViewer;
        this.requires = Sets.newHashSet();
        this.rejectedDiffs = Sets.newHashSet();
    }

    public void updateDependencies(ISelection selection, IMerger.Registry mergerRegistry) {
        boolean leftEditable = this.compareConfiguration.isLeftEditable();
        boolean rightEditable = this.compareConfiguration.isRightEditable();
        if (leftEditable || rightEditable) {
            Iterable selectedDiffs = Iterables.filter(DependencyData.getSelectedComparisonObjects(selection), Diff.class);
            MergeMode mergePreviewMode = this.compareConfiguration.getMergePreviewMode();
            this.requires = Sets.newHashSet();
            this.rejectedDiffs = Sets.newHashSet();
            Iterator iterator = selectedDiffs.iterator();
            while (iterator.hasNext()) {
                Diff diff;
                boolean leftToRight = mergePreviewMode.isLeftToRight(diff = (Diff)iterator.next(), leftEditable, rightEditable);
                this.requires.addAll(MergeDependenciesUtil.getAllResultingMerges((Diff)diff, (IMerger.Registry)mergerRegistry, (!leftToRight ? 1 : 0) != 0));
                this.requires.remove(diff);
                this.rejectedDiffs.addAll(MergeDependenciesUtil.getAllResultingRejections((Diff)diff, (IMerger.Registry)mergerRegistry, (!leftToRight ? 1 : 0) != 0));
                this.rejectedDiffs.remove(diff);
            }
        }
    }

    public void updateTreeItemMappings() {
        Tree tree = this.treeViewer.getTree();
        if (this.isDummyChild(tree.getItems())) {
            this.treeViewer.createChildren((Widget)tree);
        }
        ArrayList<TreeNode> needCrossReferencer = new ArrayList<TreeNode>();
        TreeNodeCrossReferencer crossReferencer = null;
        TreeItem[] treeItemArray = tree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem root = treeItemArray[n2];
            TreeNode rootNode = this.getTreeNodeFromAdapter(root.getData());
            Adapter adapter = EcoreUtil.getExistingAdapter((Notifier)rootNode, TreeNodeCrossReferencer.class);
            if (adapter instanceof TreeNodeCrossReferencer) {
                crossReferencer = (TreeNodeCrossReferencer)adapter;
            } else {
                needCrossReferencer.add(rootNode);
            }
            ++n2;
        }
        if (crossReferencer == null) {
            crossReferencer = new TreeNodeCrossReferencer();
        }
        for (TreeNode needy : needCrossReferencer) {
            needy.eAdapters().add((Object)crossReferencer);
        }
        this.treeNodeToDiffCrossReferencer = crossReferencer;
    }

    private TreeNode getTreeNodeFromAdapter(Object data) {
        Notifier target;
        if (data instanceof Adapter && (target = ((Adapter)data).getTarget()) instanceof TreeNode) {
            return (TreeNode)target;
        }
        return null;
    }

    private static List<EObject> getSelectedComparisonObjects(ISelection selection) {
        ArrayList ret = Lists.newArrayList();
        if (selection instanceof IStructuredSelection) {
            List selectedObjects = ((IStructuredSelection)selection).toList();
            Iterable data = Iterables.transform((Iterable)selectedObjects, ADAPTER__TARGET__DATA);
            Iterable notNullData = Iterables.filter((Iterable)data, (Predicate)Predicates.notNull());
            Iterables.addAll((Collection)ret, (Iterable)notNullData);
        }
        return ret;
    }

    public Set<Diff> getRequires() {
        return this.requires;
    }

    public Set<Diff> getRejections() {
        return this.rejectedDiffs;
    }

    public Collection<TreeNode> getTreeNodes(Diff diff) {
        Collection settings = this.treeNodeToDiffCrossReferencer.getNonNavigableInverseReferences((EObject)diff, false);
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(settings.size());
        for (EStructuralFeature.Setting setting : settings) {
            EObject referencing = setting.getEObject();
            if (!(referencing instanceof TreeNode)) continue;
            nodes.add((TreeNode)referencing);
        }
        return nodes;
    }

    private boolean isDummyChild(TreeItem[] items) {
        return items.length == 1 && items[0].getData() == null;
    }

    private static class TreeNodeCrossReferencer
    extends AbstractCompareECrossReferencerAdapter {
        private TreeNodeCrossReferencer() {
        }

        protected boolean isIncluded(EReference eReference) {
            return eReference == TreePackage.Literals.TREE_NODE__DATA;
        }

        protected void addAdapter(Notifier notifier) {
            if (notifier instanceof TreeNode) {
                super.addAdapter(notifier);
            }
        }

        public boolean isAdapterForType(Object type) {
            return type == TreeNodeCrossReferencer.class;
        }
    }
}

