/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.tree;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ide.ui.internal.configuration.EMFCompareConfiguration;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.EMFCompareContentMergeViewer;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.tree.TreeContentMergeViewerContentProvider;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.rcp.ui.contentmergeviewer.accessor.ICompareAccessor;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.IEMFCompareConfiguration;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.impl.AbstractMergeViewer;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.impl.TreeMergeViewer;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.item.impl.MergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.internal.util.MergeViewerUtil;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.ICompareColor;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.item.IMergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.IDifferenceGroupProvider;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeContentMergeViewer
extends EMFCompareContentMergeViewer {
    private static final String BUNDLE_NAME = TreeContentMergeViewer.class.getName();
    private final ComposedAdapterFactory fAdapterFactory = new ComposedAdapterFactory((ComposedAdapterFactory.Descriptor.Registry)EMFCompareRCPPlugin.getDefault().createFilteredAdapterFactoryRegistry());
    private AtomicBoolean fSyncExpandedState;
    private double[] fBasicCenterCurve;

    public TreeContentMergeViewer(Composite parent, EMFCompareConfiguration config) {
        super(0, ResourceBundle.getBundle(BUNDLE_NAME), config);
        this.fAdapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        this.fAdapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.fSyncExpandedState = new AtomicBoolean();
        this.buildControl(parent);
        this.setContentProvider((IContentProvider)new TreeContentMergeViewerContentProvider(config));
    }

    @Override
    protected void handleDispose(DisposeEvent event) {
        this.fAdapterFactory.dispose();
        super.handleDispose(event);
    }

    protected TreeMergeViewer getAncestorMergeViewer() {
        return (TreeMergeViewer)super.getAncestorMergeViewer();
    }

    protected TreeMergeViewer getLeftMergeViewer() {
        return (TreeMergeViewer)super.getLeftMergeViewer();
    }

    protected TreeMergeViewer getRightMergeViewer() {
        return (TreeMergeViewer)super.getRightMergeViewer();
    }

    protected byte[] getContents(boolean left) {
        return null;
    }

    protected AbstractMergeViewer createMergeViewer(Composite parent, final IMergeViewer.MergeViewerSide side) {
        TreeMergeViewer mergeTreeViewer = new TreeMergeViewer(parent, side, (ICompareColor.Provider)this, (IEMFCompareConfiguration)this.getCompareConfiguration());
        AdapterFactoryContentProvider contentProvider = new AdapterFactoryContentProvider((AdapterFactory)this.fAdapterFactory){

            public Object[] getElements(Object object) {
                if (object instanceof ICompareAccessor) {
                    return ((ICompareAccessor)object).getItems().toArray();
                }
                return super.getElements(object);
            }

            public Object[] getChildren(Object object) {
                if (object instanceof IMergeViewerItem.Container) {
                    Object[] children = ((IMergeViewerItem.Container)object).getChildren(TreeContentMergeViewer.this.getDifferenceGroupProvider(), TreeContentMergeViewer.this.getDifferenceFilterPredicate());
                    return children;
                }
                return super.getChildren(object);
            }

            public boolean hasChildren(Object object) {
                if (object instanceof IMergeViewerItem.Container) {
                    return ((IMergeViewerItem.Container)object).hasChildren(TreeContentMergeViewer.this.getDifferenceGroupProvider(), TreeContentMergeViewer.this.getDifferenceFilterPredicate());
                }
                return super.hasChildren(object);
            }

            public Object getParent(Object object) {
                if (object instanceof IMergeViewerItem.Container) {
                    return ((IMergeViewerItem.Container)object).getParent();
                }
                return super.getParent(object);
            }
        };
        mergeTreeViewer.setContentProvider((IContentProvider)contentProvider);
        AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)this.fAdapterFactory){

            public String getText(Object object) {
                if (object instanceof IMergeViewerItem) {
                    IMergeViewerItem mergeViewerItem = (IMergeViewerItem)object;
                    Object value = mergeViewerItem.getSideValue(side);
                    String text = value instanceof EObject && ((EObject)value).eIsProxy() ? "proxy : " + ((InternalEObject)value).eProxyURI().toString() : (mergeViewerItem.isInsertionPoint() ? "                                          " : (value == null && mergeViewerItem.getSideValue(side.opposite()) instanceof Resource ? TreeContentMergeViewer.this.getResourceBundle().getString("UnkownResource") : (value == null && mergeViewerItem.getLeft() == null && mergeViewerItem.getRight() == null && mergeViewerItem.getAncestor() instanceof Resource ? TreeContentMergeViewer.this.getResourceBundle().getString("UnkownResource") : super.getText(value))));
                    return text;
                }
                return super.getText(object);
            }

            public Image getImage(Object object) {
                if (object instanceof IMergeViewerItem) {
                    IMergeViewerItem mergeViewerItem = (IMergeViewerItem)object;
                    if (mergeViewerItem.isInsertionPoint()) {
                        return null;
                    }
                    if (mergeViewerItem.getSideValue(side) == null && mergeViewerItem.getSideValue(side.opposite()) instanceof Resource) {
                        return super.getImage(mergeViewerItem.getSideValue(side.opposite()));
                    }
                    if (mergeViewerItem.getLeft() == null && mergeViewerItem.getRight() == null && mergeViewerItem.getAncestor() instanceof Resource) {
                        return super.getImage(mergeViewerItem.getAncestor());
                    }
                    return super.getImage(mergeViewerItem.getSideValue(side));
                }
                return super.getImage(object);
            }
        };
        mergeTreeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        mergeTreeViewer.getStructuredViewer().getTree().addListener(18, (Listener)new ExpandCollapseListener(mergeTreeViewer, false));
        mergeTreeViewer.getStructuredViewer().getTree().addListener(17, (Listener)new ExpandCollapseListener(mergeTreeViewer, true));
        mergeTreeViewer.getStructuredViewer().getTree().getVerticalBar().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TreeContentMergeViewer.this.redrawCenterControl();
            }
        });
        mergeTreeViewer.getStructuredViewer().getTree().addMouseWheelListener(new MouseWheelListener(){

            public void mouseScrolled(MouseEvent e) {
                TreeContentMergeViewer.this.redrawCenterControl();
            }
        });
        mergeTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TreeContentMergeViewer.this.redrawCenterControl();
            }
        });
        return mergeTreeViewer;
    }

    @Override
    protected void paintCenter(GC g) {
        TreeMergeViewer leftMergeViewer = this.getLeftMergeViewer();
        TreeMergeViewer rightMergeViewer = this.getRightMergeViewer();
        Tree leftTree = leftMergeViewer.getStructuredViewer().getTree();
        Tree rightTree = rightMergeViewer.getStructuredViewer().getTree();
        Rectangle leftClientArea = leftTree.getClientArea();
        Rectangle rightClientArea = rightTree.getClientArea();
        List<TreeItem> leftItems = this.getExpandedTreeItems(leftTree);
        List<TreeItem> rightItems = this.getExpandedTreeItems(rightTree);
        ImmutableSet selection = ImmutableSet.copyOf((Object[])leftTree.getSelection());
        for (TreeItem leftItem : leftItems) {
            TreeItem rightItem;
            boolean selected = Iterables.any((Iterable)selection, (Predicate)Predicates.equalTo((Object)leftItem));
            IMergeViewerItem leftData = (IMergeViewerItem)leftItem.getData();
            Diff leftDiff = leftData.getDiff();
            if (leftDiff == null || !MergeViewerUtil.isVisibleInMergeViewer((Diff)leftDiff, (IDifferenceGroupProvider)this.getDifferenceGroupProvider(), this.getDifferenceFilterPredicate()) || MergeViewerUtil.isMarkAsMerged((Diff)leftDiff, (IMergeViewerItem)leftData, (IEMFCompareConfiguration)this.getCompareConfiguration()) || (rightItem = this.findRightTreeItemFromLeftDiff(rightItems, leftDiff, leftData)) == null) continue;
            Color strokeColor = this.getCompareColor().getStrokeColor(leftDiff, this.isThreeWay(), false, selected);
            g.setForeground(strokeColor);
            this.drawCenterLine(g, leftClientArea, rightClientArea, leftItem, rightItem);
        }
    }

    @Override
    protected void createToolItems(ToolBarManager toolBarManager) {
        IContributionItem[] items;
        super.createToolItems(toolBarManager);
        IContributionItem[] iContributionItemArray = items = toolBarManager.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem iContributionItem = iContributionItemArray[n2];
            if (iContributionItem instanceof ActionContributionItem) {
                IAction action = ((ActionContributionItem)iContributionItem).getAction();
                String id = action.getActionDefinitionId();
                if ("org.eclipse.compare.copyAllLeftToRight".equals(id)) {
                    toolBarManager.remove(iContributionItem);
                } else if ("org.eclipse.compare.copyAllRightToLeft".equals(id)) {
                    toolBarManager.remove(iContributionItem);
                }
            }
            ++n2;
        }
    }

    private List<TreeItem> getExpandedTreeItems(Tree tree) {
        return this.getExpandedTreeItems(tree.getItems());
    }

    private List<TreeItem> getExpandedTreeItems(TreeItem[] items) {
        ArrayList ret = Lists.newArrayList();
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            ret.add(item);
            if (item.getExpanded()) {
                ret.addAll(this.getExpandedTreeItems(item.getItems()));
            }
            ++n2;
        }
        return ret;
    }

    private void drawCenterLine(GC g, Rectangle leftClientArea, Rectangle rightClientArea, TreeItem leftItem, TreeItem rightItem) {
        Control control = this.getCenterControl();
        Point from = new Point(0, 0);
        Point to = new Point(0, 0);
        Rectangle leftBounds = leftItem.getBounds();
        Rectangle rightBounds = rightItem.getBounds();
        from.y = leftBounds.y + leftBounds.height / 2 - leftClientArea.y;
        if ("gtk".equals(SWT.getPlatform())) {
            --from.y;
        } else if ("win32".equals(SWT.getPlatform())) {
            ++from.y;
        }
        to.x = control.getBounds().width;
        to.y = rightBounds.y + rightBounds.height / 2 - rightClientArea.y;
        if ("gtk".equals(SWT.getPlatform())) {
            --to.y;
        } else if ("win32".equals(SWT.getPlatform())) {
            ++to.y;
        }
        int[] points = this.getCenterCurvePoints(from, to);
        int i = 1;
        while (i < points.length) {
            g.drawLine(from.x + i - 1, points[i - 1], i, points[i]);
            ++i;
        }
    }

    private TreeItem findRightTreeItemFromLeftDiff(List<TreeItem> rightItems, Diff leftDiff, IMergeViewerItem leftData) {
        TreeItem ret = null;
        for (TreeItem rightItem : rightItems) {
            IMergeViewerItem rightData = (IMergeViewerItem)rightItem.getData();
            Diff rightDiff = rightData.getDiff();
            if (leftDiff == rightDiff) {
                return rightItem;
            }
            if (rightData.getAncestor() != leftData.getAncestor() || rightData.getRight() != leftData.getRight() || rightData.getLeft() != leftData.getLeft()) continue;
            ret = rightItem;
        }
        return ret;
    }

    private int[] getCenterCurvePoints(Point from, Point to) {
        int startx = from.x;
        int starty = from.y;
        int endx = to.x;
        int endy = to.y;
        if (this.fBasicCenterCurve == null) {
            this.buildBaseCenterCurve(endx - startx);
        }
        double height = endy - starty;
        height /= 2.0;
        int width = endx - startx;
        int[] points = new int[width];
        int i = 0;
        while (i < width) {
            points[i] = (int)(-height * this.fBasicCenterCurve[i] + height + (double)starty);
            ++i;
        }
        return points;
    }

    private void buildBaseCenterCurve(int w) {
        double width = w;
        this.fBasicCenterCurve = new double[this.getCenterWidth()];
        int i = 0;
        while (i < this.getCenterWidth()) {
            double r = (double)i / width;
            this.fBasicCenterCurve[i] = Math.cos(Math.PI * r);
            ++i;
        }
    }

    private final class ExpandCollapseListener
    implements Listener {
        private final TreeMergeViewer mergeTreeViewer;
        private boolean expanded;

        private ExpandCollapseListener(TreeMergeViewer mergeTreeViewer, boolean expanded) {
            this.mergeTreeViewer = mergeTreeViewer;
            this.expanded = expanded;
        }

        public void handleEvent(Event e) {
            Comparison comparison;
            Match match;
            Object data = e.item.getData();
            ArrayList toBeExpanded = Lists.newArrayList();
            toBeExpanded.add(data);
            Object parent = TreeContentMergeViewer.this.getLeftMergeViewer() == this.mergeTreeViewer ? ((IMergeViewerItem)data).getLeft() : (TreeContentMergeViewer.this.getRightMergeViewer() == this.mergeTreeViewer ? ((IMergeViewerItem)data).getRight() : ((IMergeViewerItem)data).getAncestor());
            if (parent instanceof EObject && (match = (comparison = TreeContentMergeViewer.this.getCompareConfiguration().getComparison()).getMatch((EObject)parent)) != null) {
                for (Diff referenceChange : Iterables.filter((Iterable)match.getDifferences(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(ReferenceChange.class), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE)))) {
                    MergeViewerItem.Container container;
                    Match match2;
                    EObject ancestor;
                    EObject eContainer;
                    Match matchOfValue;
                    if (TreeContentMergeViewer.this.getLeftMergeViewer() == this.mergeTreeViewer) {
                        matchOfValue = comparison.getMatch(((ReferenceChange)referenceChange).getValue());
                        if (matchOfValue == null) continue;
                        EObject right = matchOfValue.getRight();
                        if (right != null) {
                            eContainer = right.eContainer();
                        } else {
                            ancestor = matchOfValue.getOrigin();
                            eContainer = ancestor.eContainer();
                        }
                        match2 = comparison.getMatch(eContainer);
                        if (match2 == null || match2.getLeft() == parent) continue;
                        container = new MergeViewerItem.Container(TreeContentMergeViewer.this.getCompareConfiguration().getComparison(), null, match2, IMergeViewer.MergeViewerSide.RIGHT, (AdapterFactory)TreeContentMergeViewer.this.fAdapterFactory);
                        toBeExpanded.add(container);
                        continue;
                    }
                    if (TreeContentMergeViewer.this.getRightMergeViewer() != this.mergeTreeViewer || (matchOfValue = comparison.getMatch(((ReferenceChange)referenceChange).getValue())) == null) continue;
                    EObject left = matchOfValue.getLeft();
                    if (left != null) {
                        eContainer = left.eContainer();
                    } else {
                        ancestor = matchOfValue.getOrigin();
                        eContainer = ancestor.eContainer();
                    }
                    match2 = comparison.getMatch(eContainer);
                    if (match2 == null || match2.getRight() == parent) continue;
                    container = new MergeViewerItem.Container(TreeContentMergeViewer.this.getCompareConfiguration().getComparison(), null, match2, IMergeViewer.MergeViewerSide.LEFT, (AdapterFactory)TreeContentMergeViewer.this.fAdapterFactory);
                    toBeExpanded.add(container);
                }
            }
            try {
                if (TreeContentMergeViewer.this.fSyncExpandedState.compareAndSet(false, true)) {
                    for (Object object : toBeExpanded) {
                        TreeContentMergeViewer.this.getLeftMergeViewer().setExpandedState(object, this.expanded);
                        TreeContentMergeViewer.this.getRightMergeViewer().setExpandedState(object, this.expanded);
                        TreeContentMergeViewer.this.getAncestorMergeViewer().setExpandedState(object, this.expanded);
                    }
                }
            }
            finally {
                TreeContentMergeViewer.this.getCenterControl().redraw();
                TreeContentMergeViewer.this.fSyncExpandedState.set(false);
            }
        }
    }
}

